/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.DefaultConfigurationKey;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHierarchicalConfiguration {
    private static final String NEW_NAME = "alteredName";
    private BaseHierarchicalConfiguration config;

    private static DefaultConfigurationKey createConfigurationKey() {
        return new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE);
    }

    private void checkChildConfigurationsAtWithUpdates(boolean withUpdates, String expectedName) {
        String key = "tables.table(0)";
        List children = withUpdates ? this.config.childConfigurationsAt("tables.table(0)", true) : this.config.childConfigurationsAt("tables.table(0)");
        Assert.assertEquals((String)"Wrong number of elements", (long)2L, (long)children.size());
        HierarchicalConfiguration sub = (HierarchicalConfiguration)children.get(0);
        sub.setProperty(null, (Object)NEW_NAME);
        Assert.assertEquals((String)"Wrong value in parent", (Object)expectedName, (Object)this.config.getString("tables.table(0).name"));
    }

    private void checkConfigurationAtAttributeNode(boolean withUpdates) {
        String key = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        this.config.configurationAt("tables.table(0)[@type]", withUpdates);
    }

    private void checkConfigurationsAtWithUpdate(boolean withUpdates, String expName) {
        String key = "tables.table(1).fields.field";
        List lstFlds = withUpdates ? this.config.configurationsAt("tables.table(1).fields.field", true) : this.config.configurationsAt("tables.table(1).fields.field");
        this.checkSubConfigurations(lstFlds);
        ((HierarchicalConfiguration)lstFlds.get(0)).setProperty("name", (Object)NEW_NAME);
        Assert.assertEquals((String)"Wrong name in parent", (Object)expName, (Object)this.config.getString("tables.table(1).fields.field(0).name"));
    }

    private void checkContent(Configuration c) {
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assert.assertEquals((Object)NodeStructureHelper.table(i), (Object)c.getString("tables.table(" + i + ").name"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assert.assertEquals((Object)NodeStructureHelper.field(i, j), (Object)c.getString("tables.table(" + i + ").fields.field(" + j + ").name"));
            }
        }
    }

    private void checkSubConfigurations(List<? extends ImmutableConfiguration> lstFlds) {
        Assert.assertEquals((String)"Wrong size of fields", (long)NodeStructureHelper.fieldsLength(1), (long)lstFlds.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            ImmutableConfiguration sub = lstFlds.get(i);
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)NodeStructureHelper.field(1, i), (Object)sub.getString("name"));
        }
    }

    @Before
    public void setUp() throws Exception {
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        this.config = new BaseHierarchicalConfiguration();
        this.config.getNodeModel().setRootNode(root);
    }

    @Test
    public void testChildConfigurationsAtNotFound() {
        Assert.assertTrue((String)"Got children", (boolean)this.config.childConfigurationsAt("not.existing.key").isEmpty());
    }

    @Test
    public void testChildConfigurationsAtNoUniqueKey() {
        Assert.assertTrue((String)"Got children", (boolean)this.config.childConfigurationsAt("tables.table").isEmpty());
    }

    @Test
    public void testChildConfigurationsAtNoUpdates() {
        this.checkChildConfigurationsAtWithUpdates(false, NodeStructureHelper.table(0));
    }

    @Test
    public void testChildConfigurationsAtWithUpdates() {
        this.checkChildConfigurationsAtWithUpdates(true, NEW_NAME);
    }

    @Test
    public void testClone() {
        Configuration copy = (Configuration)this.config.clone();
        Assert.assertTrue((boolean)(copy instanceof BaseHierarchicalConfiguration));
        this.config.setProperty("tables.table(0).name", (Object)"changed table name");
        this.checkContent(copy);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtAttributeNode() {
        this.checkConfigurationAtAttributeNode(false);
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtAttributeNodeWithUpdates() {
        this.checkConfigurationAtAttributeNode(true);
    }

    @Test
    public void testConfigurationAtClearAndDetach() {
        this.config.addProperty("test.sub.test", (Object)"success");
        this.config.addProperty("test.other", (Object)"check");
        HierarchicalConfiguration sub = this.config.configurationAt("test.sub", true);
        sub.clear();
        Assert.assertTrue((String)"Sub not empty", (boolean)sub.isEmpty());
        Assert.assertNull((String)"Key still found", (Object)this.config.getString("test.sub.test"));
        sub.setProperty("test", (Object)"failure!");
        Assert.assertNull((String)"Node not detached", (Object)this.config.getString("test.sub.test"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtMultipleNodes() {
        this.config.configurationAt("tables.table.name");
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtMultipleNodesWithUpdates() {
        this.config.configurationAt("tables.table.name", true);
    }

    @Test
    public void testConfigurationAtReadAccess() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        Assert.assertEquals((String)"Wrong table name", (Object)NodeStructureHelper.table(1), (Object)subConfig.getString("name"));
        List lstFlds = subConfig.getList("fields.field.name");
        Assert.assertEquals((String)"Wrong number of fields", (long)NodeStructureHelper.fieldsLength(1), (long)lstFlds.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)NodeStructureHelper.field(1, i), lstFlds.get(i));
        }
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtUnknownSubTree() {
        this.config.configurationAt("non.existing.key");
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testConfigurationAtUnknownSubTreeWithUpdates() {
        this.config.configurationAt("non.existing.key", true);
    }

    @Test
    public void testConfigurationAtUpdateParentConnected() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)", true);
        this.config.setProperty("tables.table(1).fields.field(2).name", (Object)"testField");
        Assert.assertEquals((String)"Change visible in sub config", (Object)"testField", (Object)subConfig.getString("fields.field(2).name"));
    }

    @Test
    public void testConfigurationAtUpdateParentIndependent() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        this.config.setProperty("tables.table(1).fields.field(2).name", (Object)"testField");
        Assert.assertEquals((String)"Change visible in sub config", (Object)NodeStructureHelper.field(1, 2), (Object)subConfig.getString("fields.field(2).name"));
    }

    @Test
    public void testConfigurationAtUpdateSubConfigConnected() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)", true);
        subConfig.setProperty("name", (Object)"testTable");
        Assert.assertEquals((String)"Change not visible in parent", (Object)"testTable", (Object)this.config.getString("tables.table(1).name"));
    }

    @Test
    public void testConfigurationAtUpdateSubConfigIndependent() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        subConfig.setProperty("name", (Object)"testTable");
        Assert.assertEquals((String)"Value not changed", (Object)"testTable", (Object)subConfig.getString("name"));
        Assert.assertEquals((String)"Change visible in parent", (Object)NodeStructureHelper.table(1), (Object)this.config.getString("tables.table(1).name"));
    }

    @Test
    public void testConfigurationAtWithUpdateInitialized() {
        String key = "tables.table";
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        this.config.setThrowExceptionOnMissing(true);
        List subs = this.config.configurationsAt("tables.table", true);
        BaseHierarchicalConfiguration sub = (BaseHierarchicalConfiguration)subs.get(0);
        Assert.assertEquals((String)"Wrong delimiter handler", (Object)this.config.getListDelimiterHandler(), (Object)sub.getListDelimiterHandler());
        Assert.assertTrue((String)"Wrong exception flag", (boolean)sub.isThrowExceptionOnMissing());
    }

    @Test
    public void testConfigurationsAtAttributeKey() {
        String attrKey = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"user");
        Assert.assertTrue((String)"Got configurations", (boolean)this.config.configurationsAt("tables.table(0)[@type]").isEmpty());
    }

    @Test
    public void testConfigurationsAtEmpty() {
        Assert.assertTrue((String)"List is not empty", (boolean)this.config.configurationsAt("unknown.key").isEmpty());
    }

    @Test
    public void testConfigurationsAtNoUpdate() {
        this.checkConfigurationsAtWithUpdate(false, NodeStructureHelper.field(1, 0));
    }

    @Test
    public void testConfigurationsAtWithUpdates() {
        this.checkConfigurationsAtWithUpdate(true, NEW_NAME);
    }

    @Test
    public void testImmutableChildConfigurationsAt() {
        List children = this.config.immutableChildConfigurationsAt("tables.table(0)");
        Assert.assertEquals((String)"Wrong number of elements", (long)2L, (long)children.size());
        ImmutableHierarchicalConfiguration c1 = (ImmutableHierarchicalConfiguration)children.get(0);
        Assert.assertEquals((String)"Wrong name (1)", (Object)"name", (Object)c1.getRootElementName());
        Assert.assertEquals((String)"Wrong table name", (Object)NodeStructureHelper.table(0), (Object)c1.getString(null));
        ImmutableHierarchicalConfiguration c2 = (ImmutableHierarchicalConfiguration)children.get(1);
        Assert.assertEquals((String)"Wrong name (2)", (Object)"fields", (Object)c2.getRootElementName());
        Assert.assertEquals((String)"Wrong field name", (Object)NodeStructureHelper.field(0, 0), (Object)c2.getString("field(0).name"));
    }

    @Test
    public void testImmutableConfigurationAt() {
        ImmutableHierarchicalConfiguration subConfig = this.config.immutableConfigurationAt("tables.table(1)");
        Assert.assertEquals((String)"Wrong table name", (Object)NodeStructureHelper.table(1), (Object)subConfig.getString("name"));
        List lstFlds = subConfig.getList("fields.field.name");
        Assert.assertEquals((String)"Wrong number of fields", (long)NodeStructureHelper.fieldsLength(1), (long)lstFlds.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            Assert.assertEquals((String)("Wrong field at position " + i), (Object)NodeStructureHelper.field(1, i), lstFlds.get(i));
        }
    }

    @Test
    public void testImmutableConfigurationAtSupportUpdates() {
        String newTableName = NodeStructureHelper.table(1) + "_other";
        ImmutableHierarchicalConfiguration subConfig = this.config.immutableConfigurationAt("tables.table(1)", true);
        this.config.addProperty("tables.table(-1).name", (Object)newTableName);
        this.config.clearTree("tables.table(1)");
        Assert.assertEquals((String)"Name not updated", (Object)newTableName, (Object)subConfig.getString("name"));
    }

    @Test
    public void testImmutableConfigurationsAt() {
        List lstFlds = this.config.immutableConfigurationsAt("tables.table(1).fields.field");
        this.checkSubConfigurations(lstFlds);
    }

    @Test
    public void testInitCopy() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        this.checkContent((Configuration)copy);
    }

    @Test
    public void testInitCopyNull() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)null);
        Assert.assertTrue((String)"Configuration not empty", (boolean)copy.isEmpty());
    }

    @Test
    public void testInitCopyUpdate() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        this.config.setProperty("tables.table(0).name", (Object)"NewTable");
        this.checkContent((Configuration)copy);
    }

    @Test
    public void testInterpolatedConfiguration() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        BaseHierarchicalConfiguration c = (BaseHierarchicalConfiguration)InterpolationTestHelper.testInterpolatedConfiguration((AbstractConfiguration)this.config);
        this.checkContent((Configuration)c);
    }

    @Test
    public void testInterpolatedConfigurationEmpty() {
        this.config = new BaseHierarchicalConfiguration();
        Assert.assertTrue((String)"Got content", (boolean)this.config.interpolatedConfiguration().isEmpty());
    }

    @Test
    public void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset((Configuration)this.config);
    }

    @Test
    public void testInterpolationSubsetMultipleLayers() {
        this.config.clear();
        this.config.addProperty("var", (Object)"value");
        this.config.addProperty("prop2.prop[@attr]", (Object)"${var}");
        Configuration sub1 = this.config.subset("prop2");
        Configuration sub2 = sub1.subset("prop");
        Assert.assertEquals((String)"Wrong value", (Object)"value", (Object)sub2.getString("[@attr]"));
    }

    @Test
    public void testSubset() {
        Configuration subset = this.config.subset("tables.table(0)");
        Assert.assertEquals((Object)NodeStructureHelper.table(0), (Object)subset.getProperty("name"));
        Object prop = subset.getProperty("fields.field.name");
        Assert.assertNotNull((Object)prop);
        Assert.assertTrue((boolean)(prop instanceof Collection));
        Assert.assertEquals((long)5L, (long)((Collection)prop).size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(0); ++i) {
            DefaultConfigurationKey key = TestHierarchicalConfiguration.createConfigurationKey();
            key.append("fields").append("field").appendIndex(i);
            key.append("name");
            Assert.assertEquals((Object)NodeStructureHelper.field(0, i), (Object)subset.getProperty(key.toString()));
        }
        Assert.assertTrue((String)"subset is not empty", (boolean)this.config.subset("tables.table(2)").isEmpty());
        subset = this.config.subset("tables.table.fields.field");
        prop = subset.getProperty("name");
        Assert.assertTrue((String)"prop is not a collection", (boolean)(prop instanceof Collection));
        int expectedFieldCount = 0;
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            expectedFieldCount += NodeStructureHelper.fieldsLength(i);
        }
        Assert.assertEquals((String)"Wrong number of fields", (long)expectedFieldCount, (long)((Collection)prop).size());
        Assert.assertEquals((Object)NodeStructureHelper.field(0, 0), (Object)subset.getProperty("name(0)"));
        subset = this.config.subset("tables.table.fields.field.name");
        Assert.assertTrue((String)"subset is not empty", (boolean)subset.isEmpty());
    }

    @Test
    public void testSubsetAttributeResult() {
        String key = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        BaseHierarchicalConfiguration subset = (BaseHierarchicalConfiguration)this.config.subset("tables.table(0)[@type]");
        Assert.assertTrue((String)"Got children of root node", (boolean)((ImmutableNode)subset.getModel().getNodeHandler().getRootNode()).getChildren().isEmpty());
        Assert.assertEquals((String)"Attribute not found", (Object)"system", (Object)subset.getString("[@type]"));
    }

    @Test
    public void testSubsetMultipleNodesWithValues() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table.fields");
        Assert.assertEquals((String)"Wrong value of root", (Object)"My fields", (Object)subset.getString(""));
        this.config.setProperty("tables.table(1).fields", (Object)"My other fields");
        subset = this.config.subset("tables.table.fields");
        Assert.assertNull((String)"Root value is not null though there are multiple values", (Object)subset.getString(""));
    }

    @Test
    public void testSubsetNodeWithValue() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table(0).fields");
        Assert.assertEquals((String)"Wrong field name", (Object)NodeStructureHelper.field(0, 0), (Object)subset.getString("field(0).name"));
        Assert.assertEquals((String)"Wrong value of root", (Object)"My fields", (Object)subset.getString(""));
    }
}

