/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junitx.framework.ListAssert;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.NonCloneableConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventSource;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.sync.NoOpSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationUtils {
    private static final String CLS_NAME = "org.apache.commons.configuration2.PropertiesConfiguration";
    private ClassLoader ccl;

    @Before
    public void setUp() throws Exception {
        this.ccl = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void tearDown() throws Exception {
        Thread.currentThread().setContextClassLoader(this.ccl);
    }

    @Test
    public void testAppend() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.append((Configuration)conf1, (Configuration)conf2);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value1");
        ListAssert.assertEquals((String)"'key1' property", expected, (List)conf2.getList("key1"));
        expected = new ArrayList();
        expected.add("value4");
        expected.add("value2");
        ListAssert.assertEquals((String)"'key2' property", expected, (List)conf2.getList("key2"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testAsEventSourceNonSupportedEx() {
        ConfigurationUtils.asEventSource((Object)this, (boolean)false);
    }

    @Test
    public void testAsEventSourceSupported() {
        XMLConfiguration src = new XMLConfiguration();
        Assert.assertSame((String)"Wrong result", (Object)src, (Object)ConfigurationUtils.asEventSource((Object)src, (boolean)true));
    }

    @Test
    public void testAsEventSourceUnsupportedMock() {
        EventListener cl = (EventListener)EasyMock.createMock(EventListener.class);
        EasyMock.replay((Object[])new Object[]{cl});
        EventSource source = ConfigurationUtils.asEventSource((Object)this, (boolean)true);
        source.addEventListener(ConfigurationEvent.ANY, cl);
        Assert.assertFalse((String)"Wrong result (1)", (boolean)source.removeEventListener(ConfigurationEvent.ANY, cl));
        source.addEventListener(ConfigurationEvent.ANY, null);
    }

    @Test
    public void testCloneConfiguration() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        BaseHierarchicalConfiguration copy = (BaseHierarchicalConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)conf);
        Assert.assertNotSame((String)"Same object was returned", (Object)conf, (Object)copy);
        Assert.assertEquals((String)"Property was not cloned", (Object)"yes", (Object)copy.getString("test"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCloneConfigurationNotSupported() {
        NonCloneableConfiguration myNonCloneableConfig = new NonCloneableConfiguration();
        ConfigurationUtils.cloneConfiguration((Configuration)myNonCloneableConfig);
    }

    @Test
    public void testCloneConfigurationNull() {
        Assert.assertNull((String)"Wrong return value", (Object)ConfigurationUtils.cloneConfiguration(null));
    }

    @Test
    public void testCloneIfPossibleError() {
        XMLBuilderParametersImpl params = new XMLBuilderParametersImpl(){

            public XMLBuilderParametersImpl clone() {
                throw new ConfigurationRuntimeException();
            }
        };
        Assert.assertSame((String)"Wrong result", (Object)params, (Object)ConfigurationUtils.cloneIfPossible((Object)params));
    }

    @Test
    public void testCloneIfPossibleNotSupported() {
        Long value = 20130116221714L;
        Assert.assertSame((String)"Wrong result", (Object)value, (Object)ConfigurationUtils.cloneIfPossible((Object)value));
    }

    @Test
    public void testCloneIfPossibleNull() {
        Assert.assertNull((String)"Wrong result", (Object)ConfigurationUtils.cloneIfPossible(null));
    }

    @Test
    public void testCloneIfPossibleSupported() {
        XMLBuilderParametersImpl params = new XMLBuilderParametersImpl();
        params.setPublicID("testID");
        params.setSchemaValidation(true);
        XMLBuilderParametersImpl clone = (XMLBuilderParametersImpl)ConfigurationUtils.cloneIfPossible((Object)params);
        Assert.assertNotSame((String)"No clone was created", (Object)params, (Object)clone);
        Map map = clone.getParameters();
        for (Map.Entry e : params.getParameters().entrySet()) {
            if (((String)e.getKey()).startsWith("config-")) continue;
            Assert.assertEquals((String)("Wrong value for field " + (String)e.getKey()), e.getValue(), map.get(e.getKey()));
        }
    }

    @Test
    public void testCloneSynchronizerClone() {
        CloneableSynchronizer sync = new CloneableSynchronizer(false);
        CloneableSynchronizer sync2 = (CloneableSynchronizer)ConfigurationUtils.cloneSynchronizer((Synchronizer)sync);
        Assert.assertTrue((String)"Not cloned", (boolean)sync2.isCloned());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testCloneSynchronizerFailed() {
        ConfigurationUtils.cloneSynchronizer((Synchronizer)new NonCloneableSynchronizer());
    }

    @Test
    public void testCloneSynchronizerNewInstance() {
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        SynchronizerTestImpl sync2 = (SynchronizerTestImpl)ConfigurationUtils.cloneSynchronizer((Synchronizer)sync);
        Assert.assertNotNull((String)"Clone is null", (Object)sync2);
        Assert.assertNotSame((String)"Same instance", (Object)sync, (Object)sync2);
    }

    @Test
    public void testCloneSynchronizerNoOp() {
        Assert.assertSame((String)"Wrong result", (Object)NoOpSynchronizer.INSTANCE, (Object)ConfigurationUtils.cloneSynchronizer((Synchronizer)NoOpSynchronizer.INSTANCE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCloneSynchronizerNull() {
        ConfigurationUtils.cloneSynchronizer(null);
    }

    @Test
    public void testConvertHierarchicalToHierarchical() {
        BaseHierarchicalConfiguration conf = new BaseHierarchicalConfiguration();
        conf.addProperty("test", (Object)"yes");
        Assert.assertSame((String)"Wrong configuration returned", (Object)conf, (Object)ConfigurationUtils.convertToHierarchical((Configuration)conf));
    }

    @Test
    public void testConvertHierarchicalToHierarchicalEngine() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        Assert.assertSame((String)"Created new configuration", (Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, (ExpressionEngine)engine));
        Assert.assertSame((String)"Engine was not set", (Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    public void testConvertHierarchicalToHierarchicalNullEngine() {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS);
        hc.setExpressionEngine((ExpressionEngine)engine);
        Assert.assertSame((String)"Created new configuration", (Object)hc, (Object)ConfigurationUtils.convertToHierarchical((Configuration)hc, null));
        Assert.assertSame((String)"Expression engine was changed", (Object)engine, (Object)hc.getExpressionEngine());
    }

    @Test
    public void testConvertNullToHierarchical() {
        Assert.assertNull((String)"Wrong conversion result for null config", (Object)ConfigurationUtils.convertToHierarchical(null));
    }

    @Test
    public void testConvertToHierarchical() {
        BaseConfiguration conf = new BaseConfiguration();
        for (int i = 0; i < 10; ++i) {
            conf.addProperty("test" + i, (Object)("value" + i));
            conf.addProperty("test.list", (Object)("item" + i));
        }
        BaseHierarchicalConfiguration hc = (BaseHierarchicalConfiguration)ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertEquals((String)("Wrong value for key " + key), (Object)conf.getProperty(key), (Object)hc.getProperty(key));
        }
    }

    @Test
    public void testConvertToHierarchicalDelimiters() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        conf.addProperty("test.key", (Object)"1\\,2\\,3");
        Assert.assertEquals((String)"Wrong property value", (Object)"1,2,3", (Object)conf.getString("test.key"));
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf);
        Assert.assertEquals((String)"Escaped list delimiters not correctly handled", (Object)"1,2,3", (Object)hc.getString("test.key"));
    }

    @Test
    public void testConvertToHierarchicalEngine() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty("test(a)", (Object)Boolean.TRUE);
        conf.addProperty("test(b)", (Object)Boolean.FALSE);
        DefaultExpressionEngine engine = new DefaultExpressionEngine(new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setIndexStart("[").setIndexEnd("]").create());
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)conf, (ExpressionEngine)engine);
        Assert.assertTrue((String)"Wrong value for test(a)", (boolean)hc.getBoolean("test(a)"));
        Assert.assertFalse((String)"Wrong value for test(b)", (boolean)hc.getBoolean("test(b)"));
    }

    @Test
    public void testConvertToHierarchicalMultiValues() {
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("test", (Object)"1,2,3");
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)config);
        Assert.assertEquals((String)"Wrong value 1", (long)1L, (long)hc.getInt("test(0)"));
        Assert.assertEquals((String)"Wrong value 2", (long)2L, (long)hc.getInt("test(1)"));
        Assert.assertEquals((String)"Wrong value 3", (long)3L, (long)hc.getInt("test(2)"));
    }

    @Test
    public void testConvertToHierarchicalOrderOfProperties() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("x.y.z", (Object)true);
        config.addProperty("x.y", (Object)true);
        HierarchicalConfiguration hc = ConfigurationUtils.convertToHierarchical((Configuration)config);
        ImmutableNode rootNode = (ImmutableNode)hc.getNodeModel().getNodeHandler().getRootNode();
        ImmutableNode nodeX = (ImmutableNode)rootNode.getChildren().get(0);
        Assert.assertEquals((String)"Wrong number of children of x", (long)1L, (long)nodeX.getChildren().size());
    }

    @Test
    public void testCopy() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("key1", (Object)"value1");
        conf1.addProperty("key2", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("key1", (Object)"value3");
        conf2.addProperty("key2", (Object)"value4");
        ConfigurationUtils.copy((Configuration)conf1, (Configuration)conf2);
        Assert.assertEquals((String)"'key1' property", (Object)"value1", (Object)conf2.getProperty("key1"));
        Assert.assertEquals((String)"'key2' property", (Object)"value2", (Object)conf2.getProperty("key2"));
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testEnableRuntimeExceptions() {
        PropertiesConfiguration config = new PropertiesConfiguration(){

            protected void addPropertyDirect(String key, Object value) {
                this.fireError(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, key, value, new RuntimeException("A faked exception!"));
            }
        };
        config.clearErrorListeners();
        ConfigurationUtils.enableRuntimeExceptions((Configuration)config);
        config.addProperty("test", (Object)"testValue");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableRuntimeExceptionsInvalid() {
        Configuration c = (Configuration)EasyMock.createMock(Configuration.class);
        EasyMock.replay((Object[])new Object[]{c});
        ConfigurationUtils.enableRuntimeExceptions((Configuration)c);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableRuntimeExceptionsNull() {
        ConfigurationUtils.enableRuntimeExceptions(null);
    }

    @Test
    public void testLoadClassCCLNotFound() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException(name);
            }
        });
        Assert.assertEquals((String)"Wrong class", (Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    public void testLoadClassCCLNull() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(null);
        Assert.assertEquals((String)"Wrong class", (Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    public void testLoadClassFromCCL() throws ClassNotFoundException {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Assert.assertEquals((String)"Wrong class", (Object)CLS_NAME, (Object)ConfigurationUtils.loadClass((String)CLS_NAME).getName());
    }

    @Test
    public void testLoadClassNoExFound() {
        Assert.assertEquals((String)"Wrong class", (Object)CLS_NAME, (Object)ConfigurationUtils.loadClassNoEx((String)CLS_NAME).getName());
    }

    @Test(expected=ConfigurationRuntimeException.class)
    public void testLoadClassNoExNotFound() {
        ConfigurationUtils.loadClassNoEx((String)"a non existing class!");
    }

    @Test(expected=ClassNotFoundException.class)
    public void testLoadClassNotFound() throws ClassNotFoundException {
        ConfigurationUtils.loadClass((String)"a non existing class!");
    }

    @Test
    public void testToString() {
        BaseConfiguration config = new BaseConfiguration();
        String lineSeparator = System.lineSeparator();
        Assert.assertEquals((String)"String representation of an empty configuration", (Object)"", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("one", (Object)"1");
        Assert.assertEquals((String)"String representation of a configuration", (Object)"one=1", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("two", (Object)"2");
        Assert.assertEquals((String)"String representation of a configuration", (Object)("one=1" + lineSeparator + "two=2"), (Object)ConfigurationUtils.toString((Configuration)config));
        config.clearProperty("one");
        Assert.assertEquals((String)"String representation of a configuration", (Object)"two=2", (Object)ConfigurationUtils.toString((Configuration)config));
        config.setProperty("one", (Object)"1");
        Assert.assertEquals((String)"String representation of a configuration", (Object)("two=2" + lineSeparator + "one=1"), (Object)ConfigurationUtils.toString((Configuration)config));
    }

    private static class NonCloneableSynchronizer
    extends SynchronizerTestImpl {
        private NonCloneableSynchronizer() {
        }
    }

    private static class CloneableSynchronizer
    extends NonCloneableSynchronizer
    implements Cloneable {
        private final boolean cloned;

        public CloneableSynchronizer(boolean clone) {
            this.cloned = clone;
        }

        public Object clone() {
            return new CloneableSynchronizer(true);
        }

        public boolean isCloned() {
            return this.cloned;
        }
    }
}

