/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConversionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBaseNullConfiguration {
    protected BaseConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = new BaseConfiguration();
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        this.config.setThrowExceptionOnMissing(false);
    }

    @Test
    public void testCommaSeparatedString() {
        String prop = "hey, that's a test";
        this.config.setProperty("prop.string", (Object)"hey, that's a test");
        List list = this.config.getList("prop.string");
        Assert.assertEquals((String)"Wrong number of elements", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"hey", list.get(0));
    }

    @Test
    public void testCommaSeparatedStringEscaped() {
        String prop2 = "hey\\, that's a test";
        this.config.clearProperty("prop.string");
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        Assert.assertEquals((String)"Wrong value", (Object)"hey, that's a test", (Object)this.config.getString("prop.string"));
    }

    @Test
    public void testGetBigDecimal() {
        this.config.setProperty("numberBigD", (Object)"123.456");
        BigDecimal number = new BigDecimal("123.456");
        BigDecimal defaultValue = new BigDecimal("654.321");
        Assert.assertEquals((String)"Existing key", (Object)number, (Object)this.config.getBigDecimal("numberBigD"));
        Assert.assertEquals((String)"Existing key with default value", (Object)number, (Object)this.config.getBigDecimal("numberBigD", defaultValue));
        Assert.assertEquals((String)"Missing key with default value", (Object)defaultValue, (Object)this.config.getBigDecimal("numberNotInConfig", defaultValue));
    }

    @Test(expected=ConversionException.class)
    public void testGetBigDecimalIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBigDecimal("test.empty");
    }

    @Test
    public void testGetBigDecimalUnknown() {
        Assert.assertNull((String)"Missing Key is not null!", (Object)this.config.getBigDecimal("numberNotInConfig"));
    }

    @Test
    public void testGetBigInteger() {
        this.config.setProperty("numberBigI", (Object)"1234567890");
        BigInteger number = new BigInteger("1234567890");
        BigInteger defaultValue = new BigInteger("654321");
        Assert.assertEquals((String)"Existing key", (Object)number, (Object)this.config.getBigInteger("numberBigI"));
        Assert.assertEquals((String)"Existing key with default value", (Object)number, (Object)this.config.getBigInteger("numberBigI", defaultValue));
        Assert.assertEquals((String)"Missing key with default value", (Object)defaultValue, (Object)this.config.getBigInteger("numberNotInConfig", defaultValue));
    }

    @Test(expected=ConversionException.class)
    public void testGetBigIntegerIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBigInteger("test.empty");
    }

    @Test
    public void testGetBigIntegerUnknown() {
        Assert.assertNull((String)"Missing Key is not null!", (Object)this.config.getBigInteger("numberNotInConfig"));
    }

    @Test
    public void testGetBoolean() {
        this.config.setProperty("boolA", (Object)Boolean.TRUE);
        boolean boolT = true;
        boolean boolF = false;
        Assert.assertEquals((String)"This returns true", (Object)true, (Object)this.config.getBoolean("boolA"));
        Assert.assertEquals((String)"This returns true, not the default", (Object)true, (Object)this.config.getBoolean("boolA", false));
        Assert.assertEquals((String)"This returns false(default)", (Object)false, (Object)this.config.getBoolean("boolNotInConfig", false));
        Assert.assertEquals((String)"This returns true(Boolean)", (Object)true, (Object)this.config.getBoolean("boolA", Boolean.valueOf(false)));
    }

    @Test(expected=ConversionException.class)
    public void testGetBooleanIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getBoolean("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetBooleanUnknown() {
        this.config.getBoolean("numberNotInConfig");
    }

    @Test
    public void testGetByte() {
        this.config.setProperty("number", (Object)"1");
        boolean oneB = true;
        int twoB = 2;
        Assert.assertEquals((String)"This returns 1(byte)", (long)1L, (long)this.config.getByte("number"));
        Assert.assertEquals((String)"This returns 1(byte)", (long)1L, (long)this.config.getByte("number", (byte)2));
        Assert.assertEquals((String)"This returns 2(default byte)", (long)2L, (long)this.config.getByte("numberNotInConfig", (byte)2));
        Assert.assertEquals((String)"This returns 1(Byte)", (Object)1, (Object)this.config.getByte("number", Byte.valueOf("2")));
    }

    @Test(expected=ConversionException.class)
    public void testGetByteIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getByte("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetByteUnknown() {
        this.config.getByte("numberNotInConfig");
    }

    @Test
    public void testGetDouble() {
        this.config.setProperty("numberD", (Object)"1.0");
        double oneD = 1.0;
        double twoD = 2.0;
        Assert.assertEquals((String)"This returns 1(double)", (double)1.0, (double)this.config.getDouble("numberD"), (double)0.0);
        Assert.assertEquals((String)"This returns 1(double)", (double)1.0, (double)this.config.getDouble("numberD", 2.0), (double)0.0);
        Assert.assertEquals((String)"This returns 2(default double)", (double)2.0, (double)this.config.getDouble("numberNotInConfig", 2.0), (double)0.0);
        Assert.assertEquals((String)"This returns 1(Double)", (Object)1.0, (Object)this.config.getDouble("numberD", Double.valueOf("2")));
    }

    @Test(expected=ConversionException.class)
    public void testGetDoubleIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getDouble("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetDoubleUnknown() {
        this.config.getDouble("numberNotInConfig");
    }

    @Test
    public void testGetFloat() {
        this.config.setProperty("numberF", (Object)"1.0");
        float oneF = 1.0f;
        float twoF = 2.0f;
        Assert.assertEquals((String)"This returns 1(float)", (float)1.0f, (float)this.config.getFloat("numberF"), (float)0.0f);
        Assert.assertEquals((String)"This returns 1(float)", (float)1.0f, (float)this.config.getFloat("numberF", 2.0f), (float)0.0f);
        Assert.assertEquals((String)"This returns 2(default float)", (float)2.0f, (float)this.config.getFloat("numberNotInConfig", 2.0f), (float)0.0f);
        Assert.assertEquals((String)"This returns 1(Float)", (Object)Float.valueOf(1.0f), (Object)this.config.getFloat("numberF", Float.valueOf("2")));
    }

    @Test(expected=ConversionException.class)
    public void testGetFloatIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getFloat("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetFloatUnknown() {
        this.config.getFloat("numberNotInConfig");
    }

    @Test
    public void testGetList() {
        this.config.addProperty("number", (Object)"1");
        this.config.addProperty("number", (Object)"2");
        List list = this.config.getList("number");
        Assert.assertNotNull((String)"The list is null", (Object)list);
        Assert.assertEquals((String)"List size", (long)2L, (long)list.size());
        Assert.assertTrue((String)"The number 1 is missing from the list", (boolean)list.contains("1"));
        Assert.assertTrue((String)"The number 2 is missing from the list", (boolean)list.contains("2"));
    }

    @Test
    public void testGetListAsScalar() {
        this.config.addProperty("number", (Object)"1");
        this.config.addProperty("number", (Object)"2");
        Assert.assertEquals((String)"Wrong value", (Object)"1", (Object)this.config.getString("number"));
    }

    @Test
    public void testGetLong() {
        this.config.setProperty("numberL", (Object)"1");
        long oneL = 1L;
        long twoL = 2L;
        Assert.assertEquals((String)"This returns 1(long)", (long)1L, (long)this.config.getLong("numberL"));
        Assert.assertEquals((String)"This returns 1(long)", (long)1L, (long)this.config.getLong("numberL", 2L));
        Assert.assertEquals((String)"This returns 2(default long)", (long)2L, (long)this.config.getLong("numberNotInConfig", 2L));
        Assert.assertEquals((String)"This returns 1(Long)", (Object)1L, (Object)this.config.getLong("numberL", Long.valueOf("2")));
    }

    @Test(expected=ConversionException.class)
    public void testGetLongIncompatibleTypes() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getLong("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetLongUnknown() {
        this.config.getLong("numberNotInConfig");
    }

    @Test
    public void testGetProperty() {
        Assert.assertNull((String)"This returns null", (Object)this.config.getProperty("foo"));
        this.config.setProperty("number", (Object)"1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.config.getProperty("number"), (Object)"1");
        Assert.assertEquals((String)"This returns '1'", (Object)this.config.getString("number"), (Object)"1");
    }

    @Test
    public void testGetShort() {
        this.config.setProperty("numberS", (Object)"1");
        boolean oneS = true;
        int twoS = 2;
        Assert.assertEquals((String)"This returns 1(short)", (long)1L, (long)this.config.getShort("numberS"));
        Assert.assertEquals((String)"This returns 1(short)", (long)1L, (long)this.config.getShort("numberS", (short)2));
        Assert.assertEquals((String)"This returns 2(default short)", (long)2L, (long)this.config.getShort("numberNotInConfig", (short)2));
        Assert.assertEquals((String)"This returns 1(Short)", (Object)1, (Object)this.config.getShort("numberS", Short.valueOf("2")));
    }

    @Test(expected=ConversionException.class)
    public void testGetShortIncompatibleType() {
        this.config.setProperty("test.empty", (Object)"");
        this.config.getShort("test.empty");
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetShortUnknown() {
        this.config.getShort("numberNotInConfig");
    }

    @Test
    public void testGetString() {
        this.config.setProperty("testString", (Object)"The quick brown fox");
        String string = "The quick brown fox";
        String defaultValue = "jumps over the lazy dog";
        Assert.assertEquals((String)"Existing key", (Object)"The quick brown fox", (Object)this.config.getString("testString"));
        Assert.assertEquals((String)"Existing key with default value", (Object)"The quick brown fox", (Object)this.config.getString("testString", "jumps over the lazy dog"));
        Assert.assertEquals((String)"Missing key with default value", (Object)"jumps over the lazy dog", (Object)this.config.getString("stringNotInConfig", "jumps over the lazy dog"));
    }

    @Test
    public void testGetStringUnknown() {
        Assert.assertNull((String)"Missing Key is not null!", (Object)this.config.getString("stringNotInConfig"));
    }

    @Test
    public void testInterpolation() throws Exception {
        this.config.setProperty("applicationRoot", (Object)"/home/applicationRoot");
        this.config.setProperty("db", (Object)"${applicationRoot}/db/hypersonic");
        String unInterpolatedValue = "${applicationRoot2}/db/hypersonic";
        this.config.setProperty("dbFailedInterpolate", (Object)"${applicationRoot2}/db/hypersonic");
        String dbProp = "/home/applicationRoot/db/hypersonic";
        BaseConfiguration superProp = this.config;
        Assert.assertEquals((String)"Checking interpolated variable", (Object)"/home/applicationRoot/db/hypersonic", (Object)superProp.getString("db"));
        Assert.assertEquals((String)"lookup fails, leave variable as is", (Object)superProp.getString("dbFailedInterpolate"), (Object)"${applicationRoot2}/db/hypersonic");
        superProp.setProperty("arrayInt", (Object)"${applicationRoot}/1");
        String[] arrayInt = superProp.getStringArray("arrayInt");
        Assert.assertEquals((String)"check first entry was interpolated", (Object)"/home/applicationRoot/1", (Object)arrayInt[0]);
    }

    @Test(expected=IllegalStateException.class)
    public void testInterpolationLoop() throws Exception {
        this.config.setProperty("test.a", (Object)"${test.b}");
        this.config.setProperty("test.b", (Object)"${test.a}");
        this.config.getString("test.a");
    }

    @Test
    public void testMultipleInterpolation() throws Exception {
        this.config.setProperty("test.base-level", (Object)"/base-level");
        this.config.setProperty("test.first-level", (Object)"${test.base-level}/first-level");
        this.config.setProperty("test.second-level", (Object)"${test.first-level}/second-level");
        this.config.setProperty("test.third-level", (Object)"${test.second-level}/third-level");
        String expectedValue = "/base-level/first-level/second-level/third-level";
        Assert.assertEquals((Object)this.config.getString("test.third-level"), (Object)"/base-level/first-level/second-level/third-level");
    }

    @Test
    public void testPropertyAccess() {
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"");
        Assert.assertEquals((String)"This returns an empty Properties object", (Object)this.config.getProperties("prop.properties"), (Object)new Properties());
        this.config.clearProperty("prop.properties");
        this.config.setProperty("prop.properties", (Object)"foo=bar, baz=moo, seal=clubber");
        Properties p = new Properties();
        p.setProperty("foo", "bar");
        p.setProperty("baz", "moo");
        p.setProperty("seal", "clubber");
        Assert.assertEquals((String)"This returns a filled in Properties object", (Object)this.config.getProperties("prop.properties"), (Object)p);
    }

    @Test
    public void testSubset() {
        String prop = "hey, that's a test";
        String prop2 = "hey\\, that's a test";
        this.config.setProperty("prop.string", (Object)"hey\\, that's a test");
        this.config.setProperty("property.string", (Object)"hello");
        Configuration subEprop = this.config.subset("prop");
        Assert.assertEquals((String)"Returns the full string", (Object)"hey, that's a test", (Object)subEprop.getString("string"));
        Assert.assertEquals((String)"Wrong list size", (long)1L, (long)subEprop.getList("string").size());
        Iterator it = subEprop.getKeys();
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        subEprop = this.config.subset("prop.");
        it = subEprop.getKeys();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assert.assertFalse((String)"Throw Exception Property is set!", (boolean)this.config.isThrowExceptionOnMissing());
    }
}

