/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ConfigurationLookup;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.lang3.ArrayUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractConfigurationBasicFeatures {
    private static final String SUBST_TXT = "The ${animal} jumps over the ${target}.";
    private static final String KEY_PREFIX = "key";
    private static final int PROP_COUNT = 12;

    private static List<Integer> prepareListTest(PropertiesConfiguration config) {
        ArrayList<Integer> expected = new ArrayList<Integer>(12);
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected.add(i);
        }
        return expected;
    }

    private void checkAddListProperty(AbstractConfiguration config) {
        config.addProperty("test", (Object)"value1");
        Object[] lstValues1 = new Object[]{"value2", "value3"};
        Object[] lstValues2 = new Object[]{"value4", "value5", "value6"};
        config.addProperty("test", (Object)lstValues1);
        config.addProperty("test", Arrays.asList(lstValues2));
        List lst = config.getList("test");
        Assert.assertEquals((String)"Wrong number of list elements", (long)6L, (long)lst.size());
        for (int i = 0; i < lst.size(); ++i) {
            Assert.assertEquals((String)("Wrong list element at " + i), (Object)("value" + (i + 1)), lst.get(i));
        }
    }

    private void checkCopyEvents(CollectingConfigurationListener l, Configuration src, EventType<?> eventType) {
        HashMap<String, ConfigurationEvent> events = new HashMap<String, ConfigurationEvent>();
        for (ConfigurationEvent e : l.events) {
            Assert.assertEquals((String)"Wrong event type", eventType, (Object)e.getEventType());
            Assert.assertTrue((String)("Unknown property: " + e.getPropertyName()), (boolean)src.containsKey(e.getPropertyName()));
            if (!e.isBeforeUpdate()) {
                Assert.assertTrue((String)"After event without before event", (boolean)events.containsKey(e.getPropertyName()));
                continue;
            }
            events.put(e.getPropertyName(), e);
        }
        Iterator it = src.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertTrue((String)("No event received for key " + key), (boolean)events.containsKey(key));
        }
    }

    private void checkGetListScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        List lst = config.getList(KEY_PREFIX);
        Assert.assertEquals((String)"Wrong number of values", (long)1L, (long)lst.size());
        Assert.assertEquals((String)"Wrong value", (Object)value.toString(), lst.get(0));
    }

    private void checkGetStringArrayScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        String[] array = config.getStringArray(KEY_PREFIX);
        Assert.assertEquals((String)"Wrong number of elements", (long)1L, (long)array.length);
        Assert.assertEquals((String)"Wrong value", (Object)value.toString(), (Object)array[0]);
    }

    private void checkListProperties(Configuration config) {
        List values = config.getList("list1");
        Assert.assertEquals((String)"Wrong number of elements in list 1", (long)3L, (long)values.size());
        values = config.getList("list2");
        Assert.assertEquals((String)"Wrong number of elements in list 2", (long)2L, (long)values.size());
        Assert.assertEquals((String)"Wrong value 1", (Object)"3,1415", values.get(0));
        Assert.assertEquals((String)"Wrong value 2", (Object)"9,81", values.get(1));
    }

    private AbstractConfiguration setUpDestConfig() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        return config;
    }

    private Configuration setUpSourceConfig() {
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        for (int i = 1; i < 12; i += 2) {
            config.addProperty(KEY_PREFIX + i, (Object)("src" + i));
        }
        config.addProperty("list1", (Object)"1,2,3");
        config.addProperty("list2", (Object)"3\\,1415,9\\,81");
        return config;
    }

    @Test
    public void testAddPropertyList() {
        this.checkAddListProperty(new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration()));
    }

    @Test
    public void testAddPropertyListNoDelimiterParsing() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        this.checkAddListProperty(config);
    }

    @Test
    public void testAppend() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.append(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                List values = config.getList(key);
                Assert.assertEquals((String)("Value not added: " + key), (long)2L, (long)values.size());
                Assert.assertEquals((String)("Wrong value 1 for " + key), (Object)("value" + i), values.get(0));
                Assert.assertEquals((String)("Wrong value 2 for " + key), (Object)("src" + i), values.get(1));
                continue;
            }
            Assert.assertEquals((String)("Value modified: " + key), (Object)("value" + i), (Object)config.getProperty(key));
        }
    }

    @Test
    public void testAppendDelimiterHandling() {
        BaseConfiguration srcConfig = new BaseConfiguration();
        BaseConfiguration dstConfig = new BaseConfiguration();
        dstConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        srcConfig.setProperty(KEY_PREFIX, (Object)"C:\\Temp\\,D:\\Data");
        dstConfig.append((Configuration)srcConfig);
        Assert.assertEquals((String)"Wrong property value", (Object)srcConfig.getString(KEY_PREFIX), (Object)dstConfig.getString(KEY_PREFIX));
    }

    @Test
    public void testAppendEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        config.append(srcConfig);
        this.checkCopyEvents(l, srcConfig, ConfigurationEvent.ADD_PROPERTY);
    }

    @Test
    public void testAppendNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(null);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.setUpDestConfig(), (ImmutableConfiguration)config);
    }

    @Test
    public void testAppendWithLists() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(this.setUpSourceConfig());
        this.checkListProperties((Configuration)config);
    }

    @Test
    public void testClearIteratorNoRemove() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new BaseConfiguration()){

            @Override
            protected Iterator<String> getKeysInternal() {
                ArrayList<String> keyCol = new ArrayList<String>();
                ConfigurationAssert.appendKeys((ImmutableConfiguration)this.getUnderlyingConfiguration(), keyCol);
                String[] keys = keyCol.toArray(new String[keyCol.size()]);
                return Arrays.asList(keys).iterator();
            }
        };
        for (int i = 0; i < 20; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        config.clear();
        Assert.assertTrue((String)"Configuration not empty", (boolean)config.isEmpty());
    }

    @Test
    public void testCopy() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.copy(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                Assert.assertEquals((String)("Value not replaced: " + key), (Object)srcConfig.getProperty(key), (Object)config.getProperty(key));
                continue;
            }
            Assert.assertEquals((String)("Value modified: " + key), (Object)("value" + i), (Object)config.getProperty(key));
        }
    }

    @Test
    public void testCopyDelimiterHandling() {
        BaseConfiguration srcConfig = new BaseConfiguration();
        BaseConfiguration dstConfig = new BaseConfiguration();
        dstConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        srcConfig.setProperty(KEY_PREFIX, (Object)"C:\\Temp\\,D:\\Data");
        dstConfig.copy((Configuration)srcConfig);
        Assert.assertEquals((String)"Wrong property value", (Object)srcConfig.getString(KEY_PREFIX), (Object)dstConfig.getString(KEY_PREFIX));
    }

    @Test
    public void testCopyEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        config.copy(srcConfig);
        this.checkCopyEvents(l, srcConfig, ConfigurationEvent.SET_PROPERTY);
    }

    @Test
    public void testCopyNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(null);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.setUpDestConfig(), (ImmutableConfiguration)config);
    }

    @Test
    public void testCopyWithLists() {
        Configuration srcConfig = this.setUpSourceConfig();
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(srcConfig);
        this.checkListProperties((Configuration)config);
    }

    @Test(expected=IllegalStateException.class)
    public void testCyclicInterpolation() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} ${species}");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("species", (Object)"${animal}");
        config.addProperty(KEY_PREFIX, (Object)"This is a ${animal}");
        config.getString(KEY_PREFIX);
    }

    @Test
    public void testDefaultConversionHandler() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertEquals((String)"Wrong default conversion handler", DefaultConversionHandler.class, config.getConversionHandler().getClass());
    }

    @Test
    public void testDefaultConversionHandlerSharedInstance() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        Assert.assertSame((String)"Multiple conversion handlers", (Object)config.getConversionHandler(), (Object)config2.getConversionHandler());
    }

    @Test
    public void testDefaultListDelimiterHandler() {
        BaseConfiguration config = new BaseConfiguration();
        Assert.assertTrue((String)"Wrong list delimiter handler", (boolean)(config.getListDelimiterHandler() instanceof DisabledListDelimiterHandler));
    }

    @Test
    public void testGet() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Integer value = 20130816;
        config.addProperty(KEY_PREFIX, (Object)value.toString());
        Assert.assertEquals((String)"Wrong result", (Object)value, (Object)config.get(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Object[] expected = new Integer[12];
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected[i] = i;
        }
        Object[] result = (Integer[])config.get(Integer[].class, KEY_PREFIX);
        Assert.assertArrayEquals((String)"Wrong result", (Object[])expected, (Object[])result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetArrayDefaultValueNotAnArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.getArray(Integer.class, KEY_PREFIX, (Object)this);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetArrayDefaultValueWrongComponentClass() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.getArray(Integer.class, KEY_PREFIX, (Object)new short[1]);
    }

    @Test
    public void testGetArrayPrimitive() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        short[] expected = new short[12];
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected[i] = (short)i;
        }
        short[] result = (short[])config.get(short[].class, KEY_PREFIX, (Object)ArrayUtils.EMPTY_SHORT_ARRAY);
        Assert.assertArrayEquals((String)"Wrong result", (short[])expected, (short[])result);
    }

    @Test
    public void testGetArrayUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertNull((String)"Wrong result", (Object)config.get(Integer[].class, KEY_PREFIX));
    }

    @Test
    public void testGetArrayUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        int[] defValue = new int[]{1, 2, 3};
        Assert.assertArrayEquals((String)"Wrong result", (int[])defValue, (int[])((int[])config.get(int[].class, KEY_PREFIX, (Object)defValue)));
    }

    @Test
    public void testGetCollection() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        ArrayList result = new ArrayList(12);
        Assert.assertSame((String)"Wrong result", result, (Object)config.getCollection(Integer.class, KEY_PREFIX, result));
        Assert.assertEquals((String)"Wrong converted content", expected, result);
    }

    @Test
    public void testGetCollectionNullTarget() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        Collection result = config.getCollection(Integer.class, KEY_PREFIX, null, new ArrayList());
        Assert.assertEquals((String)"Wrong result", expected, (Object)result);
    }

    @Test
    public void testGetCollectionSingleValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty(KEY_PREFIX, (Object)"1");
        ArrayList result = new ArrayList(1);
        config.getCollection(Integer.class, KEY_PREFIX, result);
        Assert.assertEquals((String)"Wrong number of elements", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Wrong element", (Object)1, result.get(0));
    }

    @Test
    public void testGetCollectionUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        ArrayList result = new ArrayList();
        Assert.assertNull((String)"Wrong result", (Object)config.getCollection(Integer.class, KEY_PREFIX, result));
        Assert.assertTrue((String)"Got elements", (boolean)result.isEmpty());
    }

    @Test
    public void testGetCollectionUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> defValue = Arrays.asList(1, 2, 4, 8, 16, 32);
        Collection result = config.getCollection(Integer.class, KEY_PREFIX, null, defValue);
        Assert.assertEquals((String)"Wrong result", defValue, (Object)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetEncodedStringNoDecoder() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.getEncodedString(KEY_PREFIX, null);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEncodedStringNoDefaultDecoderDefined() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.getEncodedString(KEY_PREFIX);
    }

    @Test
    public void testGetEncodedStringNoValue() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)EasyMock.createMock(ConfigurationDecoder.class);
        EasyMock.replay((Object[])new Object[]{decoder});
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertNull((String)"Got a value", (Object)config.getEncodedString(KEY_PREFIX, decoder));
    }

    @Test
    public void testGetEncodedStringValue() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)EasyMock.createMock(ConfigurationDecoder.class);
        String value = "original value";
        String decodedValue = "decoded value";
        EasyMock.expect((Object)decoder.decode("original value")).andReturn((Object)"decoded value");
        EasyMock.replay((Object[])new Object[]{decoder});
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty(KEY_PREFIX, (Object)"original value");
        Assert.assertEquals((String)"Wrong decoded value", (Object)"decoded value", (Object)config.getEncodedString(KEY_PREFIX, decoder));
    }

    @Test
    public void testGetEncodedStringWithDefaultDecoder() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)EasyMock.createMock(ConfigurationDecoder.class);
        String value = "original value";
        String decodedValue = "decoded value";
        EasyMock.expect((Object)decoder.decode("original value")).andReturn((Object)"decoded value");
        EasyMock.replay((Object[])new Object[]{decoder});
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setConfigurationDecoder(decoder);
        config.addProperty(KEY_PREFIX, (Object)"original value");
        Assert.assertEquals((String)"Wrong decoded value", (Object)"decoded value", (Object)config.getEncodedString(KEY_PREFIX));
    }

    @Test
    public void testGetList() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        List result = config.getList(Integer.class, KEY_PREFIX);
        Assert.assertEquals((String)"Wrong result", expected, (Object)result);
    }

    @Test
    public void testGetListNonString() {
        this.checkGetListScalar(42);
        this.checkGetListScalar(42L);
        this.checkGetListScalar((short)42);
        this.checkGetListScalar((byte)42);
        this.checkGetListScalar(Float.valueOf(42.0f));
        this.checkGetListScalar(42.0);
        this.checkGetListScalar(Boolean.TRUE);
    }

    @Test
    public void testGetListUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertNull((String)"Wrong result", (Object)config.getList(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetListUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> defValue = Arrays.asList(1, 2, 3);
        Assert.assertEquals((String)"Wrong result", defValue, (Object)config.getList(Integer.class, KEY_PREFIX, defValue));
    }

    @Test
    public void testGetStringArrayNonString() {
        this.checkGetStringArrayScalar(42);
        this.checkGetStringArrayScalar(42L);
        this.checkGetStringArrayScalar((short)42);
        this.checkGetStringArrayScalar((byte)42);
        this.checkGetStringArrayScalar(Float.valueOf(42.0f));
        this.checkGetStringArrayScalar(42.0);
        this.checkGetStringArrayScalar(Boolean.TRUE);
    }

    @Test
    public void testGetStringArrayUnknown() {
        BaseConfiguration config = new BaseConfiguration();
        String[] array = config.getStringArray(KEY_PREFIX);
        Assert.assertEquals((String)"Got elements", (long)0L, (long)array.length);
    }

    @Test
    public void testGetUnknownNoDefaultValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assert.assertNull((String)"Wrong result", (Object)config.get(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetUnknownWithDefaultValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Integer defaultValue = 2121;
        Assert.assertEquals((String)"Wrong result", (Object)defaultValue, (Object)config.get(Integer.class, KEY_PREFIX, (Object)defaultValue));
    }

    @Test(expected=NoSuchElementException.class)
    public void testGetUnknownWithThrowExceptionOnMissing() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setThrowExceptionOnMissing(true);
        config.get(Integer.class, KEY_PREFIX);
    }

    @Test
    public void testGetUnownWithDefaultValueThrowExceptionOnMissing() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setThrowExceptionOnMissing(true);
        Integer defaultValue = 2121;
        Assert.assertEquals((String)"Wrong result", (Object)defaultValue, (Object)config.get(Integer.class, KEY_PREFIX, (Object)defaultValue));
    }

    @Test
    public void testInstallInterpolatorNull() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.installInterpolator(null, null);
        Assert.assertTrue((String)"Got prefix lookups", (boolean)config.getInterpolator().getLookups().isEmpty());
        List defLookups = config.getInterpolator().getDefaultLookups();
        Assert.assertEquals((String)"Wrong number of default lookups", (long)1L, (long)defLookups.size());
        Assert.assertTrue((String)"Wrong default lookup", (boolean)(defLookups.get(0) instanceof ConfigurationLookup));
    }

    @Test
    public void testInterpolateArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Object[] values = new String[]{"some", "test", "values"};
        String keyArray = "testArray";
        config.addProperty("testArray", (Object)values);
        config.addProperty(KEY_PREFIX, (Object)"${testArray}");
        Assert.assertArrayEquals((String)"Wrong property", (Object[])values, (Object[])config.getStringArray(KEY_PREFIX));
    }

    @Test
    public void testInterpolateEnvironmentVariables() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        InterpolationTestHelper.testInterpolationEnvironment((Configuration)config);
    }

    @Test
    public void testInterpolateEscape() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("mypath", "$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar\\,$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar");
        Assert.assertEquals((String)"Wrong interpolated value", (Object)"${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar,${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar", (Object)config.getString("mypath"));
    }

    @Test
    public void testInterpolateList() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<String> values = Arrays.asList("some", "test", "values");
        String keyList = "testList";
        config.addProperty("testList", values);
        config.addProperty(KEY_PREFIX, (Object)"${testList}");
        Assert.assertEquals((String)"Wrong property", values, (Object)config.getList(String.class, KEY_PREFIX));
    }

    @Test
    public void testInterpolateRecursive() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} fox");
        config.addProperty("target", (Object)"${target_attr} dog");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("target_attr", (Object)"lazy");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assert.assertEquals((String)"Wrong complex interpolation", (Object)"The quick brown fox jumps over the lazy dog.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolateString() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty("target", (Object)"lazy dog");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assert.assertEquals((String)"Wrong interpolation", (Object)"The quick brown fox jumps over the lazy dog.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolateStringWithListVariable() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<String> values = Arrays.asList("some", "test", "values");
        String keyList = "testList";
        config.addProperty("testList", values);
        config.addProperty(KEY_PREFIX, (Object)"result = ${testList}");
        Assert.assertEquals((String)"Wrong interpolation", (Object)"result = some", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolationNoInterpolator() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty("target", (Object)"lazy dog");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        config.setInterpolator(null);
        Assert.assertEquals((String)"Interpolation was performed", (Object)SUBST_TXT, (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolationUnknownVariable() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assert.assertEquals((String)"Wrong interpolation", (Object)"The quick brown fox jumps over the ${target}.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testNestedVariableInterpolation() {
        BaseConfiguration config = new BaseConfiguration();
        config.getInterpolator().setEnableSubstitutionInVariables(true);
        config.addProperty("java.version", (Object)"1.4");
        config.addProperty("jre-1.4", (Object)"C:\\java\\1.4");
        config.addProperty("jre.path", (Object)"${jre-${java.version}}");
        Assert.assertEquals((String)"Wrong path", (Object)"C:\\java\\1.4", (Object)config.getString("jre.path"));
    }

    @Test
    public void testSetDefaultConversionHandler() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        DefaultConversionHandler handler = new DefaultConversionHandler();
        config.setConversionHandler((ConversionHandler)handler);
        Assert.assertSame((String)"Handler not set", (Object)handler, (Object)config.getConversionHandler());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetDefaultConversionHandlerNull() {
        new PropertiesConfiguration().setConversionHandler(null);
    }

    @Test
    public void testSetDefaultLookupsExistingInterpolator() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{look});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.getInterpolator().addDefaultLookup((Lookup)new ConfigurationLookup((ImmutableConfiguration)new PropertiesConfiguration()));
        config.setDefaultLookups(Collections.singleton(look));
        List lookups = config.getInterpolator().getDefaultLookups();
        Assert.assertEquals((String)"Wrong number of default lookups", (long)3L, (long)lookups.size());
        Assert.assertSame((String)"Wrong lookup at 1", (Object)look, lookups.get(1));
        Assert.assertTrue((String)("Wrong lookup at 2: " + lookups), (boolean)(lookups.get(2) instanceof ConfigurationLookup));
    }

    @Test
    public void testSetDefaultLookupsNoInterpolator() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{look});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setDefaultLookups(Collections.singleton(look));
        List lookups = config.getInterpolator().getDefaultLookups();
        Assert.assertEquals((String)"Wrong number of default lookups", (long)2L, (long)lookups.size());
        Assert.assertSame((String)"Wrong lookup at 0", (Object)look, lookups.get(0));
        Assert.assertTrue((String)"Wrong lookup at 1", (boolean)(lookups.get(1) instanceof ConfigurationLookup));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetListDelimiterHandlerNull() {
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiterHandler(null);
    }

    @Test
    public void testSetParentInterpolatorExistingInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{parent});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        ConfigurationInterpolator ci = config.getInterpolator();
        config.setParentInterpolator(parent);
        Assert.assertSame((String)"Parent was not set", (Object)parent, (Object)config.getInterpolator().getParentInterpolator());
        Assert.assertSame((String)"Interpolator was changed", (Object)ci, (Object)config.getInterpolator());
    }

    @Test
    public void testSetParentInterpolatorNoInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)EasyMock.createMock(ConfigurationInterpolator.class);
        EasyMock.replay((Object[])new Object[]{parent});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setParentInterpolator(parent);
        Assert.assertSame((String)"Parent was not set", (Object)parent, (Object)config.getInterpolator().getParentInterpolator());
    }

    @Test
    public void testSetPrefixLookupsExistingInterpolator() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{look});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        int count = config.getInterpolator().getLookups().size();
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        lookups.put("test", look);
        config.setPrefixLookups(lookups);
        Map lookups2 = config.getInterpolator().getLookups();
        Assert.assertEquals((String)"Not added", (long)(count + 1), (long)lookups2.size());
        Assert.assertSame((String)"Not found", (Object)look, lookups2.get("test"));
    }

    @Test
    public void testSetPrefixLookupsNoInterpolator() {
        Lookup look = (Lookup)EasyMock.createMock(Lookup.class);
        EasyMock.replay((Object[])new Object[]{look});
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setPrefixLookups(Collections.singletonMap("test", look));
        Map lookups = config.getInterpolator().getLookups();
        Assert.assertEquals((String)"Wrong number of lookups", (long)1L, (long)lookups.size());
        Assert.assertSame((String)"Not found", (Object)look, lookups.get("test"));
    }

    @Test
    public void testSizeInternal() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        Assert.assertEquals((String)"Wrong size", (long)12L, (long)config.size());
    }

    static class TestConfigurationImpl
    extends AbstractConfiguration {
        private final AbstractConfiguration config;

        public TestConfigurationImpl(AbstractConfiguration wrappedConfig) {
            this.config = wrappedConfig;
        }

        protected void addPropertyDirect(String key, Object value) {
            this.config.addPropertyDirect(key, value);
        }

        protected void clearPropertyDirect(String key) {
            this.config.clearPropertyDirect(key);
        }

        protected boolean containsKeyInternal(String key) {
            return this.config.containsKey(key);
        }

        protected Iterator<String> getKeysInternal() {
            return this.config.getKeys();
        }

        protected Object getPropertyInternal(String key) {
            return this.config.getProperty(key);
        }

        public AbstractConfiguration getUnderlyingConfiguration() {
            return this.config;
        }

        protected boolean isEmptyInternal() {
            return this.config.isEmpty();
        }
    }

    private static class CollectingConfigurationListener
    implements EventListener<ConfigurationEvent> {
        final List<ConfigurationEvent> events = new ArrayList<ConfigurationEvent>();

        private CollectingConfigurationListener() {
        }

        public void onEvent(ConfigurationEvent event) {
            this.events.add(event);
        }
    }
}

