/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.NonStringTestHolder;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseNonStringProperties {
    protected NonStringTestHolder nonStringTestHolder = new NonStringTestHolder();
    protected Configuration conf;

    @Test
    public void testBoolean() throws Exception {
        this.nonStringTestHolder.testBoolean();
    }

    @Test
    public void testBooleanArrayValue() throws Exception {
        boolean booleanValue = this.conf.getBoolean("test.boolean");
        Assert.assertTrue((boolean)booleanValue);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.boolean.array").size());
    }

    @Test
    public void testBooleanDefaultValue() throws Exception {
        this.nonStringTestHolder.testBooleanDefaultValue();
    }

    @Test
    public void testByte() throws Exception {
        this.nonStringTestHolder.testByte();
    }

    @Test
    public void testByteArrayValue() throws Exception {
        int testValue = 10;
        byte byteValue = this.conf.getByte("test.byte");
        Assert.assertEquals((long)10L, (long)byteValue);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.byte.array").size());
    }

    @Test
    public void testDouble() throws Exception {
        this.nonStringTestHolder.testDouble();
    }

    @Test
    public void testDoubleArrayValue() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.conf.getDouble("test.double");
        Assert.assertEquals((double)10.25, (double)doubleValue, (double)0.01);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.double.array").size());
    }

    @Test
    public void testDoubleDefaultValue() throws Exception {
        this.nonStringTestHolder.testDoubleDefaultValue();
    }

    @Test
    public void testFloat() throws Exception {
        this.nonStringTestHolder.testFloat();
    }

    @Test
    public void testFloatArrayValue() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.conf.getFloat("test.float");
        Assert.assertEquals((double)20.25, (double)floatValue, (double)0.01);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.float.array").size());
    }

    @Test
    public void testFloatDefaultValue() throws Exception {
        this.nonStringTestHolder.testFloatDefaultValue();
    }

    @Test
    public void testInteger() throws Exception {
        this.nonStringTestHolder.testInteger();
    }

    @Test
    public void testIntegerArrayValue() throws Exception {
        int intValue = this.conf.getInt("test.integer");
        Assert.assertEquals((long)10L, (long)intValue);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.integer.array").size());
    }

    @Test
    public void testIntegerDefaultValue() throws Exception {
        this.nonStringTestHolder.testIntegerDefaultValue();
    }

    @Test
    public void testIsEmpty() throws Exception {
        this.nonStringTestHolder.testIsEmpty();
    }

    @Test
    public void testListMissing() throws Exception {
        this.nonStringTestHolder.testListMissing();
    }

    @Test
    public void testLong() throws Exception {
        this.nonStringTestHolder.testLong();
    }

    @Test
    public void testLongArrayValue() throws Exception {
        long longValue = this.conf.getLong("test.long");
        Assert.assertEquals((long)1000000L, (long)longValue);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.long.array").size());
    }

    @Test
    public void testLongDefaultValue() throws Exception {
        this.nonStringTestHolder.testLongDefaultValue();
    }

    @Test
    public void testShort() throws Exception {
        this.nonStringTestHolder.testShort();
    }

    @Test
    public void testShortArrayValue() throws Exception {
        short shortValue = this.conf.getShort("test.short");
        Assert.assertEquals((long)1L, (long)shortValue);
        Assert.assertEquals((long)2L, (long)this.conf.getList("test.short.array").size());
    }

    @Test
    public void testShortDefaultValue() throws Exception {
        this.nonStringTestHolder.testShortDefaultValue();
    }

    @Test
    public void testSubset() throws Exception {
        this.nonStringTestHolder.testSubset();
    }
}

