/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration2.tree.xpath.XPathContextFactory;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestXPathExpressionEngine {
    private static final String TEST_KEY = "TESTKEY";
    private static final String ROOT_NAME = "testRoot";
    private static ImmutableNode root;
    private static NodeHandler<ImmutableNode> handler;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder().name(ROOT_NAME).create();
        handler = new InMemoryNodeModel(root).getNodeHandler();
    }

    private JXPathContext expectSelect(Object ... results) {
        JXPathContext ctx = (JXPathContext)EasyMock.createMock(JXPathContext.class);
        EasyMock.expect((Object)ctx.selectNodes(TEST_KEY)).andReturn(Arrays.asList(results));
        EasyMock.replay((Object[])new Object[]{ctx});
        return ctx;
    }

    private XPathExpressionEngine setUpEngine(JXPathContext ctx) {
        XPathContextFactory factory = (XPathContextFactory)EasyMock.createMock(XPathContextFactory.class);
        EasyMock.expect((Object)factory.createContext((Object)root, handler)).andReturn((Object)ctx);
        EasyMock.replay((Object[])new Object[]{factory});
        return new XPathExpressionEngine(factory);
    }

    @Test
    public void testDefaultContextFactory() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertNotNull((String)"No context factory", (Object)engine.getContextFactory());
    }

    @Test
    public void testQueryNodeExpression() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        List result = engine.query((Object)root, TEST_KEY, handler);
        Assert.assertEquals((String)"Incorrect number of results", (long)1L, (long)result.size());
        Assert.assertSame((String)"Wrong result node", (Object)root, (Object)((QueryResult)result.get(0)).getNode());
        Assert.assertFalse((String)"No node result", (boolean)((QueryResult)result.get(0)).isAttributeResult());
    }

    @Test
    public void testQueryAttributeExpression() {
        QueryResult attrResult = QueryResult.createAttributeResult((Object)root, (String)"attr");
        JXPathContext ctx = this.expectSelect(attrResult);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        List result = engine.query((Object)root, TEST_KEY, handler);
        Assert.assertEquals((String)"Incorrect number of results", (long)1L, (long)result.size());
        Assert.assertSame((String)"Wrong result", (Object)attrResult, result.get(0));
    }

    @Test
    public void testQueryWithoutResult() {
        JXPathContext ctx = this.expectSelect(new Object[0]);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        Assert.assertTrue((String)"Got results", (boolean)engine.query((Object)root, TEST_KEY, handler).isEmpty());
    }

    @Test
    public void testQueryWithEmptyKey() {
        this.checkEmptyKey("");
    }

    @Test
    public void testQueryWithNullKey() {
        this.checkEmptyKey(null);
    }

    private void checkEmptyKey(String key) {
        XPathContextFactory factory = (XPathContextFactory)EasyMock.createMock(XPathContextFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        XPathExpressionEngine engine = new XPathExpressionEngine(factory);
        List results = engine.query((Object)root, key, handler);
        Assert.assertEquals((String)"Incorrect number of results", (long)1L, (long)results.size());
        Assert.assertSame((String)"Wrong result node", (Object)root, (Object)((QueryResult)results.get(0)).getNode());
    }

    @Test
    public void testNodePointerFactory() {
        JXPathContext.newContext((Object)this);
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        boolean found = false;
        for (NodePointerFactory factory : factories) {
            if (!(factory instanceof ConfigurationNodePointerFactory)) continue;
            found = true;
        }
        Assert.assertTrue((String)"No configuration pointer factory found", (boolean)found);
    }

    @Test
    public void testNodeKeyNormal() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong node key", (Object)"parent/testRoot", (Object)engine.nodeKey((Object)root, "parent", handler));
    }

    @Test
    public void testNodeKeyForRootNode() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key for root node", (Object)"", (Object)engine.nodeKey((Object)root, null, handler));
    }

    @Test
    public void testNodeKeyNoNodeName() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Null name not detected", (Object)"test", (Object)engine.nodeKey((Object)new ImmutableNode.Builder().create(), "test", handler));
    }

    @Test
    public void testNodeKeyForRootChild() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key for root child node", (Object)ROOT_NAME, (Object)engine.nodeKey((Object)root, "", handler));
    }

    @Test
    public void testNodeKeyAttribute() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong attribute key", (Object)"node/@attr", (Object)engine.attributeKey("node", "attr"));
    }

    @Test
    public void testAttributeKeyOfRootNode() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key for root attribute", (Object)"@child", (Object)engine.attributeKey(null, "child"));
    }

    @Test
    public void testPrepareAddNode() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY  newNode", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "newNode");
    }

    @Test
    public void testPrepareAddAttribute() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY\t@newAttr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "newAttr");
    }

    @Test
    public void testPrepareAddPath() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY \t a/full/path/node", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "a", "full", "path", "node");
    }

    @Test
    public void testPrepareAddAttributePath() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY a/full/path@attr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "a", "full", "path", "attr");
    }

    @Test
    public void testPrepareAddRootChild() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, " newNode", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "newNode");
    }

    @Test
    public void testPrepareAddRootAttribute() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, " @attr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "attr");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidParent() {
        JXPathContext ctx = this.expectSelect(new Object[0]);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        engine.prepareAdd((Object)root, "TESTKEY test", handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyPath() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        engine.prepareAdd((Object)root, "TESTKEY ", handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddNullKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        engine.prepareAdd((Object)root, null, handler);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        engine.prepareAdd((Object)root, "", handler);
    }

    private void checkInvalidAddPath(String path) {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        QueryResult res = QueryResult.createNodeResult((Object)root);
        engine.createNodeAddData(path, res);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPath() {
        this.checkInvalidAddPath("an/invalid//path");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidAttributePath() {
        this.checkInvalidAddPath("a/path/with@an/attribute");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidAttributePath2() {
        this.checkInvalidAddPath("a/path/with/@attribute");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPathWithSlash() {
        this.checkInvalidAddPath("/a/path/node");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPathMultipleAttributes() {
        this.checkInvalidAddPath("an@attribute@path");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddToAttributeResult() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        QueryResult result = QueryResult.createAttributeResult((Object)root, (String)TEST_KEY);
        engine.createNodeAddData("path", result);
    }

    private static void checkAddPath(NodeAddData<ImmutableNode> data, boolean attr, String ... expected) {
        Assert.assertSame((String)"Wrong parent node", (Object)root, (Object)data.getParent());
        List path = data.getPathNodes();
        Assert.assertEquals((String)"Incorrect number of path nodes", (long)(expected.length - 1), (long)path.size());
        Iterator it = path.iterator();
        for (int idx = 0; idx < expected.length - 1; ++idx) {
            Assert.assertEquals((String)("Wrong node at position " + idx), (Object)expected[idx], it.next());
        }
        Assert.assertEquals((String)"Wrong name of new node", (Object)expected[expected.length - 1], (Object)data.getNewNodeName());
        Assert.assertEquals((String)"Incorrect attribute flag", (Object)attr, (Object)data.isAttribute());
    }

    @Test
    public void testCanonicalKeyNoDuplicates() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(2);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c2 = new ImmutableNode.Builder().name("child_other").create();
        parentBuilder.addChildren(Arrays.asList(c2, c1));
        ImmutableNode parent = parentBuilder.create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong canonical key", (Object)"parent/child[1]", (Object)engine.canonicalKey((Object)c1, "parent", testHandler));
    }

    @Test
    public void testCanonicalKeyWithDuplicates() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(3);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c2 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c3 = new ImmutableNode.Builder().name("child_other").create();
        parentBuilder.addChildren(Arrays.asList(c1, c2, c3));
        ImmutableNode parent = parentBuilder.create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key 1", (Object)"parent/child[1]", (Object)engine.canonicalKey((Object)c1, "parent", testHandler));
        Assert.assertEquals((String)"Wrong key 2", (Object)"parent/child[2]", (Object)engine.canonicalKey((Object)c2, "parent", testHandler));
    }

    @Test
    public void testCanonicalKeyNoParentKey() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(1);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode parent = parentBuilder.addChild(c1).create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key", (Object)"child[1]", (Object)engine.canonicalKey((Object)c1, null, testHandler));
    }

    @Test
    public void testCanonicalKeyRootNoParentKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key", (Object)"", (Object)engine.canonicalKey((Object)root, null, handler));
    }

    @Test
    public void testCanonicalKeyRootWithParentKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assert.assertEquals((String)"Wrong key", (Object)"parent", (Object)engine.canonicalKey((Object)root, "parent", handler));
    }
}

