/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.InMemoryNodeModelSupport;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.TrackedNodeModel;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTrackedNodeModel {
    private static final String KEY = "aTestKey";
    private static NodeSelector selector;
    private static NodeKeyResolver<ImmutableNode> resolver;
    private InMemoryNodeModel parentModel;
    private InMemoryNodeModelSupport modelSupport;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        selector = new NodeSelector("someKey");
        NodeKeyResolver resolverMock = (NodeKeyResolver)EasyMock.createMock(NodeKeyResolver.class);
        EasyMock.replay((Object[])new Object[]{resolverMock});
        resolver = resolverMock;
    }

    @Before
    public void setUp() throws Exception {
        this.parentModel = (InMemoryNodeModel)EasyMock.createMock(InMemoryNodeModel.class);
        this.modelSupport = (InMemoryNodeModelSupport)EasyMock.createMock(InMemoryNodeModelSupport.class);
        EasyMock.expect((Object)this.modelSupport.getNodeModel()).andReturn((Object)this.parentModel).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.modelSupport});
    }

    private TrackedNodeModel setUpModel() {
        return new TrackedNodeModel(this.modelSupport, selector, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoSelector() {
        new TrackedNodeModel(this.modelSupport, null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInitNoParentModel() {
        new TrackedNodeModel(null, selector, true);
    }

    @Test
    public void testSetRootNode() {
        ImmutableNode root = NodeStructureHelper.createNode("root", null);
        this.parentModel.replaceTrackedNode(selector, root);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        TrackedNodeModel model = this.setUpModel();
        model.setRootNode(root);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    private NodeHandler<ImmutableNode> expectGetNodeHandler() {
        NodeHandler handler = (NodeHandler)EasyMock.createMock(NodeHandler.class);
        EasyMock.expect((Object)this.parentModel.getTrackedNodeHandler(selector)).andReturn((Object)handler);
        return handler;
    }

    @Test
    public void testGetNodeHandler() {
        NodeHandler<ImmutableNode> handler = this.expectGetNodeHandler();
        EasyMock.replay((Object[])new Object[]{handler, this.parentModel});
        Assert.assertSame((String)"Wrong node handler", handler, (Object)this.setUpModel().getNodeHandler());
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testAddProperty() {
        Iterable values = (Iterable)EasyMock.createMock(Iterable.class);
        this.parentModel.addProperty(KEY, selector, values, resolver);
        EasyMock.replay((Object[])new Object[]{values, this.parentModel});
        this.setUpModel().addProperty(KEY, values, resolver);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testAddNodes() {
        List<ImmutableNode> nodes = Arrays.asList(NodeStructureHelper.createNode("n1", 1), NodeStructureHelper.createNode("n2", 2));
        this.parentModel.addNodes(KEY, selector, nodes, resolver);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        this.setUpModel().addNodes(KEY, nodes, resolver);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testSetProperty() {
        Integer value = 42;
        this.parentModel.setProperty(KEY, selector, (Object)value, resolver);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        this.setUpModel().setProperty(KEY, (Object)value, resolver);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testClearTree() {
        QueryResult result = QueryResult.createNodeResult((Object)NodeStructureHelper.createNode("test", null));
        List<QueryResult> removed = Collections.singletonList(result);
        EasyMock.expect((Object)this.parentModel.clearTree(KEY, selector, resolver)).andReturn(removed);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        Assert.assertSame((String)"Wrong removed elements", removed, (Object)this.setUpModel().clearTree(KEY, resolver));
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testClearProperty() {
        this.parentModel.clearProperty(KEY, selector, resolver);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        this.setUpModel().clearProperty(KEY, resolver);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testClear() {
        EasyMock.expect((Object)this.parentModel.clearTree(null, selector, resolver)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        this.setUpModel().clear(resolver);
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testClose() {
        this.parentModel.untrackNode(selector);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        this.setUpModel().close();
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testCloseMultipleTimes() {
        this.parentModel.untrackNode(selector);
        EasyMock.replay((Object[])new Object[]{this.parentModel});
        TrackedNodeModel model = this.setUpModel();
        model.close();
        model.close();
        EasyMock.verify((Object[])new Object[]{this.parentModel});
    }

    @Test
    public void testGetInMemoryRepresentation() {
        NodeHandler<ImmutableNode> handler = this.expectGetNodeHandler();
        ImmutableNode root = NodeStructureHelper.createNode("Root", null);
        EasyMock.expect((Object)handler.getRootNode()).andReturn((Object)root);
        EasyMock.replay((Object[])new Object[]{handler, this.parentModel});
        TrackedNodeModel model = this.setUpModel();
        Assert.assertSame((String)"Wrong root node", (Object)root, (Object)model.getInMemoryRepresentation());
    }
}

