/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitorAdapter;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeTreeWalker;
import org.apache.commons.configuration2.tree.ReferenceNodeHandler;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInMemoryNodeModelReferences {
    private NodeKeyResolver<ImmutableNode> resolver;
    private InMemoryNodeModel model;

    @Before
    public void setUp() throws Exception {
        this.resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.expectResolveKeyForQueries(this.resolver);
        NodeStructureHelper.expectResolveAddKeys(this.resolver);
        EasyMock.replay((Object[])new Object[]{this.resolver});
        this.model = new InMemoryNodeModel();
        Map<ImmutableNode, String> references = this.createReferences();
        this.model.mergeRoot(NodeStructureHelper.ROOT_AUTHORS_TREE, null, references, (Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), this.resolver);
    }

    private Map<ImmutableNode, String> createReferences() {
        Collection<ImmutableNode> nodes = this.collectNodes(NodeStructureHelper.ROOT_AUTHORS_TREE);
        nodes.remove(NodeStructureHelper.ROOT_AUTHORS_TREE);
        HashMap<ImmutableNode, String> refs = new HashMap<ImmutableNode, String>();
        for (ImmutableNode node : nodes) {
            refs.put(node, node.getNodeName());
        }
        return refs;
    }

    private Collection<ImmutableNode> collectNodes(ImmutableNode root) {
        final HashSet<ImmutableNode> nodes = new HashSet<ImmutableNode>();
        NodeTreeWalker.INSTANCE.walkBFS((Object)root, (ConfigurationNodeVisitor)new ConfigurationNodeVisitorAdapter<ImmutableNode>(){

            public void visitBeforeChildren(ImmutableNode node, NodeHandler<ImmutableNode> handler) {
                nodes.add(node);
            }
        }, this.model.getNodeHandler());
        return nodes;
    }

    @Test
    public void testQueryReferences() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Collection<ImmutableNode> nodes = this.collectNodes((ImmutableNode)handler.getRootNode());
        for (ImmutableNode node : nodes) {
            Assert.assertEquals((String)"Wrong reference", (Object)node.getNodeName(), (Object)handler.getReference(node));
        }
    }

    @Test
    public void testQueryReferenceUnknown() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assert.assertNull((String)"Got a reference", (Object)handler.getReference(new ImmutableNode.Builder().create()));
    }

    @Test
    public void testQueryReferencesAfterUpdate() {
        this.model.addProperty("Simmons.Hyperion", Collections.singleton("Lamia"), this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assert.assertEquals((String)"Wrong reference 1", (Object)"Hyperion", (Object)handler.getReference(NodeStructureHelper.nodeForKey(this.model, "Simmons/Hyperion")));
        Assert.assertEquals((String)"Wrong reference 2", (Object)"Simmons", (Object)handler.getReference(NodeStructureHelper.nodeForKey(this.model, "Simmons")));
    }

    @Test
    public void testQueryRemovedReferencesEmpty() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assert.assertTrue((String)"Got removed references", (boolean)handler.removedReferences().isEmpty());
    }

    @Test
    public void testQueryRemovedReferencesAfterRemove() {
        this.model.clearTree("Simmons", this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        List removedRefs = handler.removedReferences();
        int authorIdx = 2;
        for (int i = 0; i < NodeStructureHelper.worksLength(2); ++i) {
            Assert.assertTrue((String)("Work not found: " + i), (boolean)removedRefs.contains(NodeStructureHelper.work(2, i)));
            for (int j = 0; j < NodeStructureHelper.personaeLength(2, i); ++j) {
                Assert.assertTrue((String)("Persona not found: " + j), (boolean)removedRefs.contains(NodeStructureHelper.persona(2, i, j)));
            }
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemovedReferencesModify() {
        this.model.clearTree("Simmons", this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        List removedRefs = handler.removedReferences();
        removedRefs.add("another one");
    }

    @Test
    public void testMergeRootWithValue() {
        ImmutableNode node = NodeStructureHelper.createNode("newNode", "test");
        this.model.mergeRoot(node, null, null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assert.assertEquals((String)"Wrong node name", (Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), (Object)root.getNodeName());
        Assert.assertEquals((String)"Wrong node value", (Object)"test", (Object)root.getValue());
    }

    @Test
    public void testMergeRootOverrideName() {
        ImmutableNode node = NodeStructureHelper.createNode("newNode", null);
        String newName = "newRootNode";
        this.model.mergeRoot(node, "newRootNode", null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assert.assertEquals((String)"Wrong root name", (Object)"newRootNode", (Object)root.getNodeName());
    }

    @Test
    public void testMergeRootWithAttributes() {
        ImmutableNode node = new ImmutableNode.Builder().addAttribute("key", (Object)"value").create();
        this.model.mergeRoot(node, null, null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assert.assertEquals((String)"Wrong number of attributes", (long)1L, (long)root.getAttributes().size());
        Assert.assertEquals((String)"Wrong attribute", (Object)"value", root.getAttributes().get("key"));
    }

    @Test
    public void testMergeRootReference() {
        Long rootRef = 20140404210508L;
        ImmutableNode node = NodeStructureHelper.createNode("newNode", null);
        this.model.mergeRoot(node, null, null, (Object)rootRef, this.resolver);
        ReferenceNodeHandler refHandler = this.model.getReferenceNodeHandler();
        ImmutableNode checkNode = NodeStructureHelper.nodeForKey(this.model, "Simmons/Ilium");
        Assert.assertEquals((String)"Wrong reference for node", (Object)checkNode.getNodeName(), (Object)refHandler.getReference(checkNode));
        Assert.assertEquals((String)"Wrong root reference", (Object)rootRef, (Object)refHandler.getReference((ImmutableNode)refHandler.getRootNode()));
    }

    @Test
    public void testReplaceRoot() {
        NodeSelector selector = new NodeSelector("Simmons.Hyperion");
        this.model.trackNode(selector, this.resolver);
        ImmutableNode trackedNode = this.model.getTrackedNode(selector);
        this.model.addProperty("Simmons.Hyperion.Lamia", Collections.singleton("new person"), this.resolver);
        this.model.replaceRoot(NodeStructureHelper.ROOT_AUTHORS_TREE, this.resolver);
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assert.assertEquals((String)"Wrong tracked node", (Object)trackedNode, (Object)node);
        Assert.assertFalse((String)"Node is detached", (boolean)this.model.isTrackedNodeDetached(selector));
        Assert.assertNull((String)"Reference not cleared", (Object)this.model.getReferenceNodeHandler().getReference(trackedNode));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceRootNull() {
        this.model.replaceRoot(null, this.resolver);
    }
}

