/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractImmutableNodeHandlerTest {
    protected abstract NodeHandler<ImmutableNode> createHandler(ImmutableNode var1);

    @Test
    public void testGetParentNode() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        for (int authorIdx = 0; authorIdx < NodeStructureHelper.authorsLength(); ++authorIdx) {
            ImmutableNode authorNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), NodeStructureHelper.author(authorIdx));
            Assert.assertSame((String)("Wrong parent for " + NodeStructureHelper.author(authorIdx)), (Object)handler.getRootNode(), (Object)handler.getParent((Object)authorNode));
            for (int workIdx = 0; workIdx < NodeStructureHelper.worksLength(authorIdx); ++workIdx) {
                String workKey = NodeStructureHelper.appendPath(NodeStructureHelper.author(authorIdx), NodeStructureHelper.work(authorIdx, workIdx));
                ImmutableNode workNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), workKey);
                Assert.assertSame((String)("Wrong parent for " + workKey), (Object)authorNode, (Object)handler.getParent((Object)workNode));
                for (int personaIdx = 0; personaIdx < NodeStructureHelper.personaeLength(authorIdx, workIdx); ++personaIdx) {
                    String personKey = NodeStructureHelper.appendPath(workKey, NodeStructureHelper.persona(authorIdx, workIdx, personaIdx));
                    ImmutableNode personNode = NodeStructureHelper.nodeForKey((ImmutableNode)handler.getRootNode(), personKey);
                    Assert.assertSame((String)("Wrong parent for " + personKey), (Object)workNode, (Object)handler.getParent((Object)personNode));
                }
            }
        }
    }

    @Test
    public void testGetParentForRoot() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assert.assertNull((String)"Got a parent", (Object)handler.getParent((Object)NodeStructureHelper.ROOT_AUTHORS_TREE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetParentInvalidNode() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        handler.getParent((Object)new ImmutableNode.Builder().name("unknown").create());
    }

    @Test
    public void testNodeHandlerName() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode author = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assert.assertEquals((String)"Wrong node name", (Object)NodeStructureHelper.author(0), (Object)handler.nodeName((Object)author));
    }

    @Test
    public void testNodeHandlerValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode work = NodeStructureHelper.nodeForKey(handler, "Shakespeare/The Tempest");
        int year = 1611;
        work = work.setValue((Object)1611);
        Assert.assertEquals((String)"Wrong value", (Object)1611, (Object)handler.getValue((Object)work));
    }

    @Test
    public void testNodeHandlerGetChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assert.assertSame((String)"Wrong children", (Object)node.getChildren(), (Object)handler.getChildren((Object)node));
    }

    @Test
    public void testNodeHandlerGetChildrenByName() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        String name = "Achilles";
        HashSet children = new HashSet(handler.getChildren((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Achilles"));
        Assert.assertEquals((String)"Wrong number of children", (long)3L, (long)children.size());
        for (ImmutableNode c : children) {
            Assert.assertEquals((String)"Wrong node name", (Object)"Achilles", (Object)c.getNodeName());
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNodeHandlerGetChildrenByNameImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        List children = handler.getChildren((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Ajax");
        children.add(null);
    }

    @Test
    public void testNodeHandlerGetChildAtIndex() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assert.assertSame((String)"Wrong child", node.getChildren().get(1), (Object)handler.getChild((Object)node, 1));
    }

    @Test
    public void testNodeHandlerIndexOfChild() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        String key = "Simmons/Hyperion";
        ImmutableNode parent = NodeStructureHelper.nodeForKey(handler, "Simmons/Hyperion");
        ImmutableNode child = NodeStructureHelper.nodeForKey(handler, "Simmons/Hyperion/Weintraub");
        Assert.assertEquals((String)"Wrong child index", (long)3L, (long)handler.indexOfChild((Object)parent, (Object)child));
    }

    @Test
    public void testNodeHandlerIndexOfUnknownChild() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode parent = NodeStructureHelper.nodeForKey(handler, "Homer/Ilias");
        ImmutableNode child = NodeStructureHelper.nodeForKey(handler, "Shakespeare/Troilus and Cressida/Achilles");
        Assert.assertEquals((String)"Wrong child index", (long)-1L, (long)handler.indexOfChild((Object)parent, (Object)child));
    }

    @Test
    public void testNodeHandlerGetChildrenCountAll() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(0));
        Assert.assertEquals((String)"Wrong number of children", (long)NodeStructureHelper.worksLength(0), (long)handler.getChildrenCount((Object)node, null));
    }

    @Test
    public void testNodeHandlerGetChildrenCountSpecific() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assert.assertEquals((String)"Wrong number of children", (long)3L, (long)handler.getChildrenCount((Object)NodeStructureHelper.ROOT_PERSONAE_TREE, "Achilles"));
    }

    @Test
    public void testNodeHandlerGetAttributes() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        Assert.assertEquals((String)"Wrong attributes", node.getAttributes().keySet(), (Object)handler.getAttributes((Object)node));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNodeHandlerGetAttributesImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        handler.getAttributes((Object)node).add("test");
    }

    @Test
    public void testNodeHandlerHasAttributesTrue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Puck");
        Assert.assertTrue((String)"No attributes", (boolean)handler.hasAttributes((Object)node));
    }

    @Test
    public void testNodeHandlerHasAttributesFalse() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        Assert.assertFalse((String)"Got attributes", (boolean)handler.hasAttributes((Object)NodeStructureHelper.ROOT_PERSONAE_TREE));
    }

    @Test
    public void testNodeHandlerGetAttributeValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, "Prospero");
        Assert.assertEquals((String)"Wrong value", (Object)"Shakespeare", (Object)handler.getAttributeValue((Object)node, "author"));
    }

    @Test
    public void testNodeHandlerIsDefinedChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        ImmutableNode node = NodeStructureHelper.nodeForKey(handler, NodeStructureHelper.author(2));
        Assert.assertTrue((String)"Not defined", (boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedAttributes() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().addAttribute("author", (Object)NodeStructureHelper.author(0)).create();
        Assert.assertTrue((String)"Not defined", (boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedValue() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().value((Object)42).create();
        Assert.assertTrue((String)"Not defined", (boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerIsDefinedFalse() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_PERSONAE_TREE);
        ImmutableNode node = new ImmutableNode.Builder().name(NodeStructureHelper.author(1)).create();
        Assert.assertFalse((String)"Defined", (boolean)handler.isDefined((Object)node));
    }

    @Test
    public void testNodeHandlerGetMatchingChildren() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        final ImmutableNode target = NodeStructureHelper.nodeForKey(NodeStructureHelper.ROOT_AUTHORS_TREE, NodeStructureHelper.author(1));
        final HashSet encounteredAuthors = new HashSet();
        NodeMatcher<ImmutableNode> matcher = new NodeMatcher<ImmutableNode>(){

            public <T> boolean matches(T node, NodeHandler<T> paramHandler, ImmutableNode criterion) {
                encounteredAuthors.add(paramHandler.nodeName(node));
                return node == target;
            }
        };
        List result = handler.getMatchingChildren(handler.getRootNode(), (NodeMatcher)matcher, (Object)target);
        Assert.assertEquals((String)"Wrong number of matched nodes", (long)1L, (long)result.size());
        Assert.assertSame((String)"Wrong result", (Object)target, result.get(0));
        Assert.assertEquals((String)"Wrong number of encountered nodes", (long)NodeStructureHelper.authorsLength(), (long)encounteredAuthors.size());
        for (int i = 0; i < NodeStructureHelper.authorsLength(); ++i) {
            Assert.assertTrue((String)("Author not found: " + NodeStructureHelper.author(i)), (boolean)encounteredAuthors.contains(NodeStructureHelper.author(i)));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNodeHandlerGetMatchingChildrenImmutable() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        List result = handler.getMatchingChildren(handler.getRootNode(), (NodeMatcher)new DummyNodeMatcher(), (Object)this);
        result.clear();
    }

    @Test
    public void testNodeHandlerGetMatchingChildrenCount() {
        NodeHandler<ImmutableNode> handler = this.createHandler(NodeStructureHelper.ROOT_AUTHORS_TREE);
        Assert.assertEquals((String)"Wrong result", (long)NodeStructureHelper.authorsLength(), (long)handler.getMatchingChildrenCount(handler.getRootNode(), (NodeMatcher)new DummyNodeMatcher(), (Object)this));
    }

    private static class DummyNodeMatcher
    implements NodeMatcher<Object> {
        private DummyNodeMatcher() {
        }

        public <T> boolean matches(T node, NodeHandler<T> handler, Object criterion) {
            return true;
        }
    }
}

