/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestHomeDirectoryLocationStrategy {
    private static final String FILE_NAME = "test.tst";
    private static final String BASE_PATH = "sub";
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private FileSystem fileSystem;

    @Before
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{this.fileSystem});
    }

    private HomeDirectoryLocationStrategy setUpStrategy(boolean withBasePath) {
        return new HomeDirectoryLocationStrategy(this.folder.getRoot().getAbsolutePath(), withBasePath);
    }

    @Test
    public void testInitDefaults() {
        HomeDirectoryLocationStrategy strategy = new HomeDirectoryLocationStrategy();
        Assert.assertEquals((String)"Wrong home directory", (Object)System.getProperty("user.home"), (Object)strategy.getHomeDirectory());
        Assert.assertFalse((String)"Wrong base path flag", (boolean)strategy.isEvaluateBasePath());
    }

    @Test
    public void testLocateSuccessIgnoreBasePath() throws IOException {
        File file = this.folder.newFile(FILE_NAME);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(false);
        URL url = strategy.locate(this.fileSystem, locator);
        Assert.assertEquals((String)"Wrong URL", (Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testLocateFailedWithBasePath() throws IOException {
        this.folder.newFile(FILE_NAME);
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        Assert.assertNull((String)"Got a URL", (Object)strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testLocateSuccessInSubFolder() throws IOException {
        File sub = this.folder.newFolder(BASE_PATH);
        File file = new File(sub, FILE_NAME);
        Assert.assertTrue((String)"Could not create file", (boolean)file.createNewFile());
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        URL url = strategy.locate(this.fileSystem, locator);
        Assert.assertEquals((String)"Wrong URL", (Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testLocateSuccessNoBasePath() throws IOException {
        File file = this.folder.newFile(FILE_NAME);
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        URL url = strategy.locate(this.fileSystem, locator);
        Assert.assertEquals((String)"Wrong URL", (Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).create();
        HomeDirectoryLocationStrategy strategy = this.setUpStrategy(true);
        Assert.assertNull((String)"Got a URL", (Object)strategy.locate(this.fileSystem, locator));
    }
}

