/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.event.BaseEventSource;
import org.apache.commons.configuration2.event.ConfigurationErrorEvent;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.ErrorListenerTestImpl;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventListenerRegistrationData;
import org.apache.commons.configuration2.event.EventListenerTestImpl;
import org.apache.commons.configuration2.event.EventType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEventSource {
    private final String TEST_PROPNAME = "test.property.name";
    private static final Object TEST_PROPVALUE = "a test property value";
    private CountingEventSource source;

    @Before
    public void setUp() throws Exception {
        this.source = new CountingEventSource();
    }

    @Test
    public void testInit() {
        Assert.assertTrue((String)"Listeners list is not empty", (boolean)this.source.getEventListenerRegistrations().isEmpty());
        Assert.assertFalse((String)"Removing listener", (boolean)this.source.removeEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null)));
        Assert.assertFalse((String)"Detail events are enabled", (boolean)this.source.isDetailEvents());
    }

    @Test
    public void testAddEventListener() {
        EventListenerTestImpl l = new EventListenerTestImpl(this);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        Collection listeners = this.source.getEventListeners(ConfigurationEvent.ANY);
        Assert.assertEquals((String)"Wrong number of listeners", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Listener not in list", (boolean)listeners.contains(l));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullEventListener() {
        this.source.addEventListener(ConfigurationEvent.ANY, null);
    }

    @Test
    public void testRemoveEventListener() {
        EventListenerTestImpl l = new EventListenerTestImpl(this);
        Assert.assertFalse((String)"Listener can be removed?", (boolean)this.source.removeEventListener(ConfigurationEvent.ANY, l));
        this.source.addEventListener(ConfigurationEvent.ADD_NODES, new EventListenerTestImpl(this));
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        Assert.assertFalse((String)"Unknown listener can be removed", (boolean)this.source.removeEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null)));
        Assert.assertTrue((String)"Could not remove listener", (boolean)this.source.removeEventListener(ConfigurationEvent.ANY, l));
        Assert.assertFalse((String)"Listener still in list", (boolean)this.source.getEventListeners(ConfigurationEvent.ANY).contains(l));
    }

    @Test
    public void testRemoveNullEventListener() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Assert.assertFalse((String)"Null listener can be removed", (boolean)this.source.removeEventListener(ConfigurationEvent.ANY, null));
        Assert.assertEquals((String)"Listener list was modified", (long)1L, (long)this.source.getEventListeners(ConfigurationEvent.ANY).size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetEventListenersUpdate() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Collection list = this.source.getEventListeners(ConfigurationEvent.ANY);
        list.clear();
    }

    @Test
    public void testGetEventListenersAddNew() {
        Collection list = this.source.getEventListeners(ConfigurationEvent.ANY);
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(null));
        Assert.assertTrue((String)"Listener snapshot not empty", (boolean)list.isEmpty());
    }

    @Test
    public void testSetDetailEvents() {
        this.source.setDetailEvents(true);
        Assert.assertTrue((String)"Detail events are disabled", (boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(true);
        this.source.setDetailEvents(false);
        Assert.assertTrue((String)"Detail events are disabled again", (boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(false);
        Assert.assertFalse((String)"Detail events are still enabled", (boolean)this.source.isDetailEvents());
    }

    @Test
    public void testFireEvent() {
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.fireEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, true);
        l.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, true);
        l.done();
    }

    @Test
    public void testFireEventNoListeners() {
        this.source.fireEvent(ConfigurationEvent.ADD_NODES, "test.property.name", TEST_PROPVALUE, false);
        Assert.assertEquals((String)"An event object was created", (long)0L, (long)this.source.eventCount);
    }

    @Test
    public void testFireEventNoDetails() {
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.setDetailEvents(false);
        this.source.fireEvent(ConfigurationEvent.SET_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        Assert.assertEquals((String)"Event object was created", (long)0L, (long)this.source.eventCount);
        l.done();
    }

    @Test
    public void testRemoveListenerInFireEvent() {
        EventListener<ConfigurationEvent> lstRemove = new EventListener<ConfigurationEvent>(){

            public void onEvent(ConfigurationEvent event) {
                TestEventSource.this.source.removeEventListener(ConfigurationEvent.ANY, this);
            }
        };
        this.source.addEventListener(ConfigurationEvent.ANY, (EventListener)lstRemove);
        EventListenerTestImpl l = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l);
        this.source.fireEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        l.checkEvent(ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, false);
        Assert.assertEquals((String)"Listener was not removed", (long)1L, (long)this.source.getEventListeners(ConfigurationEvent.ANY).size());
    }

    @Test
    public void testFireError() {
        ErrorListenerTestImpl lstRead = new ErrorListenerTestImpl(this.source);
        ErrorListenerTestImpl lstWrite = new ErrorListenerTestImpl(this.source);
        ErrorListenerTestImpl lstAll = new ErrorListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationErrorEvent.READ, lstRead);
        this.source.addEventListener(ConfigurationErrorEvent.WRITE, lstWrite);
        this.source.addEventListener(ConfigurationErrorEvent.ANY, lstAll);
        Exception testException = new Exception("A test");
        this.source.fireError(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE, testException);
        lstRead.done();
        Assert.assertEquals((String)"Wrong exception (1)", (Object)testException, (Object)lstWrite.checkEvent(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE));
        lstWrite.done();
        Assert.assertEquals((String)"Wrong exception (2)", (Object)testException, (Object)lstAll.checkEvent(ConfigurationErrorEvent.WRITE, ConfigurationEvent.ADD_PROPERTY, "test.property.name", TEST_PROPVALUE));
        lstAll.done();
        Assert.assertEquals((String)"Wrong number of error events created", (long)1L, (long)this.source.errorCount);
    }

    @Test
    public void testFireErrorNoListeners() {
        this.source.fireError(ConfigurationErrorEvent.ANY, ConfigurationEvent.ANY, "test.property.name", TEST_PROPVALUE, new Exception());
        Assert.assertEquals((String)"An error event object was created", (long)0L, (long)this.source.errorCount);
    }

    @Test
    public void testClone() throws CloneNotSupportedException {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(this.source));
        BaseEventSource copy = (BaseEventSource)this.source.clone();
        Assert.assertTrue((String)"Configuration listeners registered for clone", (boolean)copy.getEventListenerRegistrations().isEmpty());
    }

    @Test
    public void testClearEventListeners() {
        this.source.addEventListener(ConfigurationEvent.ANY, new EventListenerTestImpl(this.source));
        this.source.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, new EventListenerTestImpl(this.source));
        this.source.clearEventListeners();
        Assert.assertTrue((String)"Got ANY listeners", (boolean)this.source.getEventListeners(ConfigurationEvent.ANY).isEmpty());
        Assert.assertTrue((String)"Got HIERARCHICAL listeners", (boolean)this.source.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL).isEmpty());
    }

    @Test
    public void testCopyEventListeners() {
        EventListenerTestImpl l1 = new EventListenerTestImpl(this.source);
        EventListenerTestImpl l2 = new EventListenerTestImpl(this.source);
        this.source.addEventListener(ConfigurationEvent.ANY, l1);
        this.source.addEventListener(ConfigurationEvent.ANY_HIERARCHICAL, l2);
        BaseEventSource source2 = new BaseEventSource();
        this.source.copyEventListeners(source2);
        Collection listeners = source2.getEventListeners(ConfigurationEvent.ANY_HIERARCHICAL);
        Assert.assertEquals((String)"Wrong number of listeners (1)", (long)2L, (long)listeners.size());
        Assert.assertTrue((String)"l1 not found", (boolean)listeners.contains(l1));
        Assert.assertTrue((String)"l2 not found", (boolean)listeners.contains(l2));
        listeners = source2.getEventListeners(ConfigurationEvent.ANY);
        Assert.assertEquals((String)"Wrong number of listeners (2)", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Wrong listener", (boolean)listeners.contains(l1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopyEventListenersNullSource() {
        this.source.copyEventListeners(null);
    }

    @Test
    public void testClearErrorListeners() {
        EventListenerTestImpl cl = new EventListenerTestImpl(null);
        ErrorListenerTestImpl el1 = new ErrorListenerTestImpl(null);
        ErrorListenerTestImpl el2 = new ErrorListenerTestImpl(null);
        ErrorListenerTestImpl el3 = new ErrorListenerTestImpl(null);
        this.source.addEventListener(ConfigurationErrorEvent.READ, el1);
        this.source.addEventListener(ConfigurationErrorEvent.ANY, el2);
        this.source.addEventListener(ConfigurationEvent.ANY, cl);
        this.source.addEventListener(ConfigurationErrorEvent.WRITE, el3);
        this.source.clearErrorListeners();
        List regs = this.source.getEventListenerRegistrations();
        Assert.assertEquals((String)"Wrong number of event listener registrations", (long)1L, (long)regs.size());
        Assert.assertSame((String)"Wrong remaining listener", (Object)cl, (Object)((EventListenerRegistrationData)regs.get(0)).getListener());
    }

    private static class CountingEventSource
    extends BaseEventSource
    implements Cloneable {
        int eventCount;
        int errorCount;

        private CountingEventSource() {
        }

        protected <T extends ConfigurationEvent> ConfigurationEvent createEvent(EventType<T> eventType, String propName, Object propValue, boolean before) {
            ++this.eventCount;
            return super.createEvent(eventType, propName, propValue, before);
        }

        protected ConfigurationErrorEvent createErrorEvent(EventType<? extends ConfigurationErrorEvent> type, EventType<?> opType, String propName, Object propValue, Throwable ex) {
            ++this.errorCount;
            return super.createErrorEvent(type, opType, propName, propValue, ex);
        }
    }
}

