/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PatternSubtreeConfigurationWrapper;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPatternSubtreeConfiguration {
    private static File CONFIG_FILE = ConfigurationAssert.getTestFile("testPatternSubtreeConfig.xml");
    private static String PATTERN = "BusinessClient[@name='${sys:Id}']";
    private XMLConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new XMLConfiguration();
        new FileHandler((FileBased)this.conf).load(CONFIG_FILE);
    }

    @Test
    public void testMultiConfiguration() {
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)this.conf, PATTERN);
        config.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        System.setProperty("Id", "1001");
        Assert.assertTrue((config.getInt("rowsPerPage") == 15 ? 1 : 0) != 0);
        System.setProperty("Id", "1002");
        Assert.assertTrue((config.getInt("rowsPerPage") == 25 ? 1 : 0) != 0);
        System.setProperty("Id", "1003");
        Assert.assertTrue((config.getInt("rowsPerPage") == 35 ? 1 : 0) != 0);
    }

    @Test(expected=ConfigurationException.class)
    public void testReadNotFileBased() throws ConfigurationException {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)hc, PATTERN);
        new FileHandler((FileBased)config).load(CONFIG_FILE);
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveNotFileBased() throws ConfigurationException {
        BaseHierarchicalConfiguration hc = new BaseHierarchicalConfiguration();
        PatternSubtreeConfigurationWrapper config = new PatternSubtreeConfigurationWrapper((HierarchicalConfiguration)hc, PATTERN);
        new FileHandler((FileBased)config).save((Writer)new StringWriter());
    }
}

