/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationConverter {
    @Test
    public void testPropertiesToConfiguration() {
        Properties props = new Properties();
        props.setProperty("string", "teststring");
        props.setProperty("int", "123");
        props.setProperty("list", "item 1, item 2");
        AbstractConfiguration config = (AbstractConfiguration)ConfigurationConverter.getConfiguration((Properties)props);
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        Assert.assertEquals((String)"This returns 'teststring'", (Object)"teststring", (Object)config.getString("string"));
        List item1 = config.getList("list");
        Assert.assertEquals((String)"This returns 'item 1'", (Object)"item 1", item1.get(0));
        Assert.assertEquals((String)"This returns 123", (long)123L, (long)config.getInt("int"));
    }

    private static BaseConfiguration createTestConfiguration() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        config.addProperty("array", (Object)"item 1");
        config.addProperty("array", (Object)"item 2");
        config.addProperty("interpolated", (Object)"${string}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        return config;
    }

    @Test
    public void testConfigurationToPropertiesDefaultListHandling() {
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertNotNull((String)"null properties", (Object)props);
        Assert.assertEquals((String)"'string' property", (Object)"teststring", (Object)props.getProperty("string"));
        Assert.assertEquals((String)"'interpolated' property", (Object)"teststring", (Object)props.getProperty("interpolated"));
        Assert.assertEquals((String)"'array' property", (Object)"item 1,item 2", (Object)props.getProperty("array"));
        Assert.assertEquals((String)"'interpolated-array' property", (Object)"teststring,teststring", (Object)props.getProperty("interpolated-array"));
    }

    @Test
    public void testConfigurationToPropertiesListDelimiterHandler() {
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertEquals((String)"'array' property", (Object)"item 1;item 2", (Object)props.getProperty("array"));
    }

    @Test
    public void testConfigurationToPropertiesNoAbstractConfiguration() {
        Configuration src = (Configuration)EasyMock.createMock(Configuration.class);
        BaseConfiguration config = TestConfigurationConverter.createTestConfiguration();
        EasyMock.expect((Object)src.getKeys()).andReturn((Object)config.getKeys());
        src.getList((String)EasyMock.anyObject(String.class));
        EasyMock.expectLastCall().andAnswer(() -> {
            String key = (String)EasyMock.getCurrentArguments()[0];
            return config.getList(key);
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{src});
        Properties props = ConfigurationConverter.getProperties((Configuration)src);
        Assert.assertEquals((String)"'array' property", (Object)"item 1,item 2", (Object)props.getProperty("array"));
    }

    @Test
    public void testConfigurationToPropertiesScalarValue() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("scalar", (Object)new Integer(42));
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertEquals((String)"Wrong value", (Object)"42", (Object)props.getProperty("scalar"));
    }

    @Test
    public void testConfigurationToMap() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        Map map = ConfigurationConverter.getMap((Configuration)config);
        Assert.assertNotNull((String)"null map", (Object)map);
        Assert.assertEquals((String)"'string' property", (Object)"teststring", map.get("string"));
    }
}

