/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBaseHierarchicalConfigurationSynchronization {
    private SynchronizerTestImpl sync;
    private File testFile;
    private BaseHierarchicalConfiguration config;

    @Before
    public void setUp() throws Exception {
        XMLConfiguration c = new XMLConfiguration();
        this.testFile = ConfigurationAssert.getTestFile("test.xml");
        new FileHandler((FileBased)c).load(this.testFile);
        this.sync = new SynchronizerTestImpl();
        c.setSynchronizer((Synchronizer)this.sync);
        this.config = c;
    }

    @Test
    public void testGetMaxIndexSynchronized() {
        Assert.assertTrue((String)"Wrong max index", (this.config.getMaxIndex("list.item") > 0 ? 1 : 0) != 0);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetRootElementNameSynchronized() {
        Assert.assertEquals((String)"Wrong root element name", (Object)"testconfig", (Object)this.config.getRootElementName());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testCloneSynchronized() {
        BaseHierarchicalConfiguration clone = (BaseHierarchicalConfiguration)this.config.clone();
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        Assert.assertNotSame((String)"Synchronizer was not cloned", (Object)this.config.getSynchronizer(), (Object)clone.getSynchronizer());
    }

    @Test
    public void testAddNodesSynchronized() {
        ImmutableNode node = NodeStructureHelper.createNode("newNode", "true");
        this.config.addNodes("test.addNodes", Collections.singleton(node));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testClearTreeSynchronized() {
        this.config.clearTree("clear");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testCopyConstructorSynchronized() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        Assert.assertNotSame((String)"Synchronizer was copied", (Object)this.sync, (Object)copy.getSynchronizer());
    }

    @Test
    public void testConfigurationAtSynchronized() {
        HierarchicalConfiguration sub = this.config.configurationAt("element2");
        Assert.assertEquals((String)"Wrong property", (Object)"I'm complex!", (Object)sub.getString("subelement.subsubelement"));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testConfigurationsAtSynchronized() {
        List subs = this.config.configurationsAt("list.item");
        Assert.assertFalse((String)"No subnode configurations", (boolean)subs.isEmpty());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testChildConfigurationsAtSynchronized() {
        List subs = this.config.childConfigurationsAt("clear");
        Assert.assertFalse((String)"No subnode configurations", (boolean)subs.isEmpty());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    private static boolean isDetached(HierarchicalConfiguration<ImmutableNode> c) {
        Assert.assertTrue((String)"Not a sub configuration", (boolean)(c instanceof SubnodeConfiguration));
        InMemoryNodeModel nodeModel = ((SubnodeConfiguration)c).getRootNodeModel();
        return nodeModel.isTrackedNodeDetached(((SubnodeConfiguration)c).getRootSelector());
    }

    @Test
    public void testSubnodeUpdate() {
        this.config.addProperty("element2.test", (Object)Boolean.TRUE);
        HierarchicalConfiguration sub = this.config.configurationAt("element2", true);
        HierarchicalConfiguration subsub = sub.configurationAt("subelement", true);
        this.config.clearTree("element2.subelement");
        Assert.assertFalse((String)"Sub1 detached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)sub));
        Assert.assertTrue((String)"Sub2 still attached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)subsub));
    }

    @Test
    public void testSubnodeUpdateBySubnode() {
        HierarchicalConfiguration sub = this.config.configurationAt("element2", true);
        HierarchicalConfiguration subsub = sub.configurationAt("subelement", true);
        HierarchicalConfiguration sub2 = this.config.configurationAt("element2.subelement", true);
        sub.clearTree("subelement");
        Assert.assertTrue((String)"Sub2 still attached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)sub2));
        Assert.assertTrue((String)"Subsub still attached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)subsub));
    }

    @Test
    public void testCloneCopySubnodeData() {
        BaseHierarchicalConfiguration conf2 = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        HierarchicalConfiguration sub = conf2.configurationAt("element2.subelement", true);
        HierarchicalConfiguration copy = (HierarchicalConfiguration)conf2.clone();
        HierarchicalConfiguration sub2 = copy.configurationAt("element2.subelement", true);
        copy.clearTree("element2");
        Assert.assertTrue((String)"Sub2 not detached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)sub2));
        Assert.assertFalse((String)"Sub 1 was detached", (boolean)TestBaseHierarchicalConfigurationSynchronization.isDetached((HierarchicalConfiguration<ImmutableNode>)sub));
    }

    @Test
    public void testSubsetSynchronized() {
        Configuration subset = this.config.subset("test");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
        Assert.assertSame((String)"Wrong Synchronizer", (Object)this.sync, (Object)subset.getSynchronizer());
    }

    @Test
    public void testReadOnlyAccessToSubConfigurations() throws ConfigurationException {
        SubNodeAccessThread t2;
        int i;
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class);
        builder.configure(new BuilderParameters[]{(BuilderParameters)new Parameters().fileBased().setFile(this.testFile)});
        this.config = (BaseHierarchicalConfiguration)builder.getConfiguration();
        CountDownLatch startLatch = new CountDownLatch(1);
        ArrayList<SubNodeAccessThread> threads = new ArrayList<SubNodeAccessThread>();
        for (i = 0; i < 4; ++i) {
            t2 = new SubNodeAccessThread((HierarchicalConfiguration<ImmutableNode>)this.config, startLatch, "element2", "subelement.subsubelement");
            t2.start();
            threads.add(t2);
        }
        for (i = 0; i < 4; ++i) {
            t2 = new SubNodeAccessThread((HierarchicalConfiguration<ImmutableNode>)this.config, startLatch, "element2.subelement", "subsubelement");
            t2.start();
            threads.add(t2);
        }
        startLatch.countDown();
        for (SubNodeAccessThread t2 : threads) {
            t2.verify();
        }
    }

    private static class SubNodeAccessThread
    extends Thread {
        private final HierarchicalConfiguration<ImmutableNode> config;
        private final CountDownLatch latch;
        private final String keySub;
        private final String keyProp;
        private String value;

        public SubNodeAccessThread(HierarchicalConfiguration<ImmutableNode> c, CountDownLatch startLatch, String keySubConfig, String keyProperty) {
            this.config = c;
            this.latch = startLatch;
            this.keySub = keySubConfig;
            this.keyProp = keyProperty;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                HierarchicalConfiguration subConfig = this.config.configurationAt(this.keySub, true);
                this.value = subConfig.getString(this.keyProp);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void verify() {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)("Waiting was interrupted: " + e));
            }
            Assert.assertEquals((String)"Wrong value", (Object)"I'm complex!", (Object)this.value);
        }
    }
}

