/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Collections;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.configuration2.sync.NoOpSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAbstractConfigurationSynchronization {
    private static final String PROP = "configuration.loaded";
    private SynchronizerTestImpl sync;
    private AbstractConfiguration config;

    @Before
    public void setUp() throws Exception {
        PropertiesConfiguration c = new PropertiesConfiguration();
        new FileHandler((FileBased)c).load(ConfigurationAssert.getTestFile("test.properties"));
        this.sync = new SynchronizerTestImpl();
        c.setSynchronizer((Synchronizer)this.sync);
        this.config = c;
    }

    @Test
    public void testDefaultSynchronizer() {
        Assert.assertSame((String)"Wrong default synchronizer", (Object)NoOpSynchronizer.INSTANCE, (Object)new PropertiesConfiguration().getSynchronizer());
    }

    @Test
    public void testLockRead() {
        this.config.lock(LockMode.READ);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ);
    }

    @Test
    public void testLockWrite() {
        this.config.lock(LockMode.WRITE);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE);
    }

    @Test(expected=NullPointerException.class)
    public void testLockNull() {
        this.config.lock(null);
    }

    @Test
    public void testUnlockRead() {
        this.config.unlock(LockMode.READ);
        this.sync.verify(SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testUnlockWrite() {
        this.config.unlock(LockMode.WRITE);
        this.sync.verify(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testAddPropertySynchronized() {
        this.config.addProperty(PROP, (Object)"of course");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testSetPropertySynchronized() {
        this.config.setProperty(PROP, (Object)"yes");
        this.sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        this.sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testClearPropertySynchronized() {
        this.config.clearProperty(PROP);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_WRITE, SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testClearSynchronized() {
        this.config.clear();
        this.sync.verifyStart(SynchronizerTestImpl.Methods.BEGIN_WRITE);
        this.sync.verifyEnd(SynchronizerTestImpl.Methods.END_WRITE);
    }

    @Test
    public void testGetPropertySynchronized() {
        Assert.assertEquals((String)"Wrong raw value", (Object)"true", (Object)this.config.getProperty(PROP));
        Assert.assertTrue((String)"Wrong boolean value", (boolean)this.config.getBoolean(PROP));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ, SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testContainsKeySychronized() {
        Assert.assertTrue((String)"Wrong result", (boolean)this.config.containsKey(PROP));
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testIsEmptySynchronized() {
        Assert.assertFalse((String)"Configuration is empty", (boolean)this.config.isEmpty());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testSizeSynchronized() {
        Assert.assertTrue((String)"Wrong size", (this.config.size() > 0 ? 1 : 0) != 0);
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetKeysSynchronized() {
        Assert.assertTrue((String)"No keys", (boolean)this.config.getKeys().hasNext());
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetKeysPrefixSynchronized() {
        this.config.getKeys("test");
        this.sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testSubsetSynchronized() {
        AbstractConfiguration subset = (AbstractConfiguration)this.config.subset("configuration");
        this.sync.verify(new SynchronizerTestImpl.Methods[0]);
        Assert.assertEquals((String)"Wrong synchronizer for subset", (Object)NoOpSynchronizer.INSTANCE, (Object)subset.getSynchronizer());
    }

    private static Configuration prepareConfigurationMockForCopy() {
        Configuration config2 = (Configuration)EasyMock.createStrictMock(Configuration.class);
        config2.lock(LockMode.READ);
        EasyMock.expect((Object)config2.getKeys()).andReturn(Collections.emptySet().iterator());
        config2.unlock(LockMode.READ);
        EasyMock.replay((Object[])new Object[]{config2});
        return config2;
    }

    @Test
    public void testAppendSynchronized() {
        Configuration config2 = TestAbstractConfigurationSynchronization.prepareConfigurationMockForCopy();
        this.config.append(config2);
        EasyMock.verify((Object[])new Object[]{config2});
    }

    @Test
    public void testCopySynchronized() {
        Configuration config2 = TestAbstractConfigurationSynchronization.prepareConfigurationMockForCopy();
        this.config.copy(config2);
        EasyMock.verify((Object[])new Object[]{config2});
    }
}

