/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.xpath.AbstractXPathTest;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration2.tree.xpath.XPathContextFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestConfigurationNodePointerFactory
extends AbstractXPathTest {
    private JXPathContext context;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context = new XPathContextFactory().createContext((Object)this.root, this.handler);
    }

    @Test
    public void testSimpleXPath() {
        List results = this.context.selectNodes("subNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)2L, (long)results.size());
        for (Object result : results) {
            ImmutableNode node = (ImmutableNode)result;
            Assert.assertEquals((String)"Incorrect node name", (Object)"subNode", (Object)node.getNodeName());
        }
        results = this.context.selectNodes("/subNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)2L, (long)results.size());
        results = this.context.selectNodes("childNode/subNode/childNode");
        Assert.assertEquals((String)"Incorrect number of results", (long)18L, (long)results.size());
    }

    @Test
    public void testIndices() {
        Assert.assertEquals((String)"Incorrect value", (Object)"1.2.3", (Object)this.context.getValue("/childNode[1]/subNode[1]/childNode[2]"));
        Assert.assertEquals((String)"Incorrect value of last node", (Object)String.valueOf(5), (Object)this.context.getValue("childNode[last()]"));
        List nodes = this.context.selectNodes("/subNode[1]/*");
        Assert.assertEquals((String)"Wrong number of children", (long)5L, (long)nodes.size());
        int index = 1;
        for (ImmutableNode node : nodes) {
            Assert.assertEquals((String)("Wrong node value for child " + index), (Object)("2." + index), (Object)node.getValue());
            ++index;
        }
    }

    @Test
    public void testQueryAttribute() {
        Assert.assertEquals((String)"Incorrect attribute value", (Object)"1", (Object)this.context.getValue("/childNode[1]/@counter"));
    }

    @Test
    public void testQueryRootAttribute() {
        Assert.assertEquals((String)"Did not find attribute of root node", (Object)"true", (Object)this.context.getValue("@rootAttr"));
    }

    @Test
    public void testText() {
        List nodes = this.context.selectNodes("//childNode[text()='1.1.1']");
        Assert.assertEquals((String)"Incorrect number of result nodes", (long)1L, (long)nodes.size());
    }

    @Test
    public void testParentAxis() {
        List nodes = this.context.selectNodes("/childNode/parent::*");
        Assert.assertEquals((String)"Wrong number of parent nodes", (long)1L, (long)nodes.size());
    }

    @Test
    public void testFollowingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/following-sibling::*");
        Assert.assertEquals((String)"Wrong number of following siblings", (long)1L, (long)nodes.size());
        ImmutableNode node = (ImmutableNode)nodes.get(0);
        Assert.assertEquals((String)"Wrong node type", (Object)"childNode", (Object)node.getNodeName());
        Assert.assertEquals((String)"Wrong index", (Object)String.valueOf(5), (Object)node.getValue());
    }

    @Test
    public void testPrecedingSiblingAxis() {
        List nodes = this.context.selectNodes("/subNode[2]/preceding-sibling::*");
        Assert.assertEquals((String)"Wrong number of preceding siblings", (long)3L, (long)nodes.size());
        int index = 0;
        int value = 3;
        while (index < nodes.size()) {
            Assert.assertEquals((String)"Wrong node index", (Object)String.valueOf(value), (Object)((ImmutableNode)nodes.get(index)).getValue());
            ++index;
            --value;
        }
    }
}

