/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractXPathTest {
    protected static final String ATTR_NAME = "counter";
    protected static final String ATTR_ROOT = "rootAttr";
    protected static final String CHILD_NAME1 = "subNode";
    protected static final String CHILD_NAME2 = "childNode";
    protected static final int CHILD_COUNT = 5;
    protected static final int LEVEL_COUNT = 3;
    protected ImmutableNode root;
    protected NodeHandler<ImmutableNode> handler;

    @Before
    public void setUp() throws Exception {
        this.root = this.constructHierarchy(3);
        this.handler = new InMemoryNodeModel(this.root).getNodeHandler();
    }

    @After
    public void tearDown() throws Exception {
        this.root = null;
    }

    protected ImmutableNode constructHierarchy(int levels) {
        ImmutableNode.Builder resultBuilder = new ImmutableNode.Builder();
        this.createLevel(resultBuilder, null, levels);
        resultBuilder.addAttribute(ATTR_ROOT, (Object)String.valueOf(true));
        return resultBuilder.create();
    }

    protected int iteratorSize(NodeIterator iterator) {
        boolean ok;
        int cnt = 0;
        do {
            if (!(ok = iterator.setPosition(cnt + 1))) continue;
            ++cnt;
        } while (ok);
        return cnt;
    }

    protected List<NodePointer> iterationElements(NodeIterator iterator) {
        ArrayList<NodePointer> result = new ArrayList<NodePointer>();
        int pos = 1;
        while (iterator.setPosition(pos)) {
            result.add(iterator.getNodePointer());
            ++pos;
        }
        return result;
    }

    private void createLevel(ImmutableNode.Builder parentBuilder, String value, int level) {
        if (level >= 0) {
            String prefix = value == null ? "" : value + ".";
            for (int i = 1; i <= 5; ++i) {
                ImmutableNode.Builder childBuilder = new ImmutableNode.Builder();
                childBuilder.name(i % 2 == 0 ? CHILD_NAME1 : CHILD_NAME2);
                String currentValue = prefix + i;
                childBuilder.value((Object)currentValue);
                this.createLevel(childBuilder, currentValue, level - 1);
                childBuilder.addAttribute(ATTR_NAME, (Object)String.valueOf(i));
                parentBuilder.addChild(childBuilder.create());
            }
        }
    }
}

