/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.AbstractCombinerTest;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.configuration2.tree.QueryResult;
import org.junit.Assert;
import org.junit.Test;

public class TestOverrideCombiner
extends AbstractCombinerTest {
    @Override
    protected NodeCombiner createCombiner() {
        return new OverrideCombiner();
    }

    @Test
    public void testSimpleValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of bgcolors", (long)0L, (long)config.getMaxIndex("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong bgcolor", (Object)"green", (Object)config.getString("gui.bgcolor"));
        Assert.assertEquals((String)"Wrong selcolor", (Object)"yellow", (Object)config.getString("gui.selcolor"));
        Assert.assertEquals((String)"Wrong fgcolor", (Object)"blue", (Object)config.getString("gui.fgcolor"));
        Assert.assertEquals((String)"Wrong level", (long)1L, (long)config.getInt("gui.level"));
    }

    @Test
    public void testAttributes() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong value of min attribute", (long)1L, (long)config.getInt("gui.level[@min]"));
        Assert.assertEquals((String)"Wrong value of default attribute", (long)2L, (long)config.getInt("gui.level[@default]"));
        Assert.assertEquals((String)"Wrong number of id attributes", (long)0L, (long)config.getMaxIndex("database.tables.table(0)[@id]"));
        Assert.assertEquals((String)"Wrong value of table id", (long)1L, (long)config.getInt("database.tables.table(0)[@id]"));
    }

    @Test
    public void testOverrideValues() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong user", (Object)"Admin", (Object)config.getString("base.services.security.login.user"));
        Assert.assertEquals((String)"Wrong user type", (Object)"default", (Object)config.getString("base.services.security.login.user[@type]"));
        Assert.assertEquals((String)"Wrong password", (Object)"BeamMeUp", (Object)config.getString("base.services.security.login.passwd"));
        Assert.assertEquals((String)"Wrong password type", (Object)"secret", (Object)config.getString("base.services.security.login.passwd[@type]"));
    }

    @Test
    public void testListFromFirstStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of services", (long)0L, (long)config.getMaxIndex("net.service.url"));
        Assert.assertEquals((String)"Wrong service", (Object)"http://service1.org", (Object)config.getString("net.service.url"));
        Assert.assertFalse((String)"Type attribute available", (boolean)config.containsKey("net.service.url[@type]"));
    }

    @Test
    public void testListFromSecondStructure() throws ConfigurationException {
        BaseHierarchicalConfiguration config = this.createCombinedConfiguration();
        Assert.assertEquals((String)"Wrong number of servers", (long)3L, (long)config.getMaxIndex("net.server.url"));
        Assert.assertEquals((String)"Wrong server", (Object)"http://testsvr.com", (Object)config.getString("net.server.url(2)"));
    }

    @Test
    public void testCombinedTableNoList() throws ConfigurationException {
        this.checkTable(this.createCombinedConfiguration());
    }

    @Test
    public void testCombinedTableList() throws ConfigurationException {
        this.combiner.addListNode("table");
        this.checkTable(this.createCombinedConfiguration());
    }

    private ImmutableNode checkTable(BaseHierarchicalConfiguration config) {
        Assert.assertEquals((String)"Wrong number of tables", (long)0L, (long)config.getMaxIndex("database.tables.table"));
        HierarchicalConfiguration c = config.configurationAt("database.tables.table");
        Assert.assertEquals((String)"Wrong table name", (Object)"documents", (Object)c.getString("name"));
        Assert.assertEquals((String)"Wrong number of fields", (long)2L, (long)c.getMaxIndex("fields.field.name"));
        Assert.assertEquals((String)"Wrong field", (Object)"docname", (Object)c.getString("fields.field(1).name"));
        NodeHandler nodeHandler = config.getNodeModel().getNodeHandler();
        List nds = config.getExpressionEngine().query(nodeHandler.getRootNode(), "database.tables.table", nodeHandler);
        Assert.assertFalse((String)"No node found", (boolean)nds.isEmpty());
        Assert.assertFalse((String)"An attribute result", (boolean)((QueryResult)nds.get(0)).isAttributeResult());
        return (ImmutableNode)((QueryResult)nds.get(0)).getNode();
    }

    @Test
    public void testCombineProperties() {
        PropertiesConfiguration c1 = new PropertiesConfiguration();
        c1.addProperty("x.y.simpleCase", (Object)false);
        c1.addProperty("x.y.between", (Object)false);
        c1.addProperty("x.y.isDistinctFrom", (Object)false);
        c1.addProperty("x.y", (Object)false);
        PropertiesConfiguration c2 = new PropertiesConfiguration();
        c2.addProperty("x.y", (Object)true);
        c2.addProperty("x.y.between", (Object)true);
        c2.addProperty("x.y.comparison", (Object)true);
        c2.addProperty("x.y.in", (Object)true);
        c2.addProperty("x.y.isDistinctFrom", (Object)true);
        c2.addProperty("x.y.simpleCase", (Object)true);
        CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new OverrideCombiner());
        config.addConfiguration((Configuration)c1);
        config.addConfiguration((Configuration)c2);
        Assert.assertFalse((String)"Wrong value for x.y", (boolean)config.getBoolean("x.y"));
        Assert.assertFalse((String)"Wrong value for x.y.between", (boolean)config.getBoolean("x.y.between"));
        Assert.assertFalse((String)"Wrong value for x.y.isDistinctFrom", (boolean)config.getBoolean("x.y.isDistinctFrom"));
        Assert.assertFalse((String)"Wrong value for x.y.simpleCase", (boolean)config.getBoolean("x.y.simpleCase"));
        Assert.assertTrue((String)"Wrong value for x.y.in", (boolean)config.getBoolean("x.y.in"));
        Assert.assertTrue((String)"Wrong value for x.y.comparison", (boolean)config.getBoolean("x.y.comparison"));
        Assert.assertEquals((String)"Wrong size", (long)6L, (long)config.size());
    }
}

