/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.AbsoluteNameLocationStrategy;
import org.apache.commons.configuration2.io.BasePathLocationStrategy;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.configuration2.io.FileSystemLocationStrategy;
import org.apache.commons.configuration2.io.HomeDirectoryLocationStrategy;
import org.apache.commons.configuration2.io.ProvidedURLLocationStrategy;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFileLocatorUtils {
    private static final String FILE_NAME = "test.xml";
    private static final String BASE_PATH = "/etc/test/path/";
    private static final String ENCODING = "utf-8";
    private static URL sourceURL;
    private static FileSystem fileSystem;

    @BeforeClass
    public static void setUpOnce() throws Exception {
        sourceURL = ConfigurationAssert.getTestURL(FILE_NAME);
        fileSystem = (FileSystem)EasyMock.createMock(FileSystem.class);
        EasyMock.replay((Object[])new Object[]{fileSystem});
    }

    @Test
    public void testFileFromURLWithEncodedPercent() throws MalformedURLException {
        File file = new File("https%3A%2F%2Fwww.apache.org%2F.url").getAbsoluteFile();
        URL fileURL = file.toURI().toURL();
        File file2 = FileLocatorUtils.fileFromURL((URL)fileURL);
        Assert.assertEquals((String)"Wrong file", (Object)file, (Object)file2);
    }

    @Test
    public void testFileFromURLWithPlus() throws MalformedURLException {
        File file = new File(new File("target"), "foo+bar.txt").getAbsoluteFile();
        URL fileURL = file.toURI().toURL();
        File file2 = FileLocatorUtils.fileFromURL((URL)fileURL);
        Assert.assertEquals((String)"Wrong file", (Object)file, (Object)file2);
    }

    @Test
    public void testFileFromURLNull() throws Exception {
        Assert.assertNull((String)"Wrong file for null URL", (Object)FileLocatorUtils.fileFromURL(null));
    }

    @Test
    public void testGetBasePath() throws Exception {
        URL url = new URL("http://xyz.net/foo/bar.xml");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/foo/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo/");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/foo/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/foo");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net/");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net/", (Object)FileLocatorUtils.getBasePath((URL)url));
        url = new URL("http://xyz.net");
        Assert.assertEquals((String)("base path of " + url), (Object)"http://xyz.net", (Object)FileLocatorUtils.getBasePath((URL)url));
    }

    @Test
    public void testGetFileName() throws Exception {
        Assert.assertEquals((String)"file name for a null URL", null, (Object)FileLocatorUtils.getFileName(null));
        URL url = new URL("http://xyz.net/foo/");
        Assert.assertEquals((String)("file for a directory URL " + url), null, (Object)FileLocatorUtils.getFileName((URL)url));
        url = new URL("http://xyz.net/foo/bar.xml");
        Assert.assertEquals((String)("file name for a valid URL " + url), (Object)"bar.xml", (Object)FileLocatorUtils.getFileName((URL)url));
    }

    @Test
    public void testGetFile() throws Exception {
        File directory = new File("target");
        File reference = new File(directory, "test.txt").getAbsoluteFile();
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile(null, (String)reference.getAbsolutePath()));
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getAbsolutePath()));
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile((String)directory.getAbsolutePath(), (String)reference.getName()));
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile((String)directory.toURI().toURL().toString(), (String)reference.getName()));
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile((String)"invalid", (String)reference.toURI().toURL().toString()));
        Assert.assertEquals((Object)reference, (Object)FileLocatorUtils.getFile((String)"jar:file:/C:/myjar.jar!/my-config.xml/someprops.properties", (String)reference.getAbsolutePath()));
    }

    @Test
    public void testLocateWithNullTCCL() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Assert.assertNull((Object)FileLocatorUtils.locate((FileLocator)FileLocatorUtils.fileLocator().basePath("abase").fileName("aname").create()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Test
    public void testObtainFileSystemNullLocator() {
        Assert.assertSame((String)"Wrong file system", (Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)FileLocatorUtils.obtainFileSystem(null));
    }

    @Test
    public void testObtainFileSystemNotSetInLocator() {
        Assert.assertSame((String)"Wrong file system", (Object)FileLocatorUtils.DEFAULT_FILE_SYSTEM, (Object)FileLocatorUtils.obtainFileSystem((FileLocator)FileLocatorUtils.fileLocator().create()));
    }

    @Test
    public void testObtainFileSystemSetInLocator() {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        FileLocator locator = FileLocatorUtils.fileLocator().fileSystem(fs).create();
        Assert.assertSame((String)"Wrong file system", (Object)fs, (Object)FileLocatorUtils.obtainFileSystem((FileLocator)locator));
    }

    @Test
    public void testIsLocationDefinedNull() {
        Assert.assertFalse((String)"Wrong result", (boolean)FileLocatorUtils.isLocationDefined(null));
    }

    @Test
    public void testIsLocationDefinedFalse() {
        FileLocator locator = FileLocatorUtils.fileLocator().encoding(ENCODING).basePath(BASE_PATH).fileSystem(FileLocatorUtils.DEFAULT_FILE_SYSTEM).create();
        Assert.assertFalse((String)"Wrong result", (boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testIsLocationDefinedFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assert.assertTrue((String)"Wrong result", (boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testIsLocationDefinedURL() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(ConfigurationAssert.getTestURL(FILE_NAME)).create();
        Assert.assertTrue((String)"Wrong result", (boolean)FileLocatorUtils.isLocationDefined((FileLocator)locator));
    }

    @Test
    public void testFullyInitializedLocatorUndefined() {
        Assert.assertNull((String)"Got a result", (Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)FileLocatorUtils.fileLocator().create()));
    }

    private static void checkTestConfiguration(FileHandler handler) throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        FileHandler h2 = new FileHandler((FileBased)config, handler);
        h2.load();
        Assert.assertEquals((String)"Wrong content", (Object)"value", (Object)config.getString("element"));
    }

    private static void checkFullyInitializedLocator(FileLocator locator) throws ConfigurationException {
        Assert.assertNotNull((String)"No base path", (Object)locator.getBasePath());
        Assert.assertNotNull((String)"No file name", (Object)locator.getFileName());
        Assert.assertNotNull((String)"No source URL", (Object)locator.getSourceURL());
        FileHandler handler = new FileHandler();
        handler.setBasePath(locator.getBasePath());
        handler.setFileName(locator.getFileName());
        TestFileLocatorUtils.checkTestConfiguration(handler);
        handler = new FileHandler();
        handler.setURL(locator.getSourceURL());
        TestFileLocatorUtils.checkTestConfiguration(handler);
    }

    @Test
    public void testFullyInitializedLocatorFileName() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        TestFileLocatorUtils.checkFullyInitializedLocator(FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testFullyInitializedLocatorURL() throws ConfigurationException {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(sourceURL).create();
        TestFileLocatorUtils.checkFullyInitializedLocator(FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testFullyInitializedLocatorAlreadyComplete() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        FileLocator fullLocator = FileLocatorUtils.fullyInitializedLocator((FileLocator)locator);
        Assert.assertSame((String)"Different instance", (Object)fullLocator, (Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)fullLocator));
    }

    @Test
    public void testFullyInitializedLocatorLocateFails() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("non existing file").create();
        Assert.assertNull((String)"Wrong result", (Object)FileLocatorUtils.fullyInitializedLocator((FileLocator)locator));
    }

    @Test
    public void testIsFullyInitializedNull() {
        Assert.assertFalse((String)"Wrong result", (boolean)FileLocatorUtils.isFullyInitialized(null));
    }

    @Test
    public void testIsFullyInitializedNoBasePath() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(ConfigurationAssert.getTestURL(FILE_NAME)).fileName(FILE_NAME).create();
        Assert.assertFalse((String)"Wrong result", (boolean)FileLocatorUtils.isFullyInitialized((FileLocator)locator));
    }

    @Test
    public void testConvertToURIException() throws URISyntaxException {
        URI uri = new URI("test://test/path/file.tst");
        Assert.assertNull((String)"Got a URL", (Object)FileLocatorUtils.convertURIToURL((URI)uri));
    }

    @Test
    public void testConvertFileToURL() throws ConfigurationException {
        File file = ConfigurationAssert.getTestFile(FILE_NAME);
        FileHandler handler = new FileHandler();
        handler.setURL(FileLocatorUtils.convertFileToURL((File)file));
        TestFileLocatorUtils.checkTestConfiguration(handler);
    }

    @Test
    public void testDefaultFileLocationStrategy() {
        CombinedLocationStrategy strategy = (CombinedLocationStrategy)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY;
        Iterator it = strategy.getSubStrategies().iterator();
        Assert.assertTrue((String)"Wrong strategy (1)", (boolean)(it.next() instanceof ProvidedURLLocationStrategy));
        Assert.assertTrue((String)"Wrong strategy (2)", (boolean)(it.next() instanceof FileSystemLocationStrategy));
        Assert.assertTrue((String)"Wrong strategy (3)", (boolean)(it.next() instanceof AbsoluteNameLocationStrategy));
        Assert.assertTrue((String)"Wrong strategy (4)", (boolean)(it.next() instanceof BasePathLocationStrategy));
        FileLocationStrategy sub = (FileLocationStrategy)it.next();
        Assert.assertTrue((String)"Wrong strategy (5)", (boolean)(sub instanceof HomeDirectoryLocationStrategy));
        Assert.assertTrue((String)"Base path ignored", (boolean)((HomeDirectoryLocationStrategy)sub).isEvaluateBasePath());
        sub = (FileLocationStrategy)it.next();
        Assert.assertTrue((String)"Wrong strategy (6)", (boolean)(sub instanceof HomeDirectoryLocationStrategy));
        Assert.assertFalse((String)"Base path not ignored", (boolean)((HomeDirectoryLocationStrategy)sub).isEvaluateBasePath());
        Assert.assertTrue((String)"Wrong strategy (7)", (boolean)(it.next() instanceof ClasspathLocationStrategy));
    }

    @Test
    public void testObtainLocationStrategySetInLocator() {
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.replay((Object[])new Object[]{strategy});
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        Assert.assertSame((String)"Wrong strategy", (Object)strategy, (Object)FileLocatorUtils.obtainLocationStrategy((FileLocator)locator));
    }

    @Test
    public void testObtainLocationStrategyNotSetInLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assert.assertSame((String)"Wrong strategy", (Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)FileLocatorUtils.obtainLocationStrategy((FileLocator)locator));
    }

    @Test
    public void testObtainLocationStrategyNullLocator() {
        Assert.assertSame((String)"Wrong strategy", (Object)FileLocatorUtils.DEFAULT_LOCATION_STRATEGY, (Object)FileLocatorUtils.obtainLocationStrategy(null));
    }

    @Test
    public void testLocateNullLocator() {
        Assert.assertNull((String)"Wrong result", (Object)FileLocatorUtils.locate(null));
    }

    @Test
    public void testLocateSuccessWithStrategyAndFileSystem() throws ConfigurationException {
        FileSystem fs = (FileSystem)EasyMock.createMock(FileSystem.class);
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().fileSystem(fs).locationStrategy(strategy).create();
        EasyMock.expect((Object)strategy.locate(fs, locator)).andReturn((Object)sourceURL);
        EasyMock.replay((Object[])new Object[]{fs, strategy});
        Assert.assertSame((String)"Wrong URL", (Object)sourceURL, (Object)FileLocatorUtils.locateOrThrow((FileLocator)locator));
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test
    public void testLocateSuccessWithStrategyDefaultFileSystem() throws ConfigurationException {
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        EasyMock.expect((Object)strategy.locate(FileLocatorUtils.DEFAULT_FILE_SYSTEM, locator)).andReturn((Object)sourceURL);
        EasyMock.replay((Object[])new Object[]{strategy});
        Assert.assertSame((String)"Wrong URL", (Object)sourceURL, (Object)FileLocatorUtils.locateOrThrow((FileLocator)locator));
        EasyMock.verify((Object[])new Object[]{strategy});
    }

    @Test
    public void testLocateSuccessWithDefaults() {
        FileLocator locator = FileLocatorUtils.fileLocator().sourceURL(sourceURL).create();
        Assert.assertSame((String)"Wrong URL", (Object)sourceURL, (Object)FileLocatorUtils.locate((FileLocator)locator));
    }

    @Test(expected=ConfigurationException.class)
    public void testLocateOrThrowFailed() throws ConfigurationException {
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.expect((Object)strategy.locate((FileSystem)EasyMock.anyObject(FileSystem.class), (FileLocator)EasyMock.anyObject(FileLocator.class))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{strategy});
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy(strategy).create();
        FileLocatorUtils.locateOrThrow((FileLocator)locator);
    }

    @Test
    public void testStoreFileLocatorInMap() {
        FileLocationStrategy strategy = (FileLocationStrategy)EasyMock.createMock(FileLocationStrategy.class);
        EasyMock.replay((Object[])new Object[]{strategy});
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).encoding(ENCODING).fileName(FILE_NAME).fileSystem(fileSystem).locationStrategy(strategy).sourceURL(sourceURL).create();
        HashMap map = new HashMap();
        FileLocatorUtils.put((FileLocator)locator, map);
        FileLocator locator2 = FileLocatorUtils.fromMap(map);
        Assert.assertEquals((String)"Different locators", (Object)locator, (Object)locator2);
    }

    @Test
    public void testPutNoLocator() {
        HashMap map = new HashMap();
        FileLocatorUtils.put(null, map);
        Assert.assertTrue((String)"Got properties", (boolean)map.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPutNoMap() {
        FileLocatorUtils.put((FileLocator)FileLocatorUtils.fileLocator().create(), null);
    }

    @Test
    public void testFromMapNoMap() {
        FileLocator fileLocator = FileLocatorUtils.fromMap(null);
        Assert.assertEquals((String)"Locator is initialized", (Object)FileLocatorUtils.fileLocator().create(), (Object)fileLocator);
    }
}

