/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.ConfigurationConsumer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.PropertiesConfigurationLayout;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.PropertiesBuilderParametersImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPropertiesBuilderParametersImpl {
    private PropertiesBuilderParametersImpl params;

    @Before
    public void setUp() throws Exception {
        this.params = new PropertiesBuilderParametersImpl();
    }

    @Test
    public void testSetIncludesAllowed() {
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setIncludesAllowed(true));
        Assert.assertEquals((String)"Value not set", (Object)Boolean.TRUE, this.params.getParameters().get("includesAllowed"));
    }

    @Test
    public void testSetLayout() {
        PropertiesConfigurationLayout layout = new PropertiesConfigurationLayout();
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setLayout(layout));
        Assert.assertSame((String)"Layout not set", (Object)layout, this.params.getParameters().get("layout"));
    }

    @Test
    public void testSetIncludeListener() {
        ConfigurationConsumer includeListener = (ConfigurationConsumer)EasyMock.createMock(ConfigurationConsumer.class);
        EasyMock.replay((Object[])new Object[]{includeListener});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setIncludeListener(includeListener));
        Assert.assertSame((String)"IncludeListener not set", (Object)includeListener, this.params.getParameters().get("includeListener"));
    }

    @Test
    public void testSetIOFactory() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)EasyMock.createMock(PropertiesConfiguration.IOFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        Assert.assertSame((String)"Wrong result", (Object)this.params, (Object)this.params.setIOFactory(factory));
        Assert.assertSame((String)"Factory not set", (Object)factory, this.params.getParameters().get("IOFactory"));
    }

    @Test
    public void testBeanPropertiesAccess() throws Exception {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)EasyMock.createMock(PropertiesConfiguration.IOFactory.class);
        EasyMock.replay((Object[])new Object[]{factory});
        BeanHelper.setProperty((Object)this.params, (String)"IOFactory", (Object)factory);
        BeanHelper.setProperty((Object)this.params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)this.params, (String)"fileName", (Object)"test.properties");
        Assert.assertEquals((String)"Wrong file name", (Object)"test.properties", (Object)this.params.getFileHandler().getFileName());
        Map paramsMap = this.params.getParameters();
        Assert.assertEquals((String)"Wrong exception flag", (Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
        Assert.assertSame((String)"Factory not set", (Object)factory, this.params.getParameters().get("IOFactory"));
    }

    @Test
    public void testInheritFrom() {
        PropertiesConfiguration.IOFactory factory = (PropertiesConfiguration.IOFactory)EasyMock.createMock(PropertiesConfiguration.IOFactory.class);
        ConfigurationConsumer includeListener = (ConfigurationConsumer)EasyMock.createMock(ConfigurationConsumer.class);
        this.params.setIOFactory(factory).setIncludeListener(includeListener).setIncludesAllowed(false).setLayout(new PropertiesConfigurationLayout()).setThrowExceptionOnMissing(true);
        PropertiesBuilderParametersImpl params2 = new PropertiesBuilderParametersImpl();
        params2.inheritFrom(this.params.getParameters());
        Map parameters = params2.getParameters();
        Assert.assertEquals((String)"Exception flag not set", (Object)Boolean.TRUE, parameters.get("throwExceptionOnMissing"));
        Assert.assertEquals((String)"IncludeListener not set", (Object)includeListener, parameters.get("includeListener"));
        Assert.assertEquals((String)"IOFactory not set", (Object)factory, parameters.get("IOFactory"));
        Assert.assertEquals((String)"Include flag not set", (Object)Boolean.FALSE, parameters.get("includesAllowed"));
        Assert.assertNull((String)"Layout was copied", parameters.get("layout"));
    }

    @Test
    public void testSetIOFactoryProperty() throws ConfigurationException {
        PropertiesConfiguration.DefaultIOFactory factory = new PropertiesConfiguration.DefaultIOFactory();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{this.params.setIOFactory((PropertiesConfiguration.IOFactory)factory)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Wrong IO factory", (Object)factory, (Object)config.getIOFactory());
    }

    @Test
    public void testSetIncludeListenerProperty() throws ConfigurationException {
        ConfigurationConsumer includeListener = PropertiesConfiguration.DEFAULT_INCLUDE_LISTENER;
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{this.params.setIncludeListener(includeListener)});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        Assert.assertEquals((String)"Wrong IncludeListener", (Object)includeListener, (Object)config.getIncludeListener());
    }
}

