/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.builder.DefaultReloadingDetectorFactory;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.reloading.FileHandlerReloadingDetector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultReloadingDetectorFactory {
    private DefaultReloadingDetectorFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new DefaultReloadingDetectorFactory();
    }

    @Test
    public void testCreateReloadingDetector() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Long refreshDelay = 10000L;
        params.setReloadingRefreshDelay(refreshDelay);
        FileHandlerReloadingDetector detector = (FileHandlerReloadingDetector)this.factory.createReloadingDetector(handler, params);
        Assert.assertSame((String)"Wrong file handler", (Object)handler, (Object)detector.getFileHandler());
        Assert.assertEquals((String)"Wrong refresh delay", (long)refreshDelay, (long)detector.getRefreshDelay());
    }

    @Test
    public void testCreateReloadingDetectorDefaultRefreshDelay() throws ConfigurationException {
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        FileHandlerReloadingDetector detector = (FileHandlerReloadingDetector)this.factory.createReloadingDetector(handler, params);
        Assert.assertTrue((String)"No default refresh delay", (detector.getRefreshDelay() != 0L ? 1 : 0) != 0);
    }
}

