/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationComparator;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestStrictConfigurationComparator {
    protected ConfigurationComparator comparator = new StrictConfigurationComparator();
    protected Configuration configuration = new BaseConfiguration();

    @Test
    public void testCompare() {
        Assert.assertTrue((String)"Compare an empty configuration with itself", (boolean)this.comparator.compare(this.configuration, this.configuration));
        this.configuration.setProperty("one", (Object)"1");
        this.configuration.setProperty("two", (Object)"2");
        this.configuration.setProperty("three", (Object)"3");
        Assert.assertTrue((String)"Compare a configuration with itself", (boolean)this.comparator.compare(this.configuration, this.configuration));
        BaseConfiguration other = new BaseConfiguration();
        Assert.assertFalse((String)"Compare a configuration with an empty one", (boolean)this.comparator.compare(this.configuration, (Configuration)other));
        other.setProperty("one", (Object)"1");
        other.setProperty("two", (Object)"2");
        other.setProperty("three", (Object)"3");
        Assert.assertTrue((String)"Compare a configuration with an identical one", (boolean)this.comparator.compare(this.configuration, (Configuration)other));
        other.setProperty("four", (Object)"4");
        Assert.assertFalse((String)"Compare our configuration with another that has an additional key mapping", (boolean)this.comparator.compare(this.configuration, (Configuration)other));
        this.configuration.setProperty("four", (Object)"4");
        Assert.assertTrue((String)"Compare our configuration with another that is identical", (boolean)this.comparator.compare(this.configuration, (Configuration)other));
    }

    @Test
    public void testCompareNull() {
        Assert.assertTrue((boolean)this.comparator.compare(null, null));
        Assert.assertFalse((boolean)this.comparator.compare(this.configuration, null));
        Assert.assertFalse((boolean)this.comparator.compare(null, this.configuration));
    }
}

