/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNullCompositeConfiguration {
    protected PropertiesConfiguration conf1;
    protected PropertiesConfiguration conf2;
    protected XMLConfiguration xmlConf;
    protected CompositeConfiguration cc;
    private final String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("test2.properties").getAbsolutePath();
    private final String testPropertiesXML = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();

    @Before
    public void setUp() throws Exception {
        this.cc = new CompositeConfiguration();
        LegacyListDelimiterHandler listHandler = new LegacyListDelimiterHandler(',');
        this.conf1 = new PropertiesConfiguration();
        this.conf1.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler1 = new FileHandler((FileBased)this.conf1);
        handler1.setFileName(this.testProperties);
        handler1.load();
        this.conf2 = new PropertiesConfiguration();
        this.conf2.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler2 = new FileHandler((FileBased)this.conf2);
        handler2.setFileName(this.testProperties2);
        handler2.load();
        this.xmlConf = new XMLConfiguration();
        FileHandler handler3 = new FileHandler((FileBased)this.xmlConf);
        handler3.load(new File(this.testPropertiesXML));
        this.cc.setThrowExceptionOnMissing(false);
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assert.assertFalse((String)"Throw Exception Property is set!", (boolean)this.cc.isThrowExceptionOnMissing());
    }

    @Test
    public void testAddRemoveConfigurations() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertEquals((long)3L, (long)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration((Configuration)this.conf1);
        Assert.assertEquals((long)2L, (long)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assert.assertEquals((long)1L, (long)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testGetPropertyWIncludes() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        List l = this.cc.getList("packages");
        Assert.assertTrue((boolean)l.contains("packagea"));
    }

    @Test
    public void testGetProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (Object)"test.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.conf2);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from conf2 first", (Object)"test2.properties", (Object)this.cc.getString("propertyInOrder"));
    }

    @Test
    public void testCantRemoveMemoryConfig() throws Exception {
        this.cc.clear();
        Assert.assertEquals((long)1L, (long)this.cc.getNumberOfConfigurations());
        Configuration internal = this.cc.getConfiguration(0);
        this.cc.removeConfiguration(internal);
        Assert.assertEquals((long)1L, (long)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testGetPropertyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assert.assertNull((String)"Bogus property is not null!", (Object)this.cc.getString("bogus.property"));
        Assert.assertTrue((String)"Should be false", (!this.cc.getBoolean("test.missing.boolean", false) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should be true", (boolean)this.cc.getBoolean("test.missing.boolean.true", true));
    }

    @Test
    public void testMultipleTypesOfConfigs() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((String)"Make sure we get the property from conf1 first", (long)1L, (long)this.cc.getInt("test.short"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assert.assertEquals((String)"Make sure we get the property from xml", (long)8L, (long)this.cc.getInt("test.short"));
    }

    @Test
    public void testPropertyExistsInOnlyOneConfig() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((Object)"value", (Object)this.cc.getString("element"));
    }

    @Test
    public void testDefaultValueWhenKeyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals((Object)"default", (Object)this.cc.getString("bogus", "default"));
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
        Assert.assertTrue((1.4 == this.cc.getDouble("bogus", 1.4) ? 1 : 0) != 0);
    }

    @Test
    public void testGettingConfiguration() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assert.assertEquals(PropertiesConfiguration.class, this.cc.getConfiguration(0).getClass());
        Assert.assertEquals(XMLConfiguration.class, this.cc.getConfiguration(1).getClass());
    }

    @Test
    public void testClearingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.clearProperty("test.short");
        Assert.assertTrue((String)"Make sure test.short is gone!", (!this.cc.containsKey("test.short") ? 1 : 0) != 0);
    }

    @Test
    public void testAddingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] values = this.cc.getStringArray("test.short");
        Assert.assertEquals((String)"Number of values before add is wrong!", (long)1L, (long)values.length);
        Assert.assertEquals((String)"First Value before add is wrong", (Object)"1", (Object)values[0]);
        this.cc.addProperty("test.short", (Object)"88");
        values = this.cc.getStringArray("test.short");
        Assert.assertEquals((String)"Number of values is wrong!", (long)2L, (long)values.length);
        Assert.assertEquals((String)"First Value is wrong", (Object)"1", (Object)values[0]);
        Assert.assertEquals((String)"Third Value is wrong", (Object)"88", (Object)values[1]);
    }

    @Test
    public void testSettingMissingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.setProperty("my.new.property", (Object)"supernew");
        Assert.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }

    @Test
    public void testGettingSubset() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Configuration subset = null;
        subset = this.cc.subset("test");
        Assert.assertNotNull((Object)subset);
        Assert.assertFalse((String)"Shouldn't be empty", (boolean)subset.isEmpty());
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overrides any later add configs subset", (Object)"1", (Object)subset.getString("short"));
        this.cc.setProperty("test.short", (Object)"43");
        subset = this.cc.subset("test");
        Assert.assertEquals((String)"Make sure the initial loaded configs subset overrides any later add configs subset", (Object)"43", (Object)subset.getString("short"));
    }

    @Test
    public void testSubsetCanResolve() throws Exception {
        this.cc = new CompositeConfiguration();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("subset.tempfile", (Object)"${java.io.tmpdir}/file.tmp");
        this.cc.addConfiguration((Configuration)config);
        this.cc.addConfiguration(ConfigurationConverter.getConfiguration((Properties)System.getProperties()));
        Configuration subset = this.cc.subset("subset");
        Assert.assertEquals((Object)(System.getProperty("java.io.tmpdir") + "/file.tmp"), (Object)subset.getString("tempfile"));
    }

    @Test
    public void testList() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        List packages = this.cc.getList("packages");
        Assert.assertEquals((long)3L, (long)packages.size());
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("1");
        defaultList.add("2");
        packages = this.cc.getList("packages.which.dont.exist", defaultList);
        Assert.assertEquals((long)2L, (long)packages.size());
    }

    @Test
    public void testStringArray() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] packages = this.cc.getStringArray("packages");
        Assert.assertEquals((long)3L, (long)packages.length);
        packages = this.cc.getStringArray("packages.which.dont.exist");
        Assert.assertEquals((long)0L, (long)packages.length);
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        List list = this.cc.getList("array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
        Assert.assertTrue((String)"'value1' not found in the list", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' not found in the list", (boolean)list.contains("value2"));
        this.cc.addProperty("array", (Object)"value5");
        list = this.cc.getList("array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertEquals((String)"list size", (long)3L, (long)list.size());
        Assert.assertTrue((String)"'value1' not found in the list", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' not found in the list", (boolean)list.contains("value2"));
        Assert.assertTrue((String)"'value5' not found in the list", (boolean)list.contains("value5"));
    }

    @Test
    public void testGetVector() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        this.cc.addProperty("array", (Object)"value5");
        List list = this.cc.getList("array");
        Assert.assertEquals((String)"Wrong number of elements", (long)3L, (long)list.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"value1", list.get(0));
        Assert.assertEquals((String)"Wrong element 2", (Object)"value2", list.get(1));
        Assert.assertEquals((String)"Wrong element 3", (Object)"value5", list.get(2));
    }

    @Test
    public void testGetKeysPreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys();
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys();
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((long)orderedList.size(), (long)iteratedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
        }
    }

    @Test
    public void testGetKeys2PreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList orderedList = new ArrayList();
        Iterator keys = this.conf1.getKeys("test");
        while (keys.hasNext()) {
            orderedList.add(keys.next());
        }
        ArrayList iteratedList = new ArrayList();
        Iterator keys2 = this.cc.getKeys("test");
        while (keys2.hasNext()) {
            iteratedList.add(keys2.next());
        }
        Assert.assertEquals((long)orderedList.size(), (long)iteratedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            Assert.assertEquals(orderedList.get(i), iteratedList.get(i));
        }
    }

    @Test
    public void testGetStringWithDefaults() {
        BaseConfiguration defaults = new BaseConfiguration();
        defaults.addProperty("default", (Object)"default string");
        CompositeConfiguration c = new CompositeConfiguration((Configuration)defaults);
        c.addProperty("string", (Object)"test string");
        Assert.assertEquals((Object)"test string", (Object)c.getString("string"));
        Assert.assertNull((String)"XXX should have been null!", (Object)c.getString("XXX"));
        Assert.assertEquals((Object)"test string", (Object)c.getString("string", "some default value"));
        Assert.assertEquals((Object)"default string", (Object)c.getString("default"));
        Assert.assertEquals((Object)"default string", (Object)c.getString("default", "some default value"));
        Assert.assertEquals((Object)"some default value", (Object)c.getString("XXX", "some default value"));
    }

    @Test
    public void testCheckingInMemoryConfiguration() throws Exception {
        String TEST_KEY = "testKey";
        PropertiesConfiguration defaults = new PropertiesConfiguration();
        defaults.setProperty("testKey", (Object)"testValue");
        CompositeConfiguration testConfiguration = new CompositeConfiguration((Configuration)defaults);
        Assert.assertTrue((boolean)testConfiguration.containsKey("testKey"));
        Assert.assertFalse((boolean)testConfiguration.isEmpty());
        boolean foundTestKey = false;
        Iterator i = testConfiguration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals("testKey")) continue;
            foundTestKey = true;
        }
        Assert.assertTrue((boolean)foundTestKey);
        testConfiguration.clearProperty("testKey");
        Assert.assertFalse((boolean)testConfiguration.containsKey("testKey"));
    }
}

