/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationMap {
    ConfigurationMap map;
    String[] properties = new String[]{"booleanProperty", "doubleProperty", "floatProperty", "intProperty", "longProperty", "shortProperty", "stringProperty"};
    Object[] values = new Object[]{Boolean.TRUE, new Double(Double.MAX_VALUE), new Float(Float.MAX_VALUE), new Integer(Integer.MAX_VALUE), new Long(Long.MAX_VALUE), new Short(Short.MAX_VALUE), "This is a string"};

    @Before
    public void setUp() throws Exception {
        BaseConfiguration configuration = new BaseConfiguration();
        for (int i = 0; i < this.properties.length; ++i) {
            configuration.setProperty(this.properties[i], this.values[i]);
        }
        this.map = new ConfigurationMap((Configuration)configuration);
    }

    @After
    public void tearDown() {
        this.map = null;
    }

    @Test
    public void testPut() {
        for (int i = 0; i < this.properties.length; ++i) {
            Object object = this.map.put((Object)this.properties[i], this.values[i]);
            Assert.assertNotNull((String)"Returned null from put.", (Object)object);
            Assert.assertEquals((String)"Returned wrong result.", (Object)this.values[i], (Object)object);
            object = this.map.get((Object)this.properties[i]);
            Assert.assertNotNull((String)"Returned null from get.", (Object)object);
            Assert.assertEquals((String)"Returned wrong result.", (Object)this.values[i], (Object)object);
        }
    }
}

