/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.NoSuchElementException;
import org.apache.commons.configuration2.tree.DefaultConfigurationKey;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultConfigurationKey {
    private static final String TESTPROPS = "tables.table(0).fields.field(1)";
    private static final String TESTATTR = "[@dataType]";
    private static final String TESTKEY = "tables.table(0).fields.field(1)[@dataType]";
    private DefaultExpressionEngine expressionEngine;
    private DefaultConfigurationKey key;

    private DefaultConfigurationKey key(String k) {
        return new DefaultConfigurationKey(this.expressionEngine, k);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.expressionEngine = DefaultExpressionEngine.INSTANCE;
        this.key = new DefaultConfigurationKey(this.expressionEngine);
    }

    private DefaultExpressionEngineSymbols.Builder symbols() {
        return new DefaultExpressionEngineSymbols.Builder(this.expressionEngine.getSymbols());
    }

    @Test
    public void testAppend() {
        this.key.append("tables").append("table(0).");
        this.key.append("fields.").append("field(1)");
        this.key.append(null).append(TESTATTR);
        Assertions.assertEquals((Object)TESTKEY, (Object)this.key.toString());
    }

    @Test
    public void testAppendAttribute() {
        this.key.appendAttribute("dataType");
        Assertions.assertEquals((Object)TESTATTR, (Object)this.key.toString());
    }

    @Test
    public void testAppendComplexKey() {
        this.key.append("tables").append("table.").appendIndex(0);
        this.key.append("fields.").append("field").appendIndex(1);
        this.key.appendAttribute("dataType");
        Assertions.assertEquals((Object)TESTKEY, (Object)this.key.toString());
    }

    @Test
    public void testAppendDecoratedAttributeKey() {
        this.key.appendAttribute(TESTATTR);
        Assertions.assertEquals((Object)TESTATTR, (Object)this.key.toString());
    }

    @Test
    public void testAppendDelimiters() {
        this.key.append("key..").append("test").append(".");
        this.key.append(".more").append("..tests");
        Assertions.assertEquals((Object)"key...test.more...tests", (Object)this.key.toString());
    }

    @Test
    public void testAppendDelimitersWithoutEscaping() {
        this.expressionEngine = new DefaultExpressionEngine(this.symbols().setEscapedDelimiter(null).create());
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        this.key.append("key.......").append("test").append(".");
        this.key.append(".more").append("..tests");
        Assertions.assertEquals((Object)"key.test.more.tests", (Object)this.key.toString());
    }

    @Test
    public void testAppendIndex() {
        this.key.append("test").appendIndex(42);
        Assertions.assertEquals((Object)"test(42)", (Object)this.key.toString());
    }

    @Test
    public void testAppendNullAttributeKey() {
        this.key.appendAttribute(null);
        Assertions.assertEquals((Object)"", (Object)this.key.toString());
    }

    @Test
    public void testAppendWithEscapeFlag() {
        this.key.append(".key.test.", true);
        this.key.append(".more").append(".tests", true);
        Assertions.assertEquals((Object)"..key..test...more...tests", (Object)this.key.toString());
    }

    @Test
    public void testAttributeKeyWithIndex() {
        this.key.append(TESTATTR);
        this.key.appendIndex(0);
        Assertions.assertEquals((Object)"[@dataType](0)", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        it.next();
        Assertions.assertTrue((boolean)it.hasIndex());
        Assertions.assertEquals((int)0, (int)it.getIndex());
        Assertions.assertTrue((boolean)it.isAttribute());
        Assertions.assertEquals((Object)"dataType", (Object)it.currentKey(false));
        Assertions.assertEquals((Object)TESTATTR, (Object)it.currentKey(true));
    }

    @Test
    public void testAttributeName() {
        Assertions.assertEquals((Object)"test", (Object)this.key.attributeName("test"));
        Assertions.assertEquals((Object)"dataType", (Object)this.key.attributeName(TESTATTR));
        Assertions.assertNull((Object)this.key.attributeName(null));
    }

    @Test
    public void testCommonKey() {
        DefaultConfigurationKey k1 = this.key(TESTKEY);
        DefaultConfigurationKey k2 = this.key("tables.table(0).name");
        DefaultConfigurationKey kc = k1.commonKey(k2);
        Assertions.assertEquals((Object)this.key("tables.table(0)"), (Object)kc);
        Assertions.assertEquals((Object)kc, (Object)k2.commonKey(k1));
        k2 = this.key("tables.table(1).fields.field(1)");
        kc = k1.commonKey(k2);
        Assertions.assertEquals((Object)this.key("tables"), (Object)kc);
        k2 = this.key("completely.different.key");
        kc = k1.commonKey(k2);
        Assertions.assertEquals((int)0, (int)kc.length());
        kc = k1.commonKey(this.key);
        Assertions.assertEquals((int)0, (int)kc.length());
        kc = k1.commonKey(k1);
        Assertions.assertEquals((Object)kc, (Object)k1);
    }

    @Test
    public void testCommonKeyNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.key.commonKey(null));
    }

    @Test
    public void testConstructAttributeKey() {
        Assertions.assertEquals((Object)TESTATTR, (Object)this.key.constructAttributeKey("dataType"));
        Assertions.assertEquals((Object)TESTATTR, (Object)this.key.constructAttributeKey(TESTATTR));
        Assertions.assertEquals((Object)"", (Object)this.key.constructAttributeKey(null));
    }

    @Test
    public void testConstructAttributeKeyWithoutEndMarkers() {
        DefaultExpressionEngineSymbols symbols = this.symbols().setAttributeEnd(null).setAttributeStart(this.expressionEngine.getSymbols().getPropertyDelimiter()).create();
        this.expressionEngine = new DefaultExpressionEngine(symbols);
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        Assertions.assertEquals((Object)".test", (Object)this.key.constructAttributeKey("test"));
        Assertions.assertEquals((Object)".test", (Object)this.key.constructAttributeKey(".test"));
    }

    @Test
    public void testDifferenceKey() {
        DefaultConfigurationKey k1 = this.key(TESTKEY);
        DefaultConfigurationKey k2 = this.key("tables.table(0).name");
        DefaultConfigurationKey kd = k1.differenceKey(k2);
        Assertions.assertEquals((Object)"name", (Object)kd.toString());
        k2 = this.key("tables.table(1).fields.field(1)");
        kd = k1.differenceKey(k2);
        Assertions.assertEquals((Object)"table(1).fields.field(1)", (Object)kd.toString());
        k2 = this.key("completely.different.key");
        kd = k1.differenceKey(k2);
        Assertions.assertEquals((Object)k2, (Object)kd);
    }

    @Test
    public void testDifferenceKeySame() {
        DefaultConfigurationKey k1 = this.key(TESTKEY);
        DefaultConfigurationKey kd = k1.differenceKey(k1);
        Assertions.assertEquals((int)0, (int)kd.length());
    }

    @Test
    public void testEquals() {
        DefaultConfigurationKey k1 = this.key(TESTKEY);
        Assertions.assertEquals((Object)k1, (Object)k1);
        DefaultConfigurationKey k2 = this.key(TESTKEY);
        Assertions.assertEquals((Object)k1, (Object)k2);
        Assertions.assertEquals((Object)k2, (Object)k1);
        Assertions.assertEquals((int)k1.hashCode(), (int)k2.hashCode());
        k2.append("anotherPart");
        Assertions.assertNotEquals((Object)k1, (Object)k2);
        Assertions.assertNotEquals((Object)k2, (Object)k1);
        Assertions.assertNotEquals(null, (Object)k1);
        Assertions.assertNotEquals((Object)TESTKEY, (Object)k1);
    }

    @Test
    public void testIsAttributeKey() {
        Assertions.assertTrue((boolean)this.key.isAttributeKey(TESTATTR));
        Assertions.assertFalse((boolean)this.key.isAttributeKey(TESTPROPS));
        Assertions.assertFalse((boolean)this.key.isAttributeKey(null));
    }

    @Test
    public void testIsAttributeKeyWithoutEndMarkers() {
        DefaultExpressionEngineSymbols symbols = this.symbols().setAttributeEnd(null).setAttributeStart(".").create();
        this.expressionEngine = new DefaultExpressionEngine(symbols);
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        Assertions.assertTrue((boolean)this.key.isAttributeKey(".test"));
        Assertions.assertFalse((boolean)this.key.isAttributeKey(TESTATTR));
    }

    @Test
    public void testIterate() {
        this.key.append(TESTKEY);
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"tables", (Object)it.nextKey());
        Assertions.assertEquals((Object)"table", (Object)it.nextKey());
        Assertions.assertTrue((boolean)it.hasIndex());
        Assertions.assertEquals((int)0, (int)it.getIndex());
        Assertions.assertEquals((Object)"fields", (Object)it.nextKey());
        Assertions.assertFalse((boolean)it.hasIndex());
        Assertions.assertEquals((Object)"field", (Object)it.nextKey(true));
        Assertions.assertEquals((int)1, (int)it.getIndex());
        Assertions.assertFalse((boolean)it.isAttribute());
        Assertions.assertEquals((Object)"field", (Object)it.currentKey(true));
        Assertions.assertEquals((Object)"dataType", (Object)it.nextKey());
        Assertions.assertEquals((Object)TESTATTR, (Object)it.currentKey(true));
        Assertions.assertTrue((boolean)it.isAttribute());
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DefaultConfigurationKey.KeyIterator)it).next());
    }

    @Test
    public void testIterateAlternativeEscapeDelimiter() {
        this.expressionEngine = new DefaultExpressionEngine(this.symbols().setEscapedDelimiter("\\.").create());
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        this.key.append("\\.my\\.elem");
        this.key.append("trailing\\.dot\\.");
        this.key.append(".strange");
        Assertions.assertEquals((Object)"\\.my\\.elem.trailing\\.dot\\..strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assertions.assertEquals((Object)".my.elem", (Object)kit.nextKey());
        Assertions.assertEquals((Object)"trailing.dot.", (Object)kit.nextKey());
        Assertions.assertEquals((Object)"strange", (Object)kit.nextKey());
        Assertions.assertFalse((boolean)kit.hasNext());
    }

    @Test
    public void testIterateAttributeEqualsPropertyDelimiter() {
        this.expressionEngine = new DefaultExpressionEngine(this.symbols().setAttributeEnd(null).setAttributeStart(".").create());
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        this.key.append("this.isa.key");
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assertions.assertEquals((Object)"this", (Object)kit.next());
        Assertions.assertFalse((boolean)kit.isAttribute());
        Assertions.assertTrue((boolean)kit.isPropertyKey());
        Assertions.assertEquals((Object)"isa", (Object)kit.next());
        Assertions.assertFalse((boolean)kit.isAttribute());
        Assertions.assertTrue((boolean)kit.isPropertyKey());
        Assertions.assertEquals((Object)"key", (Object)kit.next());
        Assertions.assertTrue((boolean)kit.isAttribute());
        Assertions.assertTrue((boolean)kit.isPropertyKey());
        Assertions.assertEquals((Object)"key", (Object)kit.currentKey(true));
    }

    @Test
    public void testIterateEscapedDelimiters() {
        this.key.append("my..elem");
        this.key.append("trailing..dot..");
        this.key.append(".strange");
        Assertions.assertEquals((Object)"my..elem.trailing..dot...strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        Assertions.assertEquals((Object)"my.elem", (Object)kit.nextKey());
        Assertions.assertEquals((Object)"trailing.dot.", (Object)kit.nextKey());
        Assertions.assertEquals((Object)"strange", (Object)kit.nextKey());
        Assertions.assertFalse((boolean)kit.hasNext());
    }

    @Test
    public void testIterateStrangeKeys() {
        this.key = new DefaultConfigurationKey(this.expressionEngine, "key.");
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"key", (Object)it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        this.key = new DefaultConfigurationKey(this.expressionEngine, ".");
        it = this.key.iterator();
        Assertions.assertFalse((boolean)it.hasNext());
        this.key = new DefaultConfigurationKey(this.expressionEngine, "key().index()undefined(0).test");
        it = this.key.iterator();
        Assertions.assertEquals((Object)"key()", (Object)it.next());
        Assertions.assertFalse((boolean)it.hasIndex());
        Assertions.assertEquals((Object)"index()undefined", (Object)it.nextKey(false));
        Assertions.assertTrue((boolean)it.hasIndex());
        Assertions.assertEquals((int)0, (int)it.getIndex());
    }

    @Test
    public void testIterateWithBrackets() {
        this.key.append("directory.platform(x86).path");
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        String part = kit.nextKey();
        Assertions.assertEquals((Object)"directory", (Object)part);
        Assertions.assertFalse((boolean)kit.hasIndex());
        part = kit.nextKey();
        Assertions.assertEquals((Object)"platform(x86)", (Object)part);
        Assertions.assertFalse((boolean)kit.hasIndex());
        part = kit.nextKey();
        Assertions.assertEquals((Object)"path", (Object)part);
        Assertions.assertFalse((boolean)kit.hasIndex());
        Assertions.assertFalse((boolean)kit.hasNext());
    }

    @Test
    public void testIterateWithoutEscapeDelimiter() {
        this.expressionEngine = new DefaultExpressionEngine(this.symbols().setEscapedDelimiter(null).create());
        this.key = new DefaultConfigurationKey(this.expressionEngine);
        this.key.append("..my..elem.trailing..dot...strange");
        Assertions.assertEquals((Object)"my..elem.trailing..dot...strange", (Object)this.key.toString());
        DefaultConfigurationKey.KeyIterator kit = this.key.iterator();
        String[] parts = new String[]{"my", "elem", "trailing", "dot", "strange"};
        for (int i = 0; i < parts.length; ++i) {
            Assertions.assertEquals((Object)parts[i], (Object)kit.next(), (String)("Wrong key part " + i));
        }
        Assertions.assertFalse((boolean)kit.hasNext());
    }

    @Test
    public void testIterateWithRemove() {
        Assertions.assertFalse((boolean)this.key.iterator().hasNext());
        this.key.append("simple");
        DefaultConfigurationKey.KeyIterator it = this.key.iterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)"simple", (Object)it.next());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((DefaultConfigurationKey.KeyIterator)it).remove());
    }

    @Test
    public void testLength() {
        this.key.append(TESTPROPS);
        Assertions.assertEquals((int)TESTPROPS.length(), (int)this.key.length());
        this.key.appendAttribute("dataType");
        Assertions.assertEquals((int)TESTKEY.length(), (int)this.key.length());
        this.key.setLength(TESTPROPS.length());
        Assertions.assertEquals((int)TESTPROPS.length(), (int)this.key.length());
        Assertions.assertEquals((Object)TESTPROPS, (Object)this.key.toString());
    }

    @Test
    public void testSetNullExpressionEngine() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultConfigurationKey(null));
    }

    @Test
    public void testTrim() {
        Assertions.assertEquals((Object)"test", (Object)this.key.trim(".test."));
        Assertions.assertEquals((Object)"", (Object)this.key.trim(null));
        Assertions.assertEquals((Object)"", (Object)this.key.trim("."));
    }

    @Test
    public void testTrimLeft() {
        Assertions.assertEquals((Object)"test.", (Object)this.key.trimLeft(".test."));
        Assertions.assertEquals((Object)"..test.", (Object)this.key.trimLeft("..test."));
    }

    @Test
    public void testTrimRight() {
        Assertions.assertEquals((Object)".test", (Object)this.key.trimRight(".test."));
        Assertions.assertEquals((Object)".test..", (Object)this.key.trimRight(".test.."));
    }
}

