/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationDecoder;
import org.apache.commons.configuration2.ConfigurationLookup;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAbstractConfigurationBasicFeatures {
    private static final String SUBST_TXT = "The ${animal} jumps over the ${target}.";
    private static final String KEY_PREFIX = "key";
    private static final int PROP_COUNT = 12;

    private static List<Integer> prepareListTest(PropertiesConfiguration config) {
        ArrayList<Integer> expected = new ArrayList<Integer>(12);
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected.add(i);
        }
        return expected;
    }

    private void checkAddListProperty(AbstractConfiguration config) {
        config.addProperty("test", (Object)"value1");
        Object[] lstValues1 = new Object[]{"value2", "value3"};
        Object[] lstValues2 = new Object[]{"value4", "value5", "value6"};
        config.addProperty("test", (Object)lstValues1);
        config.addProperty("test", Arrays.asList(lstValues2));
        List lst = config.getList("test");
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < lst.size(); ++i) {
            expected.add("value" + (i + 1));
        }
        Assertions.assertEquals(expected, (Object)lst);
    }

    private void checkCopyEvents(CollectingConfigurationListener l, Configuration src, EventType<?> eventType) {
        HashMap<String, ConfigurationEvent> events = new HashMap<String, ConfigurationEvent>();
        for (ConfigurationEvent e : l.events) {
            Assertions.assertEquals(eventType, (Object)e.getEventType());
            Assertions.assertTrue((boolean)src.containsKey(e.getPropertyName()), (String)("Unknown property: " + e.getPropertyName()));
            if (!e.isBeforeUpdate()) {
                Assertions.assertTrue((boolean)events.containsKey(e.getPropertyName()));
                continue;
            }
            events.put(e.getPropertyName(), e);
        }
        Iterator it = src.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assertions.assertTrue((boolean)events.containsKey(key), (String)("No event received for key " + key));
        }
    }

    private void checkGetListScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        List lst = config.getList(KEY_PREFIX);
        Assertions.assertEquals(Arrays.asList(value.toString()), (Object)lst);
    }

    private void checkGetStringArrayScalar(Object value) {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty(KEY_PREFIX, value);
        Object[] array = config.getStringArray(KEY_PREFIX);
        Assertions.assertArrayEquals((Object[])new String[]{value.toString()}, (Object[])array);
    }

    private void checkListProperties(Configuration config) {
        List values = config.getList("list1");
        Assertions.assertEquals((int)3, (int)values.size());
        values = config.getList("list2");
        Assertions.assertEquals(Arrays.asList("3,1415", "9,81"), (Object)values);
    }

    private AbstractConfiguration setUpDestConfig() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        return config;
    }

    private Configuration setUpSourceConfig() {
        BaseConfiguration config = new BaseConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        for (int i = 1; i < 12; i += 2) {
            config.addProperty(KEY_PREFIX + i, (Object)("src" + i));
        }
        config.addProperty("list1", (Object)"1,2,3");
        config.addProperty("list2", (Object)"3\\,1415,9\\,81");
        return config;
    }

    @Test
    public void testAddPropertyList() {
        this.checkAddListProperty(new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration()));
    }

    @Test
    public void testAddPropertyListNoDelimiterParsing() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        this.checkAddListProperty(config);
    }

    @Test
    public void testAppend() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.append(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                List values = config.getList(key);
                Assertions.assertEquals(Arrays.asList("value" + i, "src" + i), (Object)values, (String)("Wrong values for " + key));
                continue;
            }
            Assertions.assertEquals((Object)("value" + i), (Object)config.getProperty(key), (String)("Value modified: " + key));
        }
    }

    @Test
    public void testAppendDelimiterHandling() {
        BaseConfiguration srcConfig = new BaseConfiguration();
        BaseConfiguration dstConfig = new BaseConfiguration();
        dstConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        srcConfig.setProperty(KEY_PREFIX, (Object)"C:\\Temp\\,D:\\Data");
        dstConfig.append((Configuration)srcConfig);
        Assertions.assertEquals((Object)srcConfig.getString(KEY_PREFIX), (Object)dstConfig.getString(KEY_PREFIX));
    }

    @Test
    public void testAppendEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        config.append(srcConfig);
        this.checkCopyEvents(l, srcConfig, ConfigurationEvent.ADD_PROPERTY);
    }

    @Test
    public void testAppendNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(null);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.setUpDestConfig(), (ImmutableConfiguration)config);
    }

    @Test
    public void testAppendWithLists() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.append(this.setUpSourceConfig());
        this.checkListProperties((Configuration)config);
    }

    @Test
    public void testClearIteratorNoRemove() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new BaseConfiguration()){

            @Override
            protected Iterator<String> getKeysInternal() {
                ArrayList<String> keyCol = new ArrayList<String>();
                ConfigurationAssert.appendKeys((ImmutableConfiguration)this.getUnderlyingConfiguration(), keyCol);
                String[] keys = keyCol.toArray(new String[keyCol.size()]);
                return Arrays.asList(keys).iterator();
            }
        };
        for (int i = 0; i < 20; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        config.clear();
        Assertions.assertTrue((boolean)config.isEmpty());
    }

    @Test
    public void testCopy() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        config.copy(srcConfig);
        for (int i = 0; i < 12; ++i) {
            String key = KEY_PREFIX + i;
            if (srcConfig.containsKey(key)) {
                Assertions.assertEquals((Object)srcConfig.getProperty(key), (Object)config.getProperty(key), (String)("Value not replaced: " + key));
                continue;
            }
            Assertions.assertEquals((Object)("value" + i), (Object)config.getProperty(key), (String)("Value modified: " + key));
        }
    }

    @Test
    public void testCopyDelimiterHandling() {
        BaseConfiguration srcConfig = new BaseConfiguration();
        BaseConfiguration dstConfig = new BaseConfiguration();
        dstConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        srcConfig.setProperty(KEY_PREFIX, (Object)"C:\\Temp\\,D:\\Data");
        dstConfig.copy((Configuration)srcConfig);
        Assertions.assertEquals((Object)srcConfig.getString(KEY_PREFIX), (Object)dstConfig.getString(KEY_PREFIX));
    }

    @Test
    public void testCopyEvents() {
        AbstractConfiguration config = this.setUpDestConfig();
        Configuration srcConfig = this.setUpSourceConfig();
        CollectingConfigurationListener l = new CollectingConfigurationListener();
        config.addEventListener(ConfigurationEvent.ANY, (EventListener)l);
        config.copy(srcConfig);
        this.checkCopyEvents(l, srcConfig, ConfigurationEvent.SET_PROPERTY);
    }

    @Test
    public void testCopyNull() {
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(null);
        ConfigurationAssert.assertConfigurationEquals((ImmutableConfiguration)this.setUpDestConfig(), (ImmutableConfiguration)config);
    }

    @Test
    public void testCopyWithLists() {
        Configuration srcConfig = this.setUpSourceConfig();
        AbstractConfiguration config = this.setUpDestConfig();
        config.copy(srcConfig);
        this.checkListProperties((Configuration)config);
    }

    @Test
    public void testCyclicInterpolation() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} ${species}");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("species", (Object)"${animal}");
        config.addProperty(KEY_PREFIX, (Object)"This is a ${animal}");
        Assertions.assertThrows(IllegalStateException.class, () -> config.getString(KEY_PREFIX));
    }

    @Test
    public void testDefaultConversionHandler() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertEquals(DefaultConversionHandler.class, config.getConversionHandler().getClass());
    }

    @Test
    public void testDefaultConversionHandlerSharedInstance() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        PropertiesConfiguration config2 = new PropertiesConfiguration();
        Assertions.assertSame((Object)config.getConversionHandler(), (Object)config2.getConversionHandler());
    }

    @Test
    public void testDefaultListDelimiterHandler() {
        BaseConfiguration config = new BaseConfiguration();
        Assertions.assertInstanceOf(DisabledListDelimiterHandler.class, (Object)config.getListDelimiterHandler());
    }

    @Test
    public void testGet() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Integer value = 20130816;
        config.addProperty(KEY_PREFIX, (Object)value.toString());
        Assertions.assertEquals((Integer)value, (Integer)((Integer)config.get(Integer.class, KEY_PREFIX)));
    }

    @Test
    public void testGetArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Object[] expected = new Integer[12];
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected[i] = i;
        }
        Object[] result = (Integer[])config.get(Integer[].class, KEY_PREFIX);
        Assertions.assertArrayEquals((Object[])expected, (Object[])result);
    }

    @Test
    public void testGetArrayDefaultValueNotAnArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.getArray(Integer.class, KEY_PREFIX, (Object)this));
    }

    @Test
    public void testGetArrayDefaultValueWrongComponentClass() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.getArray(Integer.class, KEY_PREFIX, (Object)new short[1]));
    }

    @Test
    public void testGetArrayPrimitive() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        short[] expected = new short[12];
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX, (Object)String.valueOf(i));
            expected[i] = (short)i;
        }
        short[] result = (short[])config.get(short[].class, KEY_PREFIX, (Object)ArrayUtils.EMPTY_SHORT_ARRAY);
        Assertions.assertArrayEquals((short[])expected, (short[])result);
    }

    @Test
    public void testGetArrayUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertNull((Object)config.get(Integer[].class, KEY_PREFIX));
    }

    @Test
    public void testGetArrayUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        int[] defValue = new int[]{1, 2, 3};
        Assertions.assertArrayEquals((int[])defValue, (int[])((int[])config.get(int[].class, KEY_PREFIX, (Object)defValue)));
    }

    @Test
    public void testGetCollection() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        ArrayList result = new ArrayList(12);
        Assertions.assertSame(result, (Object)config.getCollection(Integer.class, KEY_PREFIX, result));
        Assertions.assertEquals(expected, result);
    }

    @Test
    public void testGetCollectionNullTarget() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        Collection result = config.getCollection(Integer.class, KEY_PREFIX, null, new ArrayList());
        Assertions.assertEquals(expected, (Object)result);
    }

    @Test
    public void testGetCollectionSingleValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty(KEY_PREFIX, (Object)"1");
        ArrayList result = new ArrayList(1);
        config.getCollection(Integer.class, KEY_PREFIX, result);
        Assertions.assertEquals(Arrays.asList(1), result);
    }

    @Test
    public void testGetCollectionUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        ArrayList result = new ArrayList();
        Assertions.assertNull((Object)config.getCollection(Integer.class, KEY_PREFIX, result));
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGetCollectionUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> defValue = Arrays.asList(1, 2, 4, 8, 16, 32);
        Collection result = config.getCollection(Integer.class, KEY_PREFIX, null, defValue);
        Assertions.assertEquals(defValue, (Object)result);
    }

    @Test
    public void testGetEncodedStringNoDecoder() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.getEncodedString(KEY_PREFIX, null));
    }

    @Test
    public void testGetEncodedStringNoDefaultDecoderDefined() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertThrows(IllegalStateException.class, () -> config.getEncodedString(KEY_PREFIX));
    }

    @Test
    public void testGetEncodedStringNoValue() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertNull((Object)config.getEncodedString(KEY_PREFIX, decoder));
    }

    @Test
    public void testGetEncodedStringValue() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        String value = "original value";
        String decodedValue = "decoded value";
        Mockito.when((Object)decoder.decode("original value")).thenReturn((Object)"decoded value");
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty(KEY_PREFIX, (Object)"original value");
        Assertions.assertEquals((Object)"decoded value", (Object)config.getEncodedString(KEY_PREFIX, decoder));
    }

    @Test
    public void testGetEncodedStringWithDefaultDecoder() {
        ConfigurationDecoder decoder = (ConfigurationDecoder)Mockito.mock(ConfigurationDecoder.class);
        String value = "original value";
        String decodedValue = "decoded value";
        Mockito.when((Object)decoder.decode("original value")).thenReturn((Object)"decoded value");
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setConfigurationDecoder(decoder);
        config.addProperty(KEY_PREFIX, (Object)"original value");
        Assertions.assertEquals((Object)"decoded value", (Object)config.getEncodedString(KEY_PREFIX));
    }

    @Test
    public void testGetList() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> expected = TestAbstractConfigurationBasicFeatures.prepareListTest(config);
        List result = config.getList(Integer.class, KEY_PREFIX);
        Assertions.assertEquals(expected, (Object)result);
    }

    @Test
    public void testGetListNonString() {
        this.checkGetListScalar(42);
        this.checkGetListScalar(42L);
        this.checkGetListScalar((short)42);
        this.checkGetListScalar((byte)42);
        this.checkGetListScalar(Float.valueOf(42.0f));
        this.checkGetListScalar(42.0);
        this.checkGetListScalar(Boolean.TRUE);
    }

    @Test
    public void testGetListUnknownNoDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertNull((Object)config.getList(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetListUnknownWithDefault() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<Integer> defValue = Arrays.asList(1, 2, 3);
        Assertions.assertEquals(defValue, (Object)config.getList(Integer.class, KEY_PREFIX, defValue));
    }

    @Test
    public void testGetStringArrayNonString() {
        this.checkGetStringArrayScalar(42);
        this.checkGetStringArrayScalar(42L);
        this.checkGetStringArrayScalar((short)42);
        this.checkGetStringArrayScalar((byte)42);
        this.checkGetStringArrayScalar(Float.valueOf(42.0f));
        this.checkGetStringArrayScalar(42.0);
        this.checkGetStringArrayScalar(Boolean.TRUE);
    }

    @Test
    public void testGetStringArrayUnknown() {
        BaseConfiguration config = new BaseConfiguration();
        String[] array = config.getStringArray(KEY_PREFIX);
        Assertions.assertEquals((int)0, (int)array.length);
    }

    @Test
    public void testGetUnknownNoDefaultValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Assertions.assertNull((Object)config.get(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetUnknownWithDefaultValue() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Integer defaultValue = 2121;
        Assertions.assertEquals((Integer)defaultValue, (Integer)((Integer)config.get(Integer.class, KEY_PREFIX, (Object)defaultValue)));
    }

    @Test
    public void testGetUnknownWithThrowExceptionOnMissing() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setThrowExceptionOnMissing(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> config.get(Integer.class, KEY_PREFIX));
    }

    @Test
    public void testGetUnownWithDefaultValueThrowExceptionOnMissing() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setThrowExceptionOnMissing(true);
        Integer defaultValue = 2121;
        Assertions.assertEquals((Integer)defaultValue, (Integer)((Integer)config.get(Integer.class, KEY_PREFIX, (Object)defaultValue)));
    }

    @Test
    public void testInstallInterpolatorNull() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.installInterpolator(null, null);
        Assertions.assertTrue((boolean)config.getInterpolator().getLookups().isEmpty());
        List defLookups = config.getInterpolator().getDefaultLookups();
        Assertions.assertEquals((int)1, (int)defLookups.size());
        Assertions.assertInstanceOf(ConfigurationLookup.class, defLookups.get(0));
    }

    @Test
    public void testInterpolateArray() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        Object[] values = new String[]{"some", "test", "values"};
        String keyArray = "testArray";
        config.addProperty("testArray", (Object)values);
        config.addProperty(KEY_PREFIX, (Object)"${testArray}");
        Assertions.assertArrayEquals((Object[])values, (Object[])config.getStringArray(KEY_PREFIX));
    }

    @Test
    public void testInterpolateEnvironmentVariables() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        InterpolationTestHelper.testInterpolationEnvironment((Configuration)config);
    }

    @Test
    public void testInterpolateEscape() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("mypath", "$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar\\,$${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar");
        Assertions.assertEquals((Object)"${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc.jar,${DB2UNIVERSAL_JDBC_DRIVER_PATH}/db2jcc_license_cu.jar", (Object)config.getString("mypath"));
    }

    @Test
    public void testInterpolateList() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<String> values = Arrays.asList("some", "test", "values");
        String keyList = "testList";
        config.addProperty("testList", values);
        config.addProperty(KEY_PREFIX, (Object)"${testList}");
        Assertions.assertEquals(values, (Object)config.getList(String.class, KEY_PREFIX));
    }

    @Test
    public void testInterpolateRecursive() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"${animal_attr} fox");
        config.addProperty("target", (Object)"${target_attr} dog");
        config.addProperty("animal_attr", (Object)"quick brown");
        config.addProperty("target_attr", (Object)"lazy");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolateString() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty("target", (Object)"lazy dog");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolateStringWithListVariable() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        List<String> values = Arrays.asList("some", "test", "values");
        String keyList = "testList";
        config.addProperty("testList", values);
        config.addProperty(KEY_PREFIX, (Object)"result = ${testList}");
        Assertions.assertEquals((Object)"result = some", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolationNoInterpolator() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty("target", (Object)"lazy dog");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        config.setInterpolator(null);
        Assertions.assertEquals((Object)SUBST_TXT, (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testInterpolationUnknownVariable() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.addProperty("animal", (Object)"quick brown fox");
        config.addProperty(KEY_PREFIX, (Object)SUBST_TXT);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the ${target}.", (Object)config.getString(KEY_PREFIX));
    }

    @Test
    public void testNestedVariableInterpolation() {
        BaseConfiguration config = new BaseConfiguration();
        config.getInterpolator().setEnableSubstitutionInVariables(true);
        config.addProperty("java.version", (Object)"1.4");
        config.addProperty("jre-1.4", (Object)"C:\\java\\1.4");
        config.addProperty("jre.path", (Object)"${jre-${java.version}}");
        Assertions.assertEquals((Object)"C:\\java\\1.4", (Object)config.getString("jre.path"));
    }

    @Test
    public void testSetDefaultConversionHandler() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        DefaultConversionHandler handler = new DefaultConversionHandler();
        config.setConversionHandler((ConversionHandler)handler);
        Assertions.assertSame((Object)handler, (Object)config.getConversionHandler());
    }

    @Test
    public void testSetDefaultConversionHandlerNull() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> configuration.setConversionHandler(null));
    }

    @Test
    public void testSetDefaultLookupsExistingInterpolator() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.getInterpolator().addDefaultLookup((Lookup)new ConfigurationLookup((ImmutableConfiguration)new PropertiesConfiguration()));
        config.setDefaultLookups(Collections.singleton(look));
        List lookups = config.getInterpolator().getDefaultLookups();
        Assertions.assertEquals((int)3, (int)lookups.size());
        Assertions.assertSame((Object)look, lookups.get(1));
        Assertions.assertInstanceOf(ConfigurationLookup.class, lookups.get(2));
    }

    @Test
    public void testSetDefaultLookupsNoInterpolator() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setDefaultLookups(Collections.singleton(look));
        List lookups = config.getInterpolator().getDefaultLookups();
        Assertions.assertEquals((int)2, (int)lookups.size());
        Assertions.assertSame((Object)look, lookups.get(0));
        Assertions.assertInstanceOf(ConfigurationLookup.class, lookups.get(1));
    }

    @Test
    public void testSetListDelimiterHandlerNull() {
        BaseConfiguration config = new BaseConfiguration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.setListDelimiterHandler(null));
    }

    @Test
    public void testSetParentInterpolatorExistingInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        ConfigurationInterpolator ci = config.getInterpolator();
        config.setParentInterpolator(parent);
        Assertions.assertSame((Object)parent, (Object)config.getInterpolator().getParentInterpolator());
        Assertions.assertSame((Object)ci, (Object)config.getInterpolator());
    }

    @Test
    public void testSetParentInterpolatorNoInterpolator() {
        ConfigurationInterpolator parent = (ConfigurationInterpolator)Mockito.mock(ConfigurationInterpolator.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setParentInterpolator(parent);
        Assertions.assertSame((Object)parent, (Object)config.getInterpolator().getParentInterpolator());
    }

    @Test
    public void testSetPrefixLookupsExistingInterpolator() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        int count = config.getInterpolator().getLookups().size();
        HashMap<String, Lookup> lookups = new HashMap<String, Lookup>();
        lookups.put("test", look);
        config.setPrefixLookups(lookups);
        Map lookups2 = config.getInterpolator().getLookups();
        Assertions.assertEquals((int)(count + 1), (int)lookups2.size());
        Assertions.assertSame((Object)look, lookups2.get("test"));
    }

    @Test
    public void testSetPrefixLookupsNoInterpolator() {
        Lookup look = (Lookup)Mockito.mock(Lookup.class);
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        config.setInterpolator(null);
        config.setPrefixLookups(Collections.singletonMap("test", look));
        Map lookups = config.getInterpolator().getLookups();
        Assertions.assertEquals((int)1, (int)lookups.size());
        Assertions.assertSame((Object)look, lookups.get("test"));
    }

    @Test
    public void testSizeInternal() {
        TestConfigurationImpl config = new TestConfigurationImpl((AbstractConfiguration)new PropertiesConfiguration());
        for (int i = 0; i < 12; ++i) {
            config.addProperty(KEY_PREFIX + i, "value" + i);
        }
        Assertions.assertEquals((int)12, (int)config.size());
    }

    private static final class CollectingConfigurationListener
    implements EventListener<ConfigurationEvent> {
        private final List<ConfigurationEvent> events = new ArrayList<ConfigurationEvent>();

        private CollectingConfigurationListener() {
        }

        public void onEvent(ConfigurationEvent event) {
            this.events.add(event);
        }
    }

    static class TestConfigurationImpl
    extends AbstractConfiguration {
        private final AbstractConfiguration config;

        public TestConfigurationImpl(AbstractConfiguration wrappedConfig) {
            this.config = wrappedConfig;
        }

        protected void addPropertyDirect(String key, Object value) {
            this.config.addPropertyDirect(key, value);
        }

        protected void clearPropertyDirect(String key) {
            this.config.clearPropertyDirect(key);
        }

        protected boolean containsKeyInternal(String key) {
            return this.config.containsKey(key);
        }

        protected boolean containsValueInternal(Object value) {
            return this.config.containsValue(value);
        }

        protected Iterator<String> getKeysInternal() {
            return this.config.getKeys();
        }

        protected Object getPropertyInternal(String key) {
            return this.config.getProperty(key);
        }

        public AbstractConfiguration getUnderlyingConfiguration() {
            return this.config;
        }

        protected boolean isEmptyInternal() {
            return this.config.isEmpty();
        }
    }
}

