/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.CopyObjectDefaultHandler;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.HierarchicalBuilderParametersImpl;
import org.apache.commons.configuration2.builder.XMLBuilderParametersImpl;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCopyObjectDefaultHandler {
    @Test
    public void testInitializeDefaultsBaseType() {
        Long refresh = 50000L;
        XMLBuilderParametersImpl paramsXml = new XMLBuilderParametersImpl();
        paramsXml.setValidating(true).setExpressionEngine((ExpressionEngine)Mockito.mock(ExpressionEngine.class)).setReloadingRefreshDelay(refresh);
        CopyObjectDefaultHandler handler = new CopyObjectDefaultHandler((BuilderParameters)paramsXml);
        FileBasedBuilderParametersImpl paramsFb = new FileBasedBuilderParametersImpl();
        handler.initializeDefaults((Object)paramsFb);
        Assertions.assertEquals((Long)refresh, (Long)paramsFb.getReloadingRefreshDelay());
    }

    @Test
    public void testInitializeDefaultsException() {
        ExpressionEngine engine = (ExpressionEngine)Mockito.mock(ExpressionEngine.class);
        XMLBuilderParametersImpl source = new XMLBuilderParametersImpl();
        source.setExpressionEngine(engine);
        XMLBuilderParametersImpl dest = new XMLBuilderParametersImpl(){

            public HierarchicalBuilderParametersImpl setExpressionEngine(ExpressionEngine engine) {
                throw new ConfigurationRuntimeException("Test exception");
            }
        };
        CopyObjectDefaultHandler handler = new CopyObjectDefaultHandler((BuilderParameters)source);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> handler.initializeDefaults((Object)dest));
    }

    @Test
    public void testInitializeDefaultsSameType() {
        Long refresh = 50000L;
        FileBasedBuilderParametersImpl source = new FileBasedBuilderParametersImpl();
        source.setReloadingRefreshDelay(refresh).setThrowExceptionOnMissing(true);
        CopyObjectDefaultHandler handler = new CopyObjectDefaultHandler((BuilderParameters)source);
        FileBasedBuilderParametersImpl copy = new FileBasedBuilderParametersImpl();
        handler.initializeDefaults((Object)copy);
        Map map = copy.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
        Assertions.assertEquals((Long)refresh, (Long)copy.getReloadingRefreshDelay());
    }

    @Test
    public void testInitNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CopyObjectDefaultHandler(null));
    }
}

