/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.SynchronizerTestImpl;
import org.apache.commons.configuration2.TempDirUtils;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.sync.ReadWriteSynchronizer;
import org.apache.commons.configuration2.sync.Synchronizer;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestINIConfiguration {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String INI_DATA = "[section1]" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + "var2 = 451" + LINE_SEPARATOR + LINE_SEPARATOR + "[section2]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR + "var2 = bar" + LINE_SEPARATOR + LINE_SEPARATOR + "[section3]" + LINE_SEPARATOR + "var1 = true" + LINE_SEPARATOR + "interpolated = ${section3.var1}" + LINE_SEPARATOR + "multi = foo" + LINE_SEPARATOR + "multi = bar" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA2 = "[section4]" + LINE_SEPARATOR + "var1 = \"quoted value\"" + LINE_SEPARATOR + "var2 = \"quoted value\\nwith \\\"quotes\\\"\"" + LINE_SEPARATOR + "var3 = 123 ; comment" + LINE_SEPARATOR + "var4 = \"1;2;3\" ; comment" + LINE_SEPARATOR + "var5 = '\\'quoted\\' \"value\"' ; comment" + LINE_SEPARATOR + "var6 = \"\"" + LINE_SEPARATOR;
    private static final String INI_DATA3 = "[section5]" + LINE_SEPARATOR + "multiLine = one \\" + LINE_SEPARATOR + "    two      \\" + LINE_SEPARATOR + " three" + LINE_SEPARATOR + "singleLine = C:\\Temp\\" + LINE_SEPARATOR + "multiQuoted = one \\" + LINE_SEPARATOR + "\"  two  \" \\" + LINE_SEPARATOR + "  three" + LINE_SEPARATOR + "multiComment = one \\ ; a comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "multiQuotedComment = \" one \" \\ ; comment" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "noFirstLine = \\" + LINE_SEPARATOR + "  line 2" + LINE_SEPARATOR + "continueNoLine = one \\" + LINE_SEPARATOR;
    private static final String INI_DATA4 = "[section6]" + LINE_SEPARATOR + "key1{0}value1" + LINE_SEPARATOR + "key2{0}value2" + LINE_SEPARATOR + LINE_SEPARATOR + "[section7]" + LINE_SEPARATOR + "key3{0}value3" + LINE_SEPARATOR;
    private static final String INI_DATA5 = "[section4]" + LINE_SEPARATOR + "var1 = \"quoted value\"" + LINE_SEPARATOR + "var2 = \"quoted value\\nwith \\\"quotes\\\"\"" + LINE_SEPARATOR + "var3 = 123 # comment" + LINE_SEPARATOR + "var4 = \"1#2;3\" # comment" + LINE_SEPARATOR + "var5 = '\\'quoted\\' \"value\"' # comment" + LINE_SEPARATOR + "var6 = \"\"" + LINE_SEPARATOR;
    private static final String INI_DATA6 = "[section1]; main section" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + LINE_SEPARATOR + "[section11] ; sub-section related to [section1]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR;
    private static final String INI_DATA7 = "[section1]# main section" + LINE_SEPARATOR + "var1 = foo" + LINE_SEPARATOR + LINE_SEPARATOR + "[section11] # sub-section related to [section1]" + LINE_SEPARATOR + "var1 = 123.45" + LINE_SEPARATOR;
    private static final String INI_DATA_SEPARATORS = "[section]" + LINE_SEPARATOR + "var1 = value1" + LINE_SEPARATOR + "var2 : value2" + LINE_SEPARATOR + "var3=value3" + LINE_SEPARATOR + "var4:value4" + LINE_SEPARATOR + "var5 : value=5" + LINE_SEPARATOR + "var:6=value" + LINE_SEPARATOR + "var:7=\"value7\"" + LINE_SEPARATOR + "var:8 =  \"value8\"" + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL_ONLY = "globalVar = testGlobal" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String INI_DATA_GLOBAL = INI_DATA_GLOBAL_ONLY + INI_DATA;
    @TempDir
    public File tempFolder;

    private static void load(INIConfiguration instance, String data) throws ConfigurationException {
        try (StringReader reader = new StringReader(data);){
            instance.read((Reader)reader);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static Stream<Arguments> provideSectionsWithComments() {
        return Stream.of(Arguments.of((Object[])new Object[]{INI_DATA6, false, new String[]{null, "section11] ; sub-section related to [section1"}}), Arguments.of((Object[])new Object[]{INI_DATA7, false, new String[]{null, "section11] # sub-section related to [section1"}}), Arguments.of((Object[])new Object[]{INI_DATA6, true, new String[]{"section1", "section11"}}), Arguments.of((Object[])new Object[]{INI_DATA7, true, new String[]{"section1", "section11"}}));
    }

    private static Stream<Arguments> provideValuesWithComments() {
        return Stream.of(Arguments.of((Object[])new Object[]{INI_DATA2, "section4.var3", "123"}), Arguments.of((Object[])new Object[]{INI_DATA2, "section4.var4", "1;2;3"}), Arguments.of((Object[])new Object[]{INI_DATA2, "section4.var5", "'quoted' \"value\""}), Arguments.of((Object[])new Object[]{INI_DATA5, "section4.var3", "123"}), Arguments.of((Object[])new Object[]{INI_DATA5, "section4.var4", "1#2;3"}), Arguments.of((Object[])new Object[]{INI_DATA5, "section4.var5", "'quoted' \"value\""}));
    }

    private static String saveToString(INIConfiguration config) throws ConfigurationException {
        StringWriter writer = new StringWriter();
        try {
            config.write((Writer)writer);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return writer.toString();
    }

    private static INIConfiguration setUpConfig(String data) throws ConfigurationException {
        return TestINIConfiguration.setUpConfig(data, false);
    }

    private static INIConfiguration setUpConfig(String data, boolean inLineCommentsAllowed) throws ConfigurationException {
        INIConfiguration instance = INIConfiguration.builder().setSectionInLineCommentsAllowed(inLineCommentsAllowed).build();
        instance.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        TestINIConfiguration.load(instance, data);
        return instance;
    }

    private void checkContent(INIConfiguration instance) {
        Assertions.assertEquals((Object)"foo", (Object)instance.getString("section1.var1"));
        Assertions.assertEquals((int)451, (int)instance.getInt("section1.var2"));
        Assertions.assertEquals((double)123.45, (double)instance.getDouble("section2.var1"), (double)0.001);
        Assertions.assertEquals((Object)"bar", (Object)instance.getString("section2.var2"));
        Assertions.assertTrue((boolean)instance.getBoolean("section3.var1"));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("section1", "section2", "section3")), (Object)instance.getSections());
    }

    private void checkLoad(String data) throws ConfigurationException {
        INIConfiguration instance = TestINIConfiguration.setUpConfig(data);
        this.checkContent(instance);
    }

    private void checkSave(String content) throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(content);
        String sOutput = TestINIConfiguration.saveToString(config);
        Assertions.assertEquals((Object)content, (Object)sOutput);
    }

    private void checkSectionNames(INIConfiguration config, String[] expected) {
        Set sectionNames = config.getSections();
        Assertions.assertEquals(new HashSet<String>(Arrays.asList(expected)), (Object)sectionNames);
    }

    private INIConfiguration checkSectionNames(String data, String[] expected) throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        this.checkSectionNames(config, expected);
        return config;
    }

    @Test
    public void testCommentLeadingSeparatorUsedInINIInput() throws Exception {
        String inputCommentLeadingSeparator = ";";
        String input = "[section]" + LINE_SEPARATOR + "key1=a;b;c" + LINE_SEPARATOR + "key2=a#b#c" + LINE_SEPARATOR + ";key3=value3" + LINE_SEPARATOR + "#key4=value4" + LINE_SEPARATOR;
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setCommentLeadingCharsUsedInInput(";")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        Assertions.assertEquals((Object)"a;b;c", (Object)instance.getString("section.key1"));
        Assertions.assertEquals((Object)"a#b#c", (Object)instance.getString("section.key2"));
        Assertions.assertNull((Object)instance.getString("section.;key3"));
        Assertions.assertEquals((Object)"value4", (Object)instance.getString("section.#key4"));
    }

    @Test
    public void testEmptySection() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig("[]" + LINE_SEPARATOR + "key=value" + LINE_SEPARATOR);
        String value = config.getString(" .key");
        Assertions.assertEquals((Object)"value", (Object)value);
    }

    @Test
    public void testExpressionEngineIgnoringCase() throws ConfigurationException {
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, (NodeMatcher)NodeNameMatchers.EQUALS_IGNORE_CASE);
        INIConfiguration config = new INIConfiguration();
        config.setExpressionEngine((ExpressionEngine)engine);
        TestINIConfiguration.load(config, INI_DATA);
        this.checkContent(config);
        Assertions.assertEquals((Object)"foo", (Object)config.getString("Section1.var1"));
        Assertions.assertEquals((Object)"foo", (Object)config.getString("section1.Var1"));
        Assertions.assertEquals((Object)"foo", (Object)config.getString("SECTION1.VAR1"));
    }

    @Test
    public void testGetPropertyNoKey() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "= noKey" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        Assertions.assertEquals((Object)"noKey", (Object)config.getString("section4. "));
    }

    @Test
    public void testGetPropertyNoValue() throws ConfigurationException {
        String data = INI_DATA2 + LINE_SEPARATOR + "noValue =" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        Assertions.assertEquals((Object)"", (Object)config.getString("section4.noValue"));
    }

    @Test
    public void testGetSectionConnected() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("section1");
        section.setProperty("var1", (Object)"foo2");
        Assertions.assertEquals((Object)"foo2", (Object)config.getString("section1.var1"));
    }

    @Test
    public void testGetSectionDuplicate() {
        INIConfiguration config = new INIConfiguration();
        config.addProperty("section.var1", (Object)"value1");
        config.addProperty("section(-1).var2", (Object)"value2");
        SubnodeConfiguration section = config.getSection("section");
        Iterator keys = section.getKeys();
        Assertions.assertEquals((Object)"var1", keys.next());
        Assertions.assertFalse((boolean)keys.hasNext());
    }

    @Test
    public void testGetSectionExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("section1");
        Assertions.assertEquals((Object)"foo", (Object)section.getString("var1"));
        Assertions.assertEquals((Object)"451", (Object)section.getString("var2"));
    }

    @Test
    public void testGetSectionGloabalMultiThreaded() throws ConfigurationException, InterruptedException {
        int i;
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        config.setSynchronizer((Synchronizer)new ReadWriteSynchronizer());
        int threadCount = 10;
        GlobalSectionTestThread[] threads = new GlobalSectionTestThread[10];
        for (i = 0; i < 10; ++i) {
            threads[i] = new GlobalSectionTestThread(config);
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
            Assertions.assertFalse((boolean)threads[i].error);
        }
    }

    @Test
    public void testGetSectionGlobal() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration section = config.getSection(null);
        Assertions.assertEquals((Object)"testGlobal", (Object)section.getString("globalVar"));
    }

    @Test
    public void testGetSectionGlobalNonExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection(null);
        Assertions.assertTrue((boolean)section.isEmpty());
    }

    @Test
    public void testGetSectionMerged() throws ConfigurationException {
        String data = INI_DATA + "[section1]" + LINE_SEPARATOR + "var3 = merged" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        SubnodeConfiguration section = config.getSection("section1");
        Assertions.assertEquals((Object)"foo", (Object)section.getString("var1"));
        Assertions.assertEquals((Object)"451", (Object)section.getString("var2"));
        Assertions.assertEquals((Object)"merged", (Object)section.getString("var3"));
    }

    @Test
    public void testGetSectionNonExisting() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("Non existing section");
        Assertions.assertTrue((boolean)section.isEmpty());
    }

    @Test
    public void testGetSectionNonExistingManipulate() throws ConfigurationException, IOException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SubnodeConfiguration section = config.getSection("newSection");
        section.addProperty("test", (Object)"success");
        Assertions.assertEquals((Object)"success", (Object)config.getString("newSection.test"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(writer.toString());
        section = config2.getSection("newSection");
        Assertions.assertEquals((Object)"success", (Object)section.getString("test"));
    }

    @Test
    public void testGetSections() {
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("test1.foo", (Object)"bar");
        instance.addProperty("test2.foo", (Object)"abc");
        HashSet<String> expResult = new HashSet<String>();
        expResult.add("test1");
        expResult.add("test2");
        Set result = instance.getSections();
        Assertions.assertEquals(expResult, (Object)result);
    }

    @Test
    public void testGetSectionsAdded() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        config.addProperty("section5.test", (Object)Boolean.TRUE);
        this.checkSectionNames(config, new String[]{"section4", "section5"});
    }

    @Test
    public void testGetSectionsDottedVar() throws ConfigurationException {
        String data = "dotted.var = 1" + LINE_SEPARATOR + INI_DATA_GLOBAL;
        INIConfiguration config = this.checkSectionNames(data, new String[]{null, "section1", "section2", "section3"});
        Assertions.assertEquals((int)1, (int)config.getInt("dotted..var"));
    }

    @Test
    public void testGetSectionsGlobalOnly() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL_ONLY, new String[]{null});
    }

    @Test
    public void testGetSectionsNoGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA, new String[]{"section1", "section2", "section3"});
    }

    @Test
    public void testGetSectionsSynchronized() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA);
        SynchronizerTestImpl sync = new SynchronizerTestImpl();
        config.setSynchronizer((Synchronizer)sync);
        Assertions.assertFalse((boolean)config.getSections().isEmpty());
        sync.verify(SynchronizerTestImpl.Methods.BEGIN_READ, SynchronizerTestImpl.Methods.END_READ);
    }

    @Test
    public void testGetSectionsWithGlobal() throws ConfigurationException {
        this.checkSectionNames(INI_DATA_GLOBAL, new String[]{null, "section1", "section2", "section3"});
    }

    @ParameterizedTest
    @MethodSource(value={"provideSectionsWithComments"})
    public void testGetSectionsWithInLineComment(String source, boolean allowComments, String[] results) throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(source, allowComments);
        this.checkSectionNames(config, results);
    }

    @Test
    public void testGlobalProperty() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        Assertions.assertEquals((Object)"testGlobal", (Object)config.getString("globalVar"));
    }

    @Test
    public void testGlobalSectionConnected() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        config.setProperty("globalVar", (Object)"changed");
        Assertions.assertEquals((Object)"changed", (Object)sub.getString("globalVar"));
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildByIndex() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        ImmutableNode rootNode = (ImmutableNode)handler.getRootNode();
        ImmutableNode child = (ImmutableNode)handler.getChild((Object)rootNode, 0);
        Assertions.assertEquals((Object)"globalVar", (Object)child.getNodeName());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> handler.getChild((Object)rootNode, 1));
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildrenByName() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        Assertions.assertTrue((boolean)handler.getChildren((Object)((ImmutableNode)sub.getModel().getNodeHandler().getRootNode()), "section1").isEmpty());
    }

    @Test
    public void testGlobalSectionNodeHandlerGetChildrenCount() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        Assertions.assertEquals((int)1, (int)handler.getChildrenCount((Object)((ImmutableNode)handler.getRootNode()), null));
    }

    @Test
    public void testGlobalSectionNodeHandlerIndexOfChild() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        NodeHandler handler = sub.getModel().getNodeHandler();
        List children = ((ImmutableNode)handler.getRootNode()).getChildren();
        Assertions.assertEquals((int)0, (int)handler.indexOfChild((Object)((ImmutableNode)handler.getRootNode()), (Object)((ImmutableNode)children.get(0))));
        Assertions.assertEquals((int)-1, (int)handler.indexOfChild((Object)((ImmutableNode)handler.getRootNode()), (Object)((ImmutableNode)children.get(1))));
    }

    @Test
    public void testIsCommentLine() {
        INIConfiguration instance = new INIConfiguration();
        Assertions.assertTrue((boolean)instance.isCommentLine("#comment1"));
        Assertions.assertTrue((boolean)instance.isCommentLine(";comment1"));
        Assertions.assertFalse((boolean)instance.isCommentLine("nocomment=true"));
        Assertions.assertFalse((boolean)instance.isCommentLine(null));
    }

    @Test
    public void testIsSectionLine() {
        INIConfiguration instance = new INIConfiguration();
        Assertions.assertTrue((boolean)instance.isSectionLine("[section]"));
        Assertions.assertFalse((boolean)instance.isSectionLine("nosection=true"));
        Assertions.assertFalse((boolean)instance.isSectionLine(null));
    }

    @Test
    public void testKeysOfGlobalSection() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_GLOBAL);
        SubnodeConfiguration sub = config.getSection(null);
        Iterator keys = sub.getKeys();
        Assertions.assertEquals((Object)"globalVar", keys.next());
        if (keys.hasNext()) {
            StringBuilder buf = new StringBuilder();
            do {
                buf.append((String)keys.next()).append(' ');
            } while (keys.hasNext());
            Assertions.fail((String)("Got additional keys: " + buf));
        }
    }

    @Test
    public void testLineContinuation() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)("one" + LINE_SEPARATOR + "two" + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiLine"));
    }

    @Test
    public void testLineContinuationAtEnd() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)("one" + LINE_SEPARATOR), (Object)config.getString("section5.continueNoLine"));
    }

    @Test
    public void testLineContinuationComment() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)("one" + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiComment"));
    }

    @Test
    public void testLineContinuationEmptyLine() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)(LINE_SEPARATOR + "line 2"), (Object)config.getString("section5.noFirstLine"));
    }

    @Test
    public void testLineContinuationNone() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)"C:\\Temp\\", (Object)config.getString("section5.singleLine"));
    }

    @Test
    public void testLineContinuationQuoted() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)("one" + LINE_SEPARATOR + "  two  " + LINE_SEPARATOR + "three"), (Object)config.getString("section5.multiQuoted"));
    }

    @Test
    public void testLineContinuationQuotedComment() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA3);
        Assertions.assertEquals((Object)(" one " + LINE_SEPARATOR + "two"), (Object)config.getString("section5.multiQuotedComment"));
    }

    @Test
    public void testListDelimiterHandling() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        config.addProperty("list", (Object)"a,b,c");
        config.addProperty("listesc", (Object)"3\\,1415");
        String output = TestINIConfiguration.saveToString(config);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(output);
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)config2.getList("list"));
        Assertions.assertEquals((Object)"3,1415", (Object)config2.getString("listesc"));
    }

    @Test
    public void testListDelimiterHandlingInList() throws ConfigurationException {
        String data = INI_DATA + "[sectest]" + LINE_SEPARATOR + "list = 3\\,1415,pi,\\\\Test\\,5" + LINE_SEPARATOR;
        INIConfiguration config = TestINIConfiguration.setUpConfig(data);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(TestINIConfiguration.saveToString(config));
        List list = config2.getList("sectest.list");
        Assertions.assertEquals(Arrays.asList("3,1415", "pi", "\\Test,5"), (Object)list);
    }

    @Test
    public void testListParsingDisabled() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        TestINIConfiguration.load(config, "[test]" + LINE_SEPARATOR + "nolist=1,2,3");
        Assertions.assertEquals((Object)"1,2,3", (Object)config.getString("test.nolist"));
    }

    @Test
    public void testLoad() throws Exception {
        this.checkLoad(INI_DATA);
    }

    @Test
    public void testLoadAlternativeSeparator() throws Exception {
        this.checkLoad(INI_DATA.replace('=', ':'));
    }

    @Test
    public void testLoadFromBuilder() throws ConfigurationException, IOException {
        File file = this.writeTestFile(INI_DATA);
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(INIConfiguration.class);
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(file)});
        INIConfiguration config = (INIConfiguration)builder.getConfiguration();
        this.checkContent(config);
    }

    @Test
    public void testMergeDuplicateSection() throws ConfigurationException, IOException {
        String data = "[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[section]\nvar1 = sec1\n\n[section]\nvar2 = sec2\n");
        Assertions.assertEquals((Object)"sec1", (Object)config.getString("section.var1"));
        Assertions.assertEquals((Object)"sec2", (Object)config.getString("section.var2"));
        SubnodeConfiguration sub = config.getSection("section");
        Assertions.assertEquals((Object)"sec1", (Object)sub.getString("var1"));
        Assertions.assertEquals((Object)"sec2", (Object)sub.getString("var2"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        String content = writer.toString();
        int pos = content.indexOf("[section]");
        Assertions.assertTrue((pos >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((content.indexOf("[section]", pos + 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultipleSeparators() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assertions.assertEquals((Object)"value=5", (Object)config.getString("section.var5"));
        Assertions.assertEquals((Object)"6=value", (Object)config.getString("section.var"));
    }

    @Test
    public void testMultipleSeparatorsQuoted() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        Assertions.assertEquals((Object)"value7", (Object)config.getString("section.var:7"));
        Assertions.assertEquals((Object)"value8", (Object)config.getString("section.var:8"));
    }

    @Test
    public void testPropertyWithDelimiter() throws ConfigurationException {
        String data = INI_DATA + "key.dot = dotValue";
        INIConfiguration conf = new INIConfiguration();
        TestINIConfiguration.load(conf, data);
        Assertions.assertEquals((Object)"dotValue", (Object)conf.getString("section3.key..dot"));
        String output = TestINIConfiguration.saveToString(conf);
        MatcherAssert.assertThat((Object)output, (Matcher)CoreMatchers.containsString((String)"key.dot = dotValue"));
    }

    @Test
    public void testQuotedValue() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assertions.assertEquals((Object)"quoted value", (Object)config.getString("section4.var1"));
    }

    @Test
    public void testQuotedValueEmpty() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assertions.assertEquals((Object)"", (Object)config.getString("section4.var6"));
    }

    @Test
    public void testQuotedValueWithComment() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assertions.assertEquals((Object)"1;2;3", (Object)config.getString("section4.var4"));
    }

    @Test
    public void testQuotedValueWithQuotes() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assertions.assertEquals((Object)"quoted value\\nwith \"quotes\"", (Object)config.getString("section4.var2"));
    }

    @Test
    public void testQuotedValueWithSingleQuotes() throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA2);
        Assertions.assertEquals((Object)"'quoted' \"value\"", (Object)config.getString("section4.var5"));
    }

    @Test
    public void testQuotedValueWithWhitespace() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \"";
        INIConfiguration config = TestINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \"");
        Assertions.assertEquals((Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testQuotedValueWithWhitespaceAndComment() throws Exception {
        String content = "CmdPrompt = \" [test@cmd ~]$ \" ; a comment";
        INIConfiguration config = TestINIConfiguration.setUpConfig("CmdPrompt = \" [test@cmd ~]$ \" ; a comment");
        Assertions.assertEquals((Object)" [test@cmd ~]$ ", (Object)config.getString("CmdPrompt"));
    }

    @Test
    public void testSave() throws Exception {
        StringWriter writer = new StringWriter();
        INIConfiguration instance = new INIConfiguration();
        instance.addProperty("section1.var1", (Object)"foo");
        instance.addProperty("section1.var2", (Object)"451");
        instance.addProperty("section2.var1", (Object)"123.45");
        instance.addProperty("section2.var2", (Object)"bar");
        instance.addProperty("section3.var1", (Object)"true");
        instance.addProperty("section3.interpolated", (Object)"${section3.var1}");
        instance.addProperty("section3.multi", (Object)"foo");
        instance.addProperty("section3.multi", (Object)"bar");
        instance.write((Writer)writer);
        Assertions.assertEquals((Object)INI_DATA, (Object)((Object)writer).toString());
    }

    @Test
    public void testSaveClearedSection() throws ConfigurationException, IOException {
        String data = "[section]\ntest = failed\n";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[section]\ntest = failed\n");
        SubnodeConfiguration sub = config.getSection("section");
        Assertions.assertFalse((boolean)sub.isEmpty());
        sub.clear();
        sub.close();
        sub = config.getSection("section");
        sub.setProperty("test", (Object)"success");
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = TestINIConfiguration.setUpConfig(writer.toString());
        Assertions.assertEquals((Object)"success", (Object)config2.getString("section.test"));
    }

    @Test
    public void testSaveKeysWithDelimiters() throws ConfigurationException, IOException {
        INIConfiguration conf = new INIConfiguration();
        String section = "Section..with..dots";
        conf.addProperty("Section..with..dots.test1", (Object)"test1");
        conf.addProperty("Section..with..dots.test2", (Object)"test2");
        StringWriter writer = new StringWriter();
        conf.write((Writer)writer);
        conf = new INIConfiguration();
        conf.read((Reader)new StringReader(writer.toString()));
        Assertions.assertEquals((Object)"test1", (Object)conf.getString("Section..with..dots.test1"));
        Assertions.assertEquals((Object)"test2", (Object)conf.getString("Section..with..dots.test2"));
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        INIConfiguration config = new INIConfiguration();
        String data = INI_DATA.substring(0, INI_DATA.length() - LINE_SEPARATOR.length()) + "nolist = 1,2, 3";
        TestINIConfiguration.load(config, data);
        Assertions.assertEquals((Object)"1,2, 3", (Object)config.getString("section3.nolist"));
        String content = TestINIConfiguration.saveToString(config);
        INIConfiguration config2 = new INIConfiguration();
        TestINIConfiguration.load(config2, content);
        Assertions.assertEquals((Object)"1,2, 3", (Object)config2.getString("section3.nolist"));
    }

    @Test
    public void testSaveWithGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL);
    }

    @Test
    public void testSaveWithOnlyGlobalSection() throws ConfigurationException {
        this.checkSave(INI_DATA_GLOBAL_ONLY);
    }

    @Test
    public void testSeparators() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig(INI_DATA_SEPARATORS);
        for (int i = 1; i <= 4; ++i) {
            Assertions.assertEquals((Object)("value" + i), (Object)config.getString("section.var" + i));
        }
    }

    @Test
    public void testSeparatorUsedInINIInput() throws Exception {
        String inputSeparator = "=";
        String input = "[section]" + LINE_SEPARATOR + "k1:v1$key1=value1" + LINE_SEPARATOR + "k1:v1,k2:v2$key2=value2" + LINE_SEPARATOR + "key3:value3" + LINE_SEPARATOR + "key4 = value4" + LINE_SEPARATOR;
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setSeparatorUsedInInput("=")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        Assertions.assertEquals((Object)"value1", (Object)instance.getString("section.k1:v1$key1"));
        Assertions.assertEquals((Object)"value2", (Object)instance.getString("section.k1:v1,k2:v2$key2"));
        Assertions.assertEquals((Object)"", (Object)instance.getString("section.key3:value3"));
        Assertions.assertEquals((Object)"value4", (Object)instance.getString("section.key4").trim());
    }

    @Test
    public void testSeparatorUsedInINIOutput() throws Exception {
        String outputSeparator = ": ";
        String input = MessageFormat.format(INI_DATA4, "=").trim();
        String expectedOutput = MessageFormat.format(INI_DATA4, ": ").trim();
        INIConfiguration instance = (INIConfiguration)new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().ini().setSeparatorUsedInOutput(": ")}).getConfiguration();
        TestINIConfiguration.load(instance, input);
        StringWriter writer = new StringWriter();
        instance.write((Writer)writer);
        String result = ((Object)writer).toString().trim();
        Assertions.assertEquals((Object)expectedOutput, (Object)result);
    }

    @ParameterizedTest
    @MethodSource(value={"provideValuesWithComments"})
    public void testValueWithComment(String source, String key, String value) throws Exception {
        INIConfiguration config = TestINIConfiguration.setUpConfig(source);
        Assertions.assertEquals((Object)value, (Object)config.getString(key));
    }

    @Test
    public void testValueWithDelimiters() throws ConfigurationException {
        INIConfiguration config = TestINIConfiguration.setUpConfig("[test]" + LINE_SEPARATOR + "list=1,2,3" + LINE_SEPARATOR);
        List list = config.getList("test.list");
        Assertions.assertEquals(Arrays.asList("1", "2", "3"), (Object)list);
    }

    @Test
    public void testValueWithSemicolon() throws ConfigurationException {
        String path = "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar";
        String content = "[Environment]" + LINE_SEPARATOR + "Application Type=any" + LINE_SEPARATOR + "Class Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "  ;comment" + LINE_SEPARATOR + "Path=" + "C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar" + "\t; another comment";
        INIConfiguration config = TestINIConfiguration.setUpConfig(content);
        Assertions.assertEquals((Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Class Path"));
        Assertions.assertEquals((Object)"C:\\Program Files\\jar\\manage.jar;C:\\Program Files\\jar\\guiLauncher.jar", (Object)config.getString("Environment.Path"));
    }

    @Test
    public void testWriteEmptySection() throws ConfigurationException, IOException {
        String section = "[EmptySection]";
        INIConfiguration config = TestINIConfiguration.setUpConfig("[EmptySection]");
        Assertions.assertEquals(Collections.singleton("EmptySection"), (Object)config.getSections());
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        Assertions.assertEquals((Object)("[EmptySection]" + LINE_SEPARATOR + LINE_SEPARATOR), (Object)writer.toString());
    }

    @Test
    public void testWriteValueWithCommentChar() throws Exception {
        INIConfiguration config = new INIConfiguration();
        config.setProperty("section.key1", (Object)"1;2;3");
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        INIConfiguration config2 = new INIConfiguration();
        config2.read((Reader)new StringReader(writer.toString()));
        Assertions.assertEquals((Object)"1;2;3", (Object)config2.getString("section.key1"));
    }

    private File writeTestFile(String content) throws IOException {
        File file = TempDirUtils.newFile(this.tempFolder);
        try (PrintWriter out = new PrintWriter(new FileWriter(file));){
            out.println(content);
        }
        return file;
    }

    private static final class GlobalSectionTestThread
    extends Thread {
        private final INIConfiguration config;
        private volatile boolean error;

        public GlobalSectionTestThread(INIConfiguration conf) {
            this.config = conf;
        }

        @Override
        public void run() {
            int loopCount = 250;
            for (int i = 0; i < 250 && !this.error; ++i) {
                try {
                    this.config.getSection(null);
                    continue;
                }
                catch (IllegalStateException istex) {
                    this.error = true;
                }
            }
        }
    }
}

