/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFileLocator {
    private static final String FILE_NAME = "test.xml";
    private static final String BASE_PATH = "/etc/test/path/";
    private static final String ENCODING = StandardCharsets.UTF_8.name();
    private static URL sourceURL;
    private static FileSystem fileSystem;
    private static FileLocationStrategy locationStrategy;

    private static void checkLocator(FileLocator locator) {
        Assertions.assertEquals((Object)BASE_PATH, (Object)locator.getBasePath());
        Assertions.assertEquals((Object)FILE_NAME, (Object)locator.getFileName());
        Assertions.assertEquals((Object)ENCODING, (Object)locator.getEncoding());
        Assertions.assertEquals((Object)sourceURL.toExternalForm(), (Object)locator.getSourceURL().toExternalForm());
        Assertions.assertSame((Object)fileSystem, (Object)locator.getFileSystem());
        Assertions.assertSame((Object)locationStrategy, (Object)locator.getLocationStrategy());
    }

    @BeforeAll
    public static void setUpOnce() throws Exception {
        sourceURL = ConfigurationAssert.getTestURL(FILE_NAME);
        fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        locationStrategy = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
    }

    @Test
    public void testCreateFileLocator() {
        FileLocator locator = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        TestFileLocator.checkLocator(locator);
    }

    @Test
    public void testCreateFileLocatorFromSource() {
        FileLocator locatorSrc = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName("someFile").encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        FileLocator locator = FileLocatorUtils.fileLocator((FileLocator)locatorSrc).fileName(FILE_NAME).create();
        TestFileLocator.checkLocator(locator);
    }

    @Test
    public void testCreateFileLocatorUndefined() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assertions.assertNull((Object)locator.getBasePath());
        Assertions.assertNull((Object)locator.getFileName());
        Assertions.assertNull((Object)locator.getSourceURL());
        Assertions.assertNull((Object)locator.getEncoding());
        Assertions.assertNull((Object)locator.getFileSystem());
        Assertions.assertNull((Object)locator.getLocationStrategy());
    }

    @Test
    public void testFileLocatorEqualsFalse() {
        FileLocator loc1 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        FileLocator loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).basePath("/etc/test/path/_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).fileName("test.xml_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).encoding(ENCODING + "_other").create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).fileSystem((FileSystem)Mockito.mock(FileSystem.class)).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).sourceURL(ConfigurationAssert.getTestURL("test.properties")).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
        loc2 = FileLocatorUtils.fileLocator((FileLocator)loc1).locationStrategy((FileLocationStrategy)Mockito.mock(FileLocationStrategy.class)).create();
        ConfigurationAssert.checkEquals(loc1, loc2, false);
    }

    @Test
    public void testFileLocatorEqualsNull() {
        FileLocator loc = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assertions.assertNotEquals(null, (Object)loc);
    }

    @Test
    public void testFileLocatorEqualsOtherClass() {
        FileLocator loc = FileLocatorUtils.fileLocator().fileName(FILE_NAME).create();
        Assertions.assertNotEquals((Object)loc, (Object)this);
    }

    @Test
    public void testFileLocatorEqualsTrue() {
        FileLocator loc1 = FileLocatorUtils.fileLocator().create();
        ConfigurationAssert.checkEquals(loc1, loc1, true);
        FileLocator loc2 = FileLocatorUtils.fileLocator().create();
        ConfigurationAssert.checkEquals(loc1, loc2, true);
        loc1 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        loc2 = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        ConfigurationAssert.checkEquals(loc1, loc2, true);
    }

    @Test
    public void testFileLocatorToString() {
        FileLocator loc = FileLocatorUtils.fileLocator().basePath(BASE_PATH).fileName(FILE_NAME).encoding(ENCODING).fileSystem(fileSystem).sourceURL(sourceURL).locationStrategy(locationStrategy).create();
        String s = loc.toString();
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"fileName=test.xml"));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"basePath=/etc/test/path/"));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("sourceURL=" + sourceURL)));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("encoding=" + ENCODING)));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("fileSystem=" + fileSystem)));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("locationStrategy=" + locationStrategy)));
    }
}

