/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.io;

import java.io.File;
import java.net.URL;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.io.AbsoluteNameLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAbsoluteNameLocationStrategy {
    private FileSystem fileSystem;
    private AbsoluteNameLocationStrategy strategy;

    @BeforeEach
    public void setUp() throws Exception {
        this.fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        this.strategy = new AbsoluteNameLocationStrategy();
    }

    @Test
    public void testExistingAbsoluteFile() {
        File file = ConfigurationAssert.getTestFile("test.xml");
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(file.getAbsolutePath()).create();
        URL url = this.strategy.locate(this.fileSystem, locator);
        Assertions.assertEquals((Object)file.getAbsoluteFile(), (Object)FileLocatorUtils.fileFromURL((URL)url).getAbsoluteFile());
    }

    @Test
    public void testNoAbsoluteFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().fileName("test.xml").create();
        Assertions.assertNull((Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNoFileName() {
        FileLocator locator = FileLocatorUtils.fileLocator().create();
        Assertions.assertNull((Object)this.strategy.locate(this.fileSystem, locator));
    }

    @Test
    public void testNonExistingAbsoluteFile() {
        File file = ConfigurationAssert.getOutFile("NotExistingFile.tst");
        FileLocator locator = FileLocatorUtils.fileLocator().fileName(file.getAbsolutePath()).create();
        Assertions.assertNull((Object)this.strategy.locate(this.fileSystem, locator));
    }
}

