/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.util.Map;
import javax.naming.Context;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.JndiBuilderParametersImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestJndiBuilderParametersImpl {
    private JndiBuilderParametersImpl params;

    @BeforeEach
    public void setUp() throws Exception {
        this.params = new JndiBuilderParametersImpl();
    }

    @Test
    public void testGetParametersBaseProperties() {
        this.params.setPrefix("somePrefix");
        this.params.setThrowExceptionOnMissing(true);
        Map paramsMap = this.params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, paramsMap.get("throwExceptionOnMissing"));
    }

    @Test
    public void testSetBeanProperties() throws Exception {
        Context ctx = (Context)Mockito.mock(Context.class);
        String prefix = "testJndiPrefix";
        BeanHelper.setProperty((Object)this.params, (String)"context", (Object)ctx);
        BeanHelper.setProperty((Object)this.params, (String)"prefix", (Object)"testJndiPrefix");
        Map paramsMap = this.params.getParameters();
        Assertions.assertSame((Object)ctx, paramsMap.get("context"));
        Assertions.assertEquals((Object)"testJndiPrefix", paramsMap.get("prefix"));
    }

    @Test
    public void testSetContext() {
        Context ctx = (Context)Mockito.mock(Context.class);
        Assertions.assertSame((Object)this.params, (Object)this.params.setContext(ctx));
        Map paramsMap = this.params.getParameters();
        Assertions.assertSame((Object)ctx, paramsMap.get("context"));
    }

    @Test
    public void testSetPrefix() {
        String prefix = "testJndiPrefix";
        Assertions.assertSame((Object)this.params, (Object)this.params.setPrefix("testJndiPrefix"));
        Map paramsMap = this.params.getParameters();
        Assertions.assertEquals((Object)"testJndiPrefix", paramsMap.get("prefix"));
    }
}

