/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEqualBehavior {
    private void checkEquality(String msg, Configuration c1, Configuration c2) {
        Iterator it1 = c1.getKeys();
        Iterator it2 = c2.getKeys();
        while (it1.hasNext() && it2.hasNext()) {
            String key1 = (String)it1.next();
            String key2 = (String)it2.next();
            Assertions.assertEquals((Object)key1, (Object)key2, (String)(msg + ", Keys: "));
            Assertions.assertEquals((Object)c1.containsKey(key1), (Object)c2.containsKey(key2), (String)(msg + ", Contains: "));
        }
        Assertions.assertEquals((Object)it1.hasNext(), (Object)it2.hasNext(), (String)(msg + ", Iterator: "));
    }

    private void checkSameKey(String msg, String key, Configuration c1, Configuration c2) {
        Object[] s1 = c1.getStringArray(key);
        Object[] s2 = c2.getStringArray(key);
        Assertions.assertArrayEquals((Object[])s1, (Object[])s2, (String)(msg + ", String Array: "));
        List list1 = c1.getList(key);
        List list2 = c2.getList(key);
        Assertions.assertEquals((Object)list1, (Object)list2, (String)(msg + ", List: "));
    }

    private Configuration setupCompositeConfiguration() throws ConfigurationException {
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(ConfigurationAssert.getTestFile("testEqualDigester.xml"))});
        return (Configuration)builder.getConfiguration();
    }

    private Configuration setupSimpleConfiguration() throws Exception {
        String simpleConfigurationFile = ConfigurationAssert.getTestFile("testEqual.properties").getAbsolutePath();
        PropertiesConfiguration c = new PropertiesConfiguration();
        FileHandler handler = new FileHandler((FileBased)c);
        handler.setFileName(simpleConfigurationFile);
        handler.load();
        return c;
    }

    @Test
    public void testAddingSet() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "existing.property";
        String value = "new value";
        Assertions.assertTrue((boolean)simple.containsKey("existing.property"));
        Assertions.assertEquals((Object)simple.containsKey("existing.property"), (Object)composite.containsKey("existing.property"));
        simple.addProperty("existing.property", (Object)"new value");
        composite.addProperty("existing.property", (Object)"new value");
        Assertions.assertTrue((boolean)simple.containsKey("existing.property"));
        Assertions.assertEquals((Object)simple.containsKey("existing.property"), (Object)composite.containsKey("existing.property"));
        this.checkSameKey("testAddingSet", "existing.property", simple, composite);
        this.checkEquality("testAddingSet", simple, composite);
    }

    @Test
    public void testAddingUnset() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.property";
        String value = "new value";
        Assertions.assertFalse((boolean)simple.containsKey("nonexisting.property"));
        Assertions.assertEquals((Object)simple.containsKey("nonexisting.property"), (Object)composite.containsKey("nonexisting.property"));
        simple.addProperty("nonexisting.property", (Object)"new value");
        composite.addProperty("nonexisting.property", (Object)"new value");
        this.checkSameKey("testAddingUnset", "nonexisting.property", simple, composite);
        this.checkEquality("testAddingUnset", simple, composite);
    }

    @Test
    public void testDeletingExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "clear.property";
        Assertions.assertTrue((boolean)simple.containsKey("clear.property"));
        Assertions.assertEquals((Object)simple.containsKey("clear.property"), (Object)composite.containsKey("clear.property"));
        simple.clearProperty("clear.property");
        composite.clearProperty("clear.property");
        Assertions.assertFalse((boolean)simple.containsKey("clear.property"));
        Assertions.assertEquals((Object)simple.containsKey("clear.property"), (Object)composite.containsKey("clear.property"));
        this.checkEquality("testDeletingExisting", simple, composite);
    }

    @Test
    public void testDeletingNonExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.clear.property";
        Assertions.assertFalse((boolean)simple.containsKey("nonexisting.clear.property"));
        Assertions.assertEquals((Object)simple.containsKey("nonexisting.clear.property"), (Object)composite.containsKey("nonexisting.clear.property"));
        simple.clearProperty("nonexisting.clear.property");
        composite.clearProperty("nonexisting.clear.property");
        Assertions.assertFalse((boolean)simple.containsKey("nonexisting.clear.property"));
        Assertions.assertEquals((Object)simple.containsKey("nonexisting.clear.property"), (Object)composite.containsKey("nonexisting.clear.property"));
        this.checkEquality("testDeletingNonExisting", simple, composite);
    }

    @Test
    public void testLoading() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        this.checkEquality("testLoading", simple, composite);
    }

    @Test
    public void testSettingExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "existing.property";
        String value = "new value";
        Assertions.assertTrue((boolean)simple.containsKey("existing.property"));
        Assertions.assertNotEquals((Object)"new value", (Object)simple.getString("existing.property"));
        Assertions.assertEquals((Object)simple.containsKey("existing.property"), (Object)composite.containsKey("existing.property"));
        simple.setProperty("existing.property", (Object)"new value");
        composite.setProperty("existing.property", (Object)"new value");
        Assertions.assertTrue((boolean)simple.containsKey("existing.property"));
        Assertions.assertEquals((Object)simple.getString("existing.property"), (Object)"new value");
        Assertions.assertEquals((Object)simple.containsKey("existing.property"), (Object)composite.containsKey("existing.property"));
        this.checkSameKey("testSettingExisting", "existing.property", simple, composite);
        this.checkEquality("testSettingExisting", simple, composite);
    }

    @Test
    public void testSettingNonExisting() throws Exception {
        Configuration simple = this.setupSimpleConfiguration();
        Configuration composite = this.setupCompositeConfiguration();
        String key = "nonexisting.property";
        String value = "new value";
        Assertions.assertFalse((boolean)simple.containsKey("nonexisting.property"));
        Assertions.assertEquals((Object)simple.containsKey("nonexisting.property"), (Object)composite.containsKey("nonexisting.property"));
        simple.setProperty("nonexisting.property", (Object)"new value");
        composite.setProperty("nonexisting.property", (Object)"new value");
        Assertions.assertTrue((boolean)simple.containsKey("nonexisting.property"));
        Assertions.assertEquals((Object)simple.containsKey("nonexisting.property"), (Object)composite.containsKey("nonexisting.property"));
        this.checkSameKey("testSettingNonExisting", "nonexisting.property", simple, composite);
        this.checkEquality("testSettingNonExisting", simple, composite);
    }
}

