/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.ConfigurationLookup;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurationLookup {
    private static final String VAR = "testVariable";
    private static final Object VALUE = "SomeTestValue";

    @Test
    public void testInitNoConfig() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationLookup(null));
    }

    @Test
    public void testLookupComplex() {
        int count = 5;
        BaseConfiguration conf = new BaseConfiguration();
        for (int i = 0; i < 5; ++i) {
            conf.addProperty(VAR, (Object)(String.valueOf(VALUE) + i));
        }
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Collection col = (Collection)lookup.lookup(VAR);
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            expected.add(String.valueOf(VALUE) + i);
        }
        Assertions.assertIterableEquals(expected, (Iterable)col);
    }

    @Test
    public void testLookupNotFound() {
        BaseConfiguration conf = new BaseConfiguration();
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assertions.assertNull((Object)lookup.lookup(VAR));
    }

    @Test
    public void testLookupNotFoundEx() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setThrowExceptionOnMissing(true);
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assertions.assertNull((Object)lookup.lookup(VAR));
    }

    @Test
    public void testLookupSuccess() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.addProperty(VAR, VALUE);
        ConfigurationLookup lookup = new ConfigurationLookup((ImmutableConfiguration)conf);
        Assertions.assertEquals((Object)VALUE, (Object)lookup.lookup(VAR));
    }
}

