/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public final class TempDirUtils {
    private static final String TMP_PREFIX = "junit";

    private TempDirUtils() {
    }

    public static File newFile(File tempFolder) throws IOException {
        return Files.createTempFile(tempFolder.toPath(), TMP_PREFIX, null, new FileAttribute[0]).toFile();
    }

    public static File newFile(String fileName, File tempFolder) throws IOException {
        return Files.createFile(tempFolder.toPath().resolve(fileName), new FileAttribute[0]).toFile();
    }

    public static File newFolder(File tempFolder) throws IOException {
        return Files.createTempDirectory(tempFolder.toPath(), TMP_PREFIX, new FileAttribute[0]).toFile();
    }

    public static File newFolder(String path, File tempFolder) throws IOException {
        return Files.createDirectory(tempFolder.toPath().resolve(path), new FileAttribute[0]).toFile();
    }
}

