/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.DatabaseConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.fluent.DatabaseBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.test.HsqlDB;
import org.apache.commons.dbcp2.BasicDataSource;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DatabaseConfigurationTestHelper {
    public static final String TABLE = "configuration";
    public static final String TABLE_MULTI = "configurations";
    public static final String COL_KEY = "key";
    public static final String COL_VALUE = "value";
    public static final String COL_NAME = "name";
    public static final String CONFIG_NAME = "test";
    public final String DATABASE_DRIVER = "org.hsqldb.jdbcDriver";
    public final String DATABASE_URL = "jdbc:hsqldb:mem:testdb";
    public final String DATABASE_USERNAME = "sa";
    public final String DATABASE_PASSWORD = "";
    private HsqlDB hsqlDB;
    private DataSource datasource;
    private boolean autoCommit;

    public <T extends DatabaseConfiguration> T createConfig(Class<T> configCls, DatabaseBuilderParameters params) throws ConfigurationException {
        return (T)((DatabaseConfiguration)new BasicConfigurationBuilder(configCls).configure(new BuilderParameters[]{params}).getConfiguration());
    }

    public DataSource getDatasource() {
        if (this.datasource == null) {
            try {
                this.datasource = this.setUpDataSource();
            }
            catch (Exception ex) {
                throw new ConfigurationRuntimeException("Could not create data source", (Throwable)ex);
            }
        }
        return this.datasource;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setUp() throws Exception {
        File script = ConfigurationAssert.getTestFile("testdb.script");
        this.hsqlDB = new HsqlDB("jdbc:hsqldb:mem:testdb", "org.hsqldb.jdbcDriver", script.getAbsolutePath());
    }

    public DatabaseConfiguration setUpConfig() throws ConfigurationException {
        return this.setUpConfig(DatabaseConfiguration.class);
    }

    public <T extends DatabaseConfiguration> T setUpConfig(Class<T> configCls) throws ConfigurationException {
        return this.createConfig(configCls, this.setUpDefaultParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource setUpDataSource() throws Exception {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName("org.hsqldb.jdbcDriver");
        ds.setUrl("jdbc:hsqldb:mem:testdb");
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setDefaultAutoCommit(Boolean.valueOf(!this.isAutoCommit()));
        Connection conn = ds.getConnection();
        DatabaseConnection connection = new DatabaseConnection(conn);
        XmlDataSet dataSet = new XmlDataSet((InputStream)new FileInputStream(ConfigurationAssert.getTestFile("dataset.xml")));
        try {
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)connection, (IDataSet)dataSet);
        }
        finally {
            if (!this.isAutoCommit()) {
                conn.commit();
            }
            connection.close();
        }
        return ds;
    }

    public DatabaseBuilderParameters setUpDefaultParameters() {
        return (DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)new Parameters().database().setDataSource(this.getDatasource())).setTable(TABLE)).setKeyColumn(COL_KEY)).setValueColumn(COL_VALUE)).setAutoCommit(this.isAutoCommit());
    }

    public DatabaseConfiguration setUpMultiConfig() throws ConfigurationException {
        return this.setUpMultiConfig(DatabaseConfiguration.class, null);
    }

    public <T extends DatabaseConfiguration> T setUpMultiConfig(Class<T> configCls, String configName) throws ConfigurationException {
        return this.createConfig(configCls, this.setUpMultiParameters(configName));
    }

    public DatabaseBuilderParameters setUpMultiParameters(String configName) {
        return (DatabaseBuilderParameters)((DatabaseBuilderParameters)((DatabaseBuilderParameters)this.setUpDefaultParameters().setTable(TABLE_MULTI)).setConfigurationNameColumn(COL_NAME)).setConfigurationName(configName != null ? configName : CONFIG_NAME);
    }

    public void tearDown() throws Exception {
        if (this.datasource != null) {
            this.datasource.getConnection().close();
        }
        this.hsqlDB.close();
    }
}

