/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder.combined;

import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.builder.combined.ConfigurationDeclaration;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConfigurationDeclaration {
    private static ConfigurationDeclaration createDeclaration(HierarchicalConfiguration<?> conf) {
        BaseHierarchicalConfiguration config = conf != null ? conf : new BaseHierarchicalConfiguration();
        return new ConfigurationDeclaration(null, (HierarchicalConfiguration)config);
    }

    private void checkOldReservedAttribute(String name) {
        String prefixName = "config-" + name;
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty(String.format("[@%s]", prefixName), (Object)Boolean.TRUE);
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(config);
        Assertions.assertTrue((boolean)decl.isReservedAttributeName(prefixName), (String)(prefixName + " attribute not recognized"));
        config.addProperty(String.format("[@%s]", name), (Object)Boolean.TRUE);
        Assertions.assertFalse((boolean)decl.isReservedAttributeName(name), (String)(name + " is reserved though config- exists"));
        Assertions.assertTrue((boolean)decl.isReservedAttributeName(prefixName), (String)("config- attribute not recognized when " + name + " exists"));
    }

    @Test
    public void testConfigurationDeclarationGetAttributes() {
        BaseHierarchicalConfiguration config = new BaseHierarchicalConfiguration();
        config.addProperty("xml.fileName", (Object)"test.xml");
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertNull((Object)decl.getAt());
        Assertions.assertFalse((boolean)decl.isOptional());
        config.addProperty("xml[@config-at]", (Object)"test1");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertEquals((Object)"test1", (Object)decl.getAt());
        config.addProperty("xml[@at]", (Object)"test2");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertEquals((Object)"test1", (Object)decl.getAt());
        config.clearProperty("xml[@config-at]");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertEquals((Object)"test2", (Object)decl.getAt());
        config.addProperty("xml[@config-optional]", (Object)"true");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertTrue((boolean)decl.isOptional());
        config.addProperty("xml[@optional]", (Object)"false");
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertTrue((boolean)decl.isOptional());
        config.clearProperty("xml[@config-optional]");
        config.setProperty("xml[@optional]", (Object)Boolean.TRUE);
        decl = TestConfigurationDeclaration.createDeclaration(config.configurationAt("xml"));
        Assertions.assertTrue((boolean)decl.isOptional());
    }

    @Test
    public void testConfigurationDeclarationIsReserved() {
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(null);
        Assertions.assertTrue((boolean)decl.isReservedAttributeName("at"));
        Assertions.assertTrue((boolean)decl.isReservedAttributeName("optional"));
        Assertions.assertTrue((boolean)decl.isReservedAttributeName("config-class"));
        Assertions.assertFalse((boolean)decl.isReservedAttributeName("different"));
    }

    @Test
    public void testConfigurationDeclarationIsReservedAt() {
        this.checkOldReservedAttribute("at");
    }

    @Test
    public void testConfigurationDeclarationIsReservedOptional() {
        this.checkOldReservedAttribute("optional");
    }

    @Test
    public void testConfigurationDeclarationOptionalAttributeInvalid() {
        BaseHierarchicalConfiguration factory = new BaseHierarchicalConfiguration();
        factory.addProperty("xml.fileName", (Object)"test.xml");
        factory.setProperty("xml[@optional]", (Object)"invalid value");
        ConfigurationDeclaration decl = TestConfigurationDeclaration.createDeclaration(factory.configurationAt("xml"));
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> ((ConfigurationDeclaration)decl).isOptional());
    }
}

