/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.combined.CombinedConfigurationBuilder;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestSubsetConfiguration {
    static final String TEST_DIR = "target/test-classes";
    static final String TEST_FILE = "testDigesterConfiguration2.xml";

    @Test
    public void testClear() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("test.key1", (Object)"value1");
        config.setProperty("testing.key2", (Object)"value1");
        Configuration subset = config.subset("test");
        subset.clear();
        Assertions.assertTrue((boolean)subset.isEmpty());
        Assertions.assertFalse((boolean)config.isEmpty());
    }

    @Test
    public void testGetChildKey() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assertions.assertEquals((Object)"key", (Object)subset.getChildKey("prefix.key"));
        Assertions.assertEquals((Object)"", (Object)subset.getChildKey("prefix"));
        subset = new SubsetConfiguration((Configuration)conf, "prefix", null);
        Assertions.assertEquals((Object)"key", (Object)subset.getChildKey("prefixkey"));
        Assertions.assertEquals((Object)"", (Object)subset.getChildKey("prefix"));
    }

    @Test
    public void testGetKeys() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test", (Object)"value0");
        conf.setProperty("test.key1", (Object)"value1");
        conf.setProperty("testing.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Iterator it = subset.getKeys();
        Assertions.assertEquals((Object)"", it.next());
        Assertions.assertEquals((Object)"key1", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetKeysWithPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test.abc", (Object)"value0");
        conf.setProperty("test.abc.key1", (Object)"value1");
        conf.setProperty("test.abcdef.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Iterator it = subset.getKeys("abc");
        Assertions.assertEquals((Object)"abc", it.next());
        Assertions.assertEquals((Object)"abc.key1", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        conf.setProperty("test.abc", (Object)"value0,value1");
        conf.addProperty("test.abc", (Object)"value3");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        List list = subset.getList("abc", new ArrayList());
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testGetListDelimiterHandlerFromParent() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler(',');
        config.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        Assertions.assertSame((Object)listHandler, (Object)subset.getListDelimiterHandler());
    }

    @Test
    public void testGetParent() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assertions.assertEquals((Object)conf, (Object)subset.getParent());
    }

    @Test
    public void testGetParentKey() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assertions.assertEquals((Object)"prefix.key", (Object)subset.getParentKey("key"));
        Assertions.assertEquals((Object)"prefix", (Object)subset.getParentKey(""));
        subset = new SubsetConfiguration((Configuration)conf, "prefix", null);
        Assertions.assertEquals((Object)"prefixkey", (Object)subset.getParentKey("key"));
        Assertions.assertEquals((Object)"prefix", (Object)subset.getParentKey(""));
    }

    @Test
    public void testGetPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "prefix", ".");
        Assertions.assertEquals((Object)"prefix", (Object)subset.getPrefix());
    }

    @Test
    public void testGetProperty() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("test.key1", (Object)"value1");
        conf.setProperty("testing.key2", (Object)"value1");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertTrue((boolean)subset.containsKey("key1"));
        Assertions.assertFalse((boolean)subset.containsKey("ng.key2"));
    }

    @Test
    public void testInitNoParent() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SubsetConfiguration(null, ""));
    }

    @Test
    public void testInterpolationForKeysOfTheParent() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("test", (Object)"junit");
        config.setProperty("prefix.key", (Object)"${test}");
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        Assertions.assertEquals((Object)"junit", (Object)subset.getString("key", ""));
    }

    @Test
    public void testInterpolator() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        InterpolationTestHelper.testGetInterpolator(subset);
    }

    @Test
    public void testListDelimiterHandling() {
        BaseConfiguration config = new BaseConfiguration();
        Configuration subset = config.subset("prefix");
        config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler('/'));
        subset.addProperty("list", (Object)"a/b/c");
        Assertions.assertEquals((int)3, (int)config.getList("prefix.list").size());
        ((AbstractConfiguration)subset).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        subset.addProperty("list2", (Object)"a;b;c");
        Assertions.assertEquals((int)3, (int)config.getList("prefix.list2").size());
    }

    @Test
    public void testLocalLookupsInInterpolatorAreInherited() {
        BaseConfiguration config = new BaseConfiguration();
        ConfigurationInterpolator interpolator = config.getInterpolator();
        interpolator.registerLookup("brackets", key -> "(" + key + ")");
        config.setProperty("prefix.var", (Object)"${brackets:x}");
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        Assertions.assertEquals((Object)"(x)", (Object)subset.getString("var", ""));
    }

    @Test
    public void testNested() throws Exception {
        CombinedConfigurationBuilder builder = new CombinedConfigurationBuilder();
        builder.configure(new BuilderParameters[]{new FileBasedBuilderParametersImpl().setFile(ConfigurationAssert.getTestFile(TEST_FILE))});
        Configuration config = (Configuration)builder.getConfiguration();
        Configuration subConf = config.subset("tables.table(0)");
        Assertions.assertTrue((boolean)subConf.getKeys().hasNext());
        Configuration subSubConf = subConf.subset("fields.field(1)");
        Iterator itKeys = subSubConf.getKeys();
        HashSet<String> keys = new HashSet<String>();
        keys.add("name");
        keys.add("type");
        while (itKeys.hasNext()) {
            String k = (String)itKeys.next();
            Assertions.assertTrue((boolean)keys.contains(k));
            keys.remove(k);
        }
        Assertions.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    public void testSetListDelimiterHandlerInParent() {
        BaseConfiguration config = new BaseConfiguration();
        AbstractConfiguration subset = (AbstractConfiguration)config.subset("prefix");
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler(',');
        subset.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        Assertions.assertSame((Object)listHandler, (Object)config.getListDelimiterHandler());
    }

    @Test
    public void testSetListDelimiterHandlerParentNotSupported() {
        Configuration config = (Configuration)Mockito.mock(Configuration.class);
        SubsetConfiguration subset = new SubsetConfiguration(config, "prefix");
        DefaultListDelimiterHandler listHandler = new DefaultListDelimiterHandler(',');
        subset.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        Assertions.assertSame((Object)listHandler, (Object)subset.getListDelimiterHandler());
    }

    @Test
    public void testSetPrefix() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, null, ".");
        subset.setPrefix("prefix");
        Assertions.assertEquals((Object)"prefix", (Object)subset.getPrefix());
    }

    @Test
    public void testSetProperty() {
        BaseConfiguration conf = new BaseConfiguration();
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)conf, "test", ".");
        subset.setProperty("key1", (Object)"value1");
        Assertions.assertEquals((Object)"value1", (Object)subset.getProperty("key1"));
        Assertions.assertEquals((Object)"value1", (Object)conf.getProperty("test.key1"));
        conf.setProperty("test.key2", (Object)"value2");
        Assertions.assertEquals((Object)"value2", (Object)conf.getProperty("test.key2"));
        Assertions.assertEquals((Object)"value2", (Object)subset.getProperty("key2"));
    }

    @Test
    public void testThrowExceptionOnMissing() {
        BaseConfiguration config = new BaseConfiguration();
        config.setThrowExceptionOnMissing(true);
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)config, "prefix");
        Assertions.assertThrows(NoSuchElementException.class, () -> subset.getString("foo"));
        config.setThrowExceptionOnMissing(false);
        Assertions.assertNull((Object)subset.getString("foo"));
        subset.setThrowExceptionOnMissing(true);
        Assertions.assertThrows(NoSuchElementException.class, () -> config.getString("foo"));
    }

    @Test
    public void testPrefixDelimiter() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("part1.part2@test.key1", (Object)"value1");
        config.setProperty("part1.part2", (Object)"value2");
        config.setProperty("part3.part4@testing.key2", (Object)"value3");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)config, "part1.part2", "@");
        Assertions.assertEquals((Object)"value1", (Object)subset.getString("test.key1"));
        Assertions.assertEquals((Object)"value2", (Object)subset.getString(""));
        Assertions.assertNull((Object)subset.getString("testing.key2"));
        Assertions.assertEquals((int)2, (int)subset.size());
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertTrue((boolean)subset.getKeys().hasNext());
    }

    @Test
    public void testPrefixDelimiterNegativeTest() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("part1.part2@test.key1", (Object)"value1");
        config.setProperty("part3.part4@testing.key2", (Object)"value2");
        SubsetConfiguration subset = new SubsetConfiguration((Configuration)config, "part1.part2", "@"){

            protected Iterator<String> getKeysInternal() {
                try {
                    Class<?> subsetIteratorClass = Class.forName("org.apache.commons.configuration2.SubsetConfiguration$SubsetIterator");
                    Constructor<?> ctor = subsetIteratorClass.getDeclaredConstructor(SubsetConfiguration.class, Iterator.class);
                    ctor.setAccessible(true);
                    return (Iterator)ctor.newInstance(new Object[]{this, this.parent.getKeys("part1.part2")});
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        };
        Assertions.assertEquals((Object)"value1", (Object)subset.getString("test.key1"));
        Assertions.assertNull((Object)subset.getString("testing.key2"));
        Assertions.assertEquals((int)0, (int)subset.size());
        Assertions.assertTrue((boolean)subset.isEmpty());
        Assertions.assertFalse((boolean)subset.getKeys().hasNext());
    }
}

