/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.sync.Synchronizer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class SynchronizerTestImpl
implements Synchronizer {
    private final StringBuilder methods = new StringBuilder();

    private void append(Methods m) {
        this.methods.append((Object)m);
    }

    public void beginRead() {
        this.append(Methods.BEGIN_READ);
    }

    public void beginWrite() {
        this.append(Methods.BEGIN_WRITE);
    }

    public void clear() {
        this.methods.setLength(0);
    }

    private String constructExpectedMethods(Methods ... expMethods) {
        StringBuilder buf = new StringBuilder();
        for (Methods m : expMethods) {
            buf.append((Object)m);
        }
        return buf.toString();
    }

    public void endRead() {
        this.append(Methods.END_READ);
    }

    public void endWrite() {
        this.append(Methods.END_WRITE);
    }

    public void verify(Methods ... expMethods) {
        Assertions.assertEquals((Object)this.constructExpectedMethods(expMethods), (Object)this.methods.toString());
    }

    public void verifyContains(Methods ... expMethods) {
        MatcherAssert.assertThat((Object)this.methods.toString(), (Matcher)Matchers.containsString((String)this.constructExpectedMethods(expMethods)));
    }

    public void verifyEnd(Methods ... expMethods) {
        MatcherAssert.assertThat((Object)this.methods.toString(), (Matcher)Matchers.endsWith((String)this.constructExpectedMethods(expMethods)));
    }

    public void verifyStart(Methods ... expMethods) {
        MatcherAssert.assertThat((Object)this.methods.toString(), (Matcher)Matchers.startsWith((String)this.constructExpectedMethods(expMethods)));
    }

    public static enum Methods {
        BEGIN_READ,
        END_READ,
        BEGIN_WRITE,
        END_WRITE;

    }
}

