/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.beanutils.BeanCreationContext;
import org.apache.commons.configuration2.beanutils.BeanCreationTestBean;
import org.apache.commons.configuration2.beanutils.BeanCreationTestCtorBean;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.BeanDeclarationTestImpl;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.beanutils.ConstructorArg;
import org.apache.commons.configuration2.beanutils.DefaultBeanFactory;
import org.apache.commons.configuration2.convert.ConversionHandler;
import org.apache.commons.configuration2.convert.DefaultConversionHandler;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDefaultBeanFactory {
    private static final String TEST_STRING = "testString";
    private static final int TEST_INT = 42;
    private DefaultBeanFactory factory;

    private static BeanCreationContext createBcc(final Class<?> cls, final BeanDeclaration decl) {
        return new BeanCreationContext(){
            private final BeanHelper beanHelper = new BeanHelper();

            public Object createBean(BeanDeclaration data) {
                return this.beanHelper.createBean(data);
            }

            public Class<?> getBeanClass() {
                return cls;
            }

            public BeanDeclaration getBeanDeclaration() {
                return decl;
            }

            public Object getParameter() {
                return null;
            }

            public void initBean(Object bean, BeanDeclaration data) {
                this.beanHelper.initBean(bean, data);
            }
        };
    }

    private static BeanDeclarationTestImpl setUpBeanDeclaration() {
        BeanDeclarationTestImpl data = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("stringValue", TEST_STRING);
        properties.put("intValue", String.valueOf(42));
        data.setBeanProperties(properties);
        BeanDeclarationTestImpl buddyData = new BeanDeclarationTestImpl();
        HashMap<String, Object> properties2 = new HashMap<String, Object>();
        properties2.put("stringValue", "Another test string");
        properties2.put("intValue", 100);
        buddyData.setBeanProperties(properties2);
        buddyData.setBeanClassName(BeanCreationTestBean.class.getName());
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("buddy", buddyData);
        data.setNestedBeanDeclarations(nested);
        return data;
    }

    @BeforeEach
    public void setUp() {
        this.factory = new DefaultBeanFactory();
    }

    @Test
    public void testCreateBean() throws Exception {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("throwExceptionOnMissing", Boolean.TRUE);
        decl.setBeanProperties(props);
        Object bean = this.factory.createBean(TestDefaultBeanFactory.createBcc(PropertiesConfiguration.class, decl));
        Assertions.assertNotNull((Object)bean);
        Assertions.assertEquals(PropertiesConfiguration.class, bean.getClass());
        PropertiesConfiguration config = (PropertiesConfiguration)bean;
        Assertions.assertTrue((boolean)config.isThrowExceptionOnMissing());
    }

    @Test
    public void testCreateBeanConstructor() throws Exception {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)"test"));
        args.add(ConstructorArg.forValue((Object)"42"));
        decl.setConstructorArgs(args);
        BeanCreationTestCtorBean bean = (BeanCreationTestCtorBean)this.factory.createBean(TestDefaultBeanFactory.createBcc(BeanCreationTestCtorBean.class, decl));
        Assertions.assertEquals((Object)"test", (Object)bean.getStringValue());
        Assertions.assertEquals((int)42, (int)bean.getIntValue());
    }

    @Test
    public void testCreateBeanConstructorNestedBean() throws Exception {
        BeanDeclarationTestImpl declNested = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)"test", (String)String.class.getName()));
        declNested.setConstructorArgs(args);
        declNested.setBeanClassName(BeanCreationTestCtorBean.class.getName());
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        decl.setConstructorArgs(Collections.singleton(ConstructorArg.forBeanDeclaration((BeanDeclaration)declNested, (String)BeanCreationTestBean.class.getName())));
        BeanCreationTestCtorBean bean = (BeanCreationTestCtorBean)this.factory.createBean(TestDefaultBeanFactory.createBcc(BeanCreationTestCtorBean.class, decl));
        Assertions.assertNotNull((Object)bean.getBuddy());
        Assertions.assertEquals((Object)"test", (Object)bean.getBuddy().getStringValue());
    }

    @Test
    public void testDefaultConversionHandler() {
        Assertions.assertSame((Object)DefaultConversionHandler.INSTANCE, (Object)this.factory.getConversionHandler());
    }

    @Test
    public void testFindMatchingConstructorAmbiguous() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING));
        decl.setConstructorArgs(args);
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl));
    }

    @Test
    public void testFindMatchingConstructorArgCount() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING));
        args.add(ConstructorArg.forValue((Object)String.valueOf(42)));
        decl.setConstructorArgs(args);
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
        Object[] paramTypes = ctor.getParameterTypes();
        Assertions.assertArrayEquals((Object[])new Class[]{String.class, Integer.TYPE}, (Object[])paramTypes);
    }

    @Test
    public void testFindMatchingConstructorExplicitType() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forBeanDeclaration((BeanDeclaration)TestDefaultBeanFactory.setUpBeanDeclaration(), (String)BeanCreationTestBean.class.getName()));
        decl.setConstructorArgs(args);
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl);
        Object[] paramTypes = ctor.getParameterTypes();
        Assertions.assertArrayEquals((Object[])new Class[]{BeanCreationTestBean.class}, (Object[])paramTypes);
    }

    @Test
    public void testFindMatchingConstructorNoArgs() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        Constructor ctor = DefaultBeanFactory.findMatchingConstructor(BeanCreationTestBean.class, (BeanDeclaration)decl);
        Assertions.assertEquals((int)0, (int)ctor.getParameterTypes().length);
    }

    @Test
    public void testFindMatchingConstructorNoMatch() {
        BeanDeclarationTestImpl decl = new BeanDeclarationTestImpl();
        ArrayList<ConstructorArg> args = new ArrayList<ConstructorArg>();
        args.add(ConstructorArg.forValue((Object)TEST_STRING, (String)this.getClass().getName()));
        decl.setConstructorArgs(args);
        ConfigurationRuntimeException crex = (ConfigurationRuntimeException)Assertions.assertThrows(ConfigurationRuntimeException.class, () -> DefaultBeanFactory.findMatchingConstructor(BeanCreationTestCtorBean.class, (BeanDeclaration)decl));
        String msg = crex.getMessage();
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.containsString((String)BeanCreationTestCtorBean.class.getName()));
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.containsString((String)TEST_STRING));
        MatcherAssert.assertThat((Object)msg, (Matcher)Matchers.containsString((String)("(" + this.getClass().getName() + ')')));
    }

    @Test
    public void testGetDefaultBeanClass() {
        Assertions.assertNull((Object)this.factory.getDefaultBeanClass());
    }

    @Test
    public void testInitWithConversionHandler() {
        ConversionHandler handler = (ConversionHandler)Mockito.mock(ConversionHandler.class);
        this.factory = new DefaultBeanFactory(handler);
        Assertions.assertSame((Object)handler, (Object)this.factory.getConversionHandler());
    }
}

