/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestNullCompositeConfiguration {
    protected PropertiesConfiguration conf1;
    protected PropertiesConfiguration conf2;
    protected XMLConfiguration xmlConf;
    protected CompositeConfiguration cc;
    private final String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private final String testProperties2 = ConfigurationAssert.getTestFile("test2.properties").getAbsolutePath();
    private final String testPropertiesXML = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();

    @BeforeEach
    public void setUp() throws Exception {
        this.cc = new CompositeConfiguration();
        LegacyListDelimiterHandler listHandler = new LegacyListDelimiterHandler(',');
        this.conf1 = new PropertiesConfiguration();
        this.conf1.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler1 = new FileHandler((FileBased)this.conf1);
        handler1.setFileName(this.testProperties);
        handler1.load();
        this.conf2 = new PropertiesConfiguration();
        this.conf2.setListDelimiterHandler((ListDelimiterHandler)listHandler);
        FileHandler handler2 = new FileHandler((FileBased)this.conf2);
        handler2.setFileName(this.testProperties2);
        handler2.load();
        this.xmlConf = new XMLConfiguration();
        FileHandler handler3 = new FileHandler((FileBased)this.xmlConf);
        handler3.load(new File(this.testPropertiesXML));
        this.cc.setThrowExceptionOnMissing(false);
    }

    @Test
    public void testAddingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Object[] values = this.cc.getStringArray("test.short");
        Assertions.assertArrayEquals((Object[])new String[]{"1"}, (Object[])values);
        this.cc.addProperty("test.short", (Object)"88");
        values = this.cc.getStringArray("test.short");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "88"}, (Object[])values);
    }

    @Test
    public void testAddRemoveConfigurations() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertEquals((int)3, (int)this.cc.getNumberOfConfigurations());
        this.cc.removeConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)2, (int)this.cc.getNumberOfConfigurations());
        this.cc.clear();
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testCantRemoveMemoryConfig() throws Exception {
        this.cc.clear();
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
        Configuration internal = this.cc.getConfiguration(0);
        this.cc.removeConfiguration(internal);
        Assertions.assertEquals((int)1, (int)this.cc.getNumberOfConfigurations());
    }

    @Test
    public void testCheckingInMemoryConfiguration() throws Exception {
        String TEST_KEY = "testKey";
        PropertiesConfiguration defaults = new PropertiesConfiguration();
        defaults.setProperty("testKey", (Object)"testValue");
        CompositeConfiguration testConfiguration = new CompositeConfiguration((Configuration)defaults);
        Assertions.assertTrue((boolean)testConfiguration.containsKey("testKey"));
        Assertions.assertFalse((boolean)testConfiguration.isEmpty());
        boolean foundTestKey = false;
        Iterator i = testConfiguration.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.equals("testKey")) continue;
            foundTestKey = true;
        }
        Assertions.assertTrue((boolean)foundTestKey);
        testConfiguration.clearProperty("testKey");
        Assertions.assertFalse((boolean)testConfiguration.containsKey("testKey"));
    }

    @Test
    public void testClearingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.clearProperty("test.short");
        Assertions.assertFalse((boolean)this.cc.containsKey("test.short"));
    }

    @Test
    public void testDefaultValueWhenKeyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((Object)"default", (Object)this.cc.getString("bogus", "default"));
        Assertions.assertEquals((double)1.4, (double)this.cc.getDouble("bogus", 1.4), (double)0.0);
        Assertions.assertEquals((double)1.4, (double)this.cc.getDouble("bogus", 1.4), (double)0.0);
    }

    @Test
    public void testGetKeys2PreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList<String> orderedList = new ArrayList<String>();
        Iterator keys = this.conf1.getKeys("test");
        while (keys.hasNext()) {
            orderedList.add((String)keys.next());
        }
        ArrayList<String> iteratedList = new ArrayList<String>();
        Iterator keys2 = this.cc.getKeys("test");
        while (keys2.hasNext()) {
            iteratedList.add((String)keys2.next());
        }
        Assertions.assertEquals(orderedList, iteratedList);
    }

    @Test
    public void testGetKeysPreservesOrder() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        ArrayList<String> orderedList = new ArrayList<String>();
        Iterator keys = this.conf1.getKeys();
        while (keys.hasNext()) {
            orderedList.add((String)keys.next());
        }
        ArrayList<String> iteratedList = new ArrayList<String>();
        Iterator keys2 = this.cc.getKeys();
        while (keys2.hasNext()) {
            iteratedList.add((String)keys2.next());
        }
        Assertions.assertEquals(orderedList, iteratedList);
    }

    @Test
    public void testGetList() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        List list = this.cc.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)list);
        this.cc.addProperty("array", (Object)"value5");
        list = this.cc.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2", "value5"), (Object)list);
    }

    @Test
    public void testGetProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertEquals((Object)"test.properties", (Object)this.cc.getString("propertyInOrder"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.conf2);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((Object)"test2.properties", (Object)this.cc.getString("propertyInOrder"));
    }

    @Test
    public void testGetPropertyMissing() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        Assertions.assertNull((Object)this.cc.getString("bogus.property"));
        Assertions.assertFalse((boolean)this.cc.getBoolean("test.missing.boolean", false));
        Assertions.assertTrue((boolean)this.cc.getBoolean("test.missing.boolean.true", true));
    }

    @Test
    public void testGetPropertyWIncludes() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.conf2);
        List l = this.cc.getList("packages");
        Assertions.assertTrue((boolean)l.contains("packagea"));
    }

    @Test
    public void testGetStringWithDefaults() {
        BaseConfiguration defaults = new BaseConfiguration();
        defaults.addProperty("default", (Object)"default string");
        CompositeConfiguration c = new CompositeConfiguration((Configuration)defaults);
        c.addProperty("string", (Object)"test string");
        Assertions.assertEquals((Object)"test string", (Object)c.getString("string"));
        Assertions.assertNull((Object)c.getString("XXX"));
        Assertions.assertEquals((Object)"test string", (Object)c.getString("string", "some default value"));
        Assertions.assertEquals((Object)"default string", (Object)c.getString("default"));
        Assertions.assertEquals((Object)"default string", (Object)c.getString("default", "some default value"));
        Assertions.assertEquals((Object)"some default value", (Object)c.getString("XXX", "some default value"));
    }

    @Test
    public void testGettingConfiguration() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals(PropertiesConfiguration.class, (Object)this.cc.getConfiguration(0).getClass());
        Assertions.assertEquals(XMLConfiguration.class, (Object)this.cc.getConfiguration(1).getClass());
    }

    @Test
    public void testGettingSubset() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Configuration subset = this.cc.subset("test");
        Assertions.assertNotNull((Object)subset);
        Assertions.assertFalse((boolean)subset.isEmpty());
        Assertions.assertEquals((Object)"1", (Object)subset.getString("short"));
        this.cc.setProperty("test.short", (Object)"43");
        subset = this.cc.subset("test");
        Assertions.assertEquals((Object)"43", (Object)subset.getString("short"));
    }

    @Test
    public void testGetVector() {
        BaseConfiguration conf1 = new BaseConfiguration();
        conf1.addProperty("array", (Object)"value1");
        conf1.addProperty("array", (Object)"value2");
        BaseConfiguration conf2 = new BaseConfiguration();
        conf2.addProperty("array", (Object)"value3");
        conf2.addProperty("array", (Object)"value4");
        this.cc.addConfiguration((Configuration)conf1);
        this.cc.addConfiguration((Configuration)conf2);
        this.cc.addProperty("array", (Object)"value5");
        List list = this.cc.getList("array");
        Assertions.assertEquals(Arrays.asList("value1", "value2", "value5"), (Object)list);
    }

    @Test
    public void testList() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        List packages = this.cc.getList("packages");
        Assertions.assertEquals((int)3, (int)packages.size());
        ArrayList<String> defaultList = new ArrayList<String>();
        defaultList.add("1");
        defaultList.add("2");
        packages = this.cc.getList("packages.which.dont.exist", defaultList);
        Assertions.assertEquals((int)2, (int)packages.size());
    }

    @Test
    public void testMultipleTypesOfConfigs() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((int)1, (int)this.cc.getInt("test.short"));
        this.cc.clear();
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.addConfiguration((Configuration)this.conf1);
        Assertions.assertEquals((int)8, (int)this.cc.getInt("test.short"));
    }

    @Test
    public void testPropertyExistsInOnlyOneConfig() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        Assertions.assertEquals((Object)"value", (Object)this.cc.getString("element"));
    }

    @Test
    public void testSettingMissingProperty() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        this.cc.setProperty("my.new.property", (Object)"supernew");
        Assertions.assertEquals((Object)"supernew", (Object)this.cc.getString("my.new.property"));
    }

    @Test
    public void testStringArray() throws Exception {
        this.cc.addConfiguration((Configuration)this.conf1);
        this.cc.addConfiguration((Configuration)this.xmlConf);
        String[] packages = this.cc.getStringArray("packages");
        Assertions.assertEquals((int)3, (int)packages.length);
        packages = this.cc.getStringArray("packages.which.dont.exist");
        Assertions.assertEquals((int)0, (int)packages.length);
    }

    @Test
    public void testSubsetCanResolve() throws Exception {
        this.cc = new CompositeConfiguration();
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("subset.tempfile", (Object)"${java.io.tmpdir}/file.tmp");
        this.cc.addConfiguration((Configuration)config);
        this.cc.addConfiguration(ConfigurationConverter.getConfiguration((Properties)System.getProperties()));
        Configuration subset = this.cc.subset("subset");
        Assertions.assertEquals((Object)(FileUtils.getTempDirectoryPath() + "/file.tmp"), (Object)subset.getString("tempfile"));
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assertions.assertFalse((boolean)this.cc.isThrowExceptionOnMissing());
    }
}

