/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.configuration2.JNDIConfiguration;
import org.apache.commons.configuration2.TestJNDIConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJNDIEnvironmentValues {
    private JNDIConfiguration conf;

    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("java.naming.factory.initial", TestJNDIConfiguration.CONTEXT_FACTORY);
        this.conf = new JNDIConfiguration();
        this.conf.setThrowExceptionOnMissing(true);
    }

    @Test
    public void testClearProperty() {
        Assertions.assertNotNull((Object)this.conf.getShort("test.short", null));
        this.conf.clearProperty("test.short");
        Assertions.assertNull((Object)this.conf.getShort("test.short", null));
    }

    @Test
    public void testContainsKey() throws Exception {
        Assertions.assertTrue((boolean)this.conf.containsKey("test.key"));
        Assertions.assertFalse((boolean)this.conf.containsKey("test.imaginarykey"));
    }

    @Test
    public void testGetKeys() throws Exception {
        boolean found = false;
        Iterator it = this.conf.getKeys();
        Assertions.assertTrue((boolean)it.hasNext());
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assertions.assertTrue((boolean)found);
    }

    @Test
    public void testGetKeysWithExistingPrefix() {
        Iterator it = this.conf.getKeys("test");
        boolean found = false;
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assertions.assertTrue((boolean)found);
    }

    @Test
    public void testGetKeysWithKeyAsPrefix() {
        Iterator it = this.conf.getKeys("test.boolean");
        boolean found = false;
        while (it.hasNext() && !found) {
            found = "test.boolean".equals(it.next());
        }
        Assertions.assertTrue((boolean)found);
    }

    @Test
    public void testGetKeysWithUnknownPrefix() {
        Iterator it = this.conf.getKeys("foo.bar");
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetMissingKey() throws Exception {
        Assertions.assertThrows(NoSuchElementException.class, () -> this.conf.getString("test.imaginarykey"));
    }

    @Test
    public void testGetMissingKeyWithDefault() throws Exception {
        String result = this.conf.getString("test.imaginarykey", "bob");
        Assertions.assertEquals((Object)"bob", (Object)result);
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertFalse((boolean)this.conf.isEmpty());
    }

    @Test
    public void testMoreGets() throws Exception {
        String s = this.conf.getString("test.key");
        Assertions.assertEquals((Object)"jndivalue", (Object)s);
        Assertions.assertEquals((Object)"jndivalue2", (Object)this.conf.getString("test.key2"));
        Assertions.assertEquals((int)1, (int)this.conf.getShort("test.short"));
    }

    @Test
    public void testSimpleGet() throws Exception {
        String s = this.conf.getString("test.key");
        Assertions.assertEquals((Object)"jndivalue", (Object)s);
    }

    @Test
    public void testThrowExceptionOnMissing() {
        Assertions.assertTrue((boolean)this.conf.isThrowExceptionOnMissing());
    }
}

