/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class TestAbstractConfiguration {
    protected abstract AbstractConfiguration getConfiguration();

    protected abstract AbstractConfiguration getEmptyConfiguration();

    @Test
    public void testAddPropertyDirect() {
        AbstractConfiguration config = this.getConfiguration();
        config.addPropertyDirect("key3", (Object)"value3");
        Assertions.assertEquals((Object)"value3", (Object)config.getProperty("key3"));
        config.addPropertyDirect("key3", (Object)"value4");
        config.addPropertyDirect("key3", (Object)"value5");
        List list = config.getList("key3");
        Assertions.assertNotNull((Object)list);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("value3");
        expected.add("value4");
        expected.add("value5");
        Assertions.assertEquals(expected, (Object)list);
    }

    @Test
    public void testClearProperty() {
        AbstractConfiguration config = this.getConfiguration();
        config.clearProperty("key2");
        Assertions.assertFalse((boolean)config.containsKey("key2"));
    }

    @Test
    public void testContainsKey() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertTrue((boolean)config.containsKey("key1"));
        Assertions.assertFalse((boolean)config.containsKey("key3"));
    }

    @Test
    public void testGetBigIntegerConversion() {
        AbstractConfiguration config = this.getConfiguration();
        ConversionException cex = (ConversionException)Assertions.assertThrows(ConversionException.class, () -> TestAbstractConfiguration.lambda$testGetBigIntegerConversion$0((Configuration)config));
        MatcherAssert.assertThat((Object)cex.getMessage(), (Matcher)Matchers.containsString((String)"'key1'"));
        MatcherAssert.assertThat((Object)cex.getMessage(), (Matcher)Matchers.containsString((String)BigInteger.class.getName()));
        MatcherAssert.assertThat((Object)cex.getMessage(), (Matcher)Matchers.containsString((String)config.getString("key1")));
    }

    @Test
    public void testGetKeys() {
        AbstractConfiguration config = this.getConfiguration();
        Iterator keys = config.getKeys();
        Object[] expectedKeys = new String[]{"key1", "key2", "list", "listesc"};
        Assertions.assertNotNull((Object)keys);
        Assertions.assertTrue((boolean)keys.hasNext());
        ArrayList<String> actualKeys = new ArrayList<String>();
        while (keys.hasNext()) {
            actualKeys.add((String)keys.next());
        }
        MatcherAssert.assertThat((String)"keys", actualKeys, (Matcher)Matchers.containsInAnyOrder((Object[])expectedKeys));
    }

    @Test
    public void testGetProperty() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertEquals((Object)"value1", (Object)config.getProperty("key1"));
        Assertions.assertEquals((Object)"value2", (Object)config.getProperty("key2"));
        Assertions.assertNull((Object)config.getProperty("key3"));
    }

    @Test
    public void testIsEmpty() {
        AbstractConfiguration config = this.getConfiguration();
        Assertions.assertFalse((boolean)config.isEmpty());
        Assertions.assertTrue((boolean)this.getEmptyConfiguration().isEmpty());
    }

    @Test
    public void testList() {
        AbstractConfiguration config = this.getConfiguration();
        List list = config.getList("list");
        Assertions.assertNotNull((Object)config.getProperty("list"));
        Assertions.assertEquals(Arrays.asList("value1", "value2"), (Object)list);
    }

    @Test
    public void testListEscaped() {
        Assertions.assertEquals((Object)"value1,value2", (Object)this.getConfiguration().getString("listesc"));
    }

    @Test
    public void testSetLogger() {
        AbstractConfiguration config = this.getEmptyConfiguration();
        Assertions.assertNotNull((Object)config.getLogger());
        ConfigurationLogger log = new ConfigurationLogger(config.getClass());
        config.setLogger(log);
        Assertions.assertSame((Object)log, (Object)config.getLogger());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)4, (int)this.getConfiguration().size());
    }

    @Test
    public void testSizeEmpty() {
        Assertions.assertEquals((int)0, (int)this.getEmptyConfiguration().size());
    }

    private static /* synthetic */ void lambda$testGetBigIntegerConversion$0(Configuration config) throws Throwable {
        config.getBigInteger("key1");
    }
}

