/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration2.tree.xpath.XPathContextFactory;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestXPathExpressionEngine {
    private static final String TEST_KEY = "TESTKEY";
    private static final String ROOT_NAME = "testRoot";
    private static ImmutableNode root;
    private static NodeHandler<ImmutableNode> handler;

    private static void checkAddPath(NodeAddData<ImmutableNode> data, boolean attr, String ... expected) {
        Assertions.assertSame((Object)root, (Object)data.getParent());
        List path = data.getPathNodes();
        Assertions.assertEquals(Arrays.asList(expected).subList(0, expected.length - 1), (Object)path);
        Assertions.assertEquals((Object)expected[expected.length - 1], (Object)data.getNewNodeName());
        Assertions.assertEquals((Object)attr, (Object)data.isAttribute());
    }

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        root = new ImmutableNode.Builder().name(ROOT_NAME).create();
        handler = new InMemoryNodeModel(root).getNodeHandler();
    }

    private void checkEmptyKey(String key) {
        XPathContextFactory factory = (XPathContextFactory)Mockito.mock(XPathContextFactory.class);
        XPathExpressionEngine engine = new XPathExpressionEngine(factory);
        List results = engine.query((Object)root, key, handler);
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertSame((Object)root, (Object)((QueryResult)results.get(0)).getNode());
    }

    private void checkInvalidAddPath(String path) {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        QueryResult res = QueryResult.createNodeResult((Object)root);
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.createNodeAddData(path, res));
    }

    private JXPathContext expectSelect(Object ... results) {
        JXPathContext ctx = (JXPathContext)Mockito.mock(JXPathContext.class);
        Mockito.when((Object)ctx.selectNodes(TEST_KEY)).thenReturn(Arrays.asList(results));
        return ctx;
    }

    private XPathExpressionEngine setUpEngine(JXPathContext ctx) {
        XPathContextFactory factory = (XPathContextFactory)Mockito.mock(XPathContextFactory.class);
        Mockito.when((Object)factory.createContext((Object)root, handler)).thenReturn((Object)ctx);
        return new XPathExpressionEngine(factory);
    }

    @Test
    public void testAttributeKeyOfRootNode() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"@child", (Object)engine.attributeKey(null, "child"));
    }

    @Test
    public void testCanonicalKeyNoDuplicates() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(2);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c2 = new ImmutableNode.Builder().name("child_other").create();
        parentBuilder.addChildren(Arrays.asList(c2, c1));
        ImmutableNode parent = parentBuilder.create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"parent/child[1]", (Object)engine.canonicalKey((Object)c1, "parent", testHandler));
    }

    @Test
    public void testCanonicalKeyNoParentKey() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(1);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode parent = parentBuilder.addChild(c1).create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"child[1]", (Object)engine.canonicalKey((Object)c1, null, testHandler));
    }

    @Test
    public void testCanonicalKeyRootNoParentKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"", (Object)engine.canonicalKey((Object)root, null, handler));
    }

    @Test
    public void testCanonicalKeyRootWithParentKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"parent", (Object)engine.canonicalKey((Object)root, "parent", handler));
    }

    @Test
    public void testCanonicalKeyWithDuplicates() {
        ImmutableNode.Builder parentBuilder = new ImmutableNode.Builder(3);
        ImmutableNode c1 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c2 = new ImmutableNode.Builder().name("child").create();
        ImmutableNode c3 = new ImmutableNode.Builder().name("child_other").create();
        parentBuilder.addChildren(Arrays.asList(c1, c2, c3));
        ImmutableNode parent = parentBuilder.create();
        NodeHandler testHandler = new InMemoryNodeModel(parent).getNodeHandler();
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"parent/child[1]", (Object)engine.canonicalKey((Object)c1, "parent", testHandler));
        Assertions.assertEquals((Object)"parent/child[2]", (Object)engine.canonicalKey((Object)c2, "parent", testHandler));
    }

    @Test
    public void testDefaultContextFactory() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertNotNull((Object)engine.getContextFactory());
    }

    @Test
    public void testNodeKeyAttribute() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"node/@attr", (Object)engine.attributeKey("node", "attr"));
    }

    @Test
    public void testNodeKeyForRootChild() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)ROOT_NAME, (Object)engine.nodeKey((Object)root, "", handler));
    }

    @Test
    public void testNodeKeyForRootNode() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"", (Object)engine.nodeKey((Object)root, null, handler));
    }

    @Test
    public void testNodeKeyNoNodeName() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"test", (Object)engine.nodeKey((Object)new ImmutableNode.Builder().create(), "test", handler));
    }

    @Test
    public void testNodeKeyNormal() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertEquals((Object)"parent/testRoot", (Object)engine.nodeKey((Object)root, "parent", handler));
    }

    @Test
    public void testNodePointerFactory() {
        JXPathContext.newContext((Object)this);
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        boolean found = false;
        for (NodePointerFactory factory : factories) {
            if (!(factory instanceof ConfigurationNodePointerFactory)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found);
    }

    @Test
    public void testPrepareAddAttribute() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY\t@newAttr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "newAttr");
    }

    @Test
    public void testPrepareAddAttributePath() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY a/full/path@attr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "a", "full", "path", "attr");
    }

    @Test
    public void testPrepareAddEmptyKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.prepareAdd((Object)root, "", handler));
    }

    @Test
    public void testPrepareAddEmptyPath() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.prepareAdd((Object)root, "TESTKEY ", handler));
    }

    @Test
    public void testPrepareAddInvalidAttributePath() {
        this.checkInvalidAddPath("a/path/with@an/attribute");
    }

    @Test
    public void testPrepareAddInvalidAttributePath2() {
        this.checkInvalidAddPath("a/path/with/@attribute");
    }

    @Test
    public void testPrepareAddInvalidParent() {
        JXPathContext ctx = this.expectSelect(new Object[0]);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.prepareAdd((Object)root, "TESTKEY test", handler));
    }

    @Test
    public void testPrepareAddInvalidPath() {
        this.checkInvalidAddPath("an/invalid//path");
    }

    @Test
    public void testPrepareAddInvalidPathMultipleAttributes() {
        this.checkInvalidAddPath("an@attribute@path");
    }

    @Test
    public void testPrepareAddInvalidPathWithSlash() {
        this.checkInvalidAddPath("/a/path/node");
    }

    @Test
    public void testPrepareAddNode() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY  newNode", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "newNode");
    }

    @Test
    public void testPrepareAddNullKey() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.prepareAdd((Object)root, null, handler));
    }

    @Test
    public void testPrepareAddPath() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, "TESTKEY \t a/full/path/node", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "a", "full", "path", "node");
    }

    @Test
    public void testPrepareAddRootAttribute() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, " @attr", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, true, "attr");
    }

    @Test
    public void testPrepareAddRootChild() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        NodeAddData data = engine.prepareAdd((Object)root, " newNode", handler);
        TestXPathExpressionEngine.checkAddPath((NodeAddData<ImmutableNode>)data, false, "newNode");
    }

    @Test
    public void testPrepareAddToAttributeResult() {
        XPathExpressionEngine engine = new XPathExpressionEngine();
        QueryResult result = QueryResult.createAttributeResult((Object)root, (String)TEST_KEY);
        Assertions.assertThrows(IllegalArgumentException.class, () -> engine.createNodeAddData("path", result));
    }

    @Test
    public void testQueryAttributeExpression() {
        QueryResult attrResult = QueryResult.createAttributeResult((Object)root, (String)"attr");
        JXPathContext ctx = this.expectSelect(attrResult);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        List result = engine.query((Object)root, TEST_KEY, handler);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertSame((Object)attrResult, result.get(0));
    }

    @Test
    public void testQueryNodeExpression() {
        JXPathContext ctx = this.expectSelect(root);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        List result = engine.query((Object)root, TEST_KEY, handler);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertSame((Object)root, (Object)((QueryResult)result.get(0)).getNode());
        Assertions.assertFalse((boolean)((QueryResult)result.get(0)).isAttributeResult());
    }

    @Test
    public void testQueryWithEmptyKey() {
        this.checkEmptyKey("");
    }

    @Test
    public void testQueryWithNullKey() {
        this.checkEmptyKey(null);
    }

    @Test
    public void testQueryWithoutResult() {
        JXPathContext ctx = this.expectSelect(new Object[0]);
        XPathExpressionEngine engine = this.setUpEngine(ctx);
        Assertions.assertTrue((boolean)engine.query((Object)root, TEST_KEY, handler).isEmpty());
    }
}

