/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationFactory;
import org.apache.commons.configuration.DataConfiguration;
import org.apache.commons.configuration.FileURLStreamHandler;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertiesConfigurationLayout;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPropertiesConfiguration {
    private static final String PROP_NAME = "testProperty";
    private static final String PROP_VALUE = "value";
    private static final String CR = System.getProperty("line.separator");
    private PropertiesConfiguration conf;
    private static String testProperties = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
    private static String testBasePath = ConfigurationAssert.TEST_DIR.getAbsolutePath();
    private static String testBasePath2 = ConfigurationAssert.TEST_DIR.getParentFile().getAbsolutePath();
    private static File testSavePropertiesFile = ConfigurationAssert.getOutFile("testsave.properties");

    @Before
    public void setUp() throws Exception {
        this.conf = new PropertiesConfiguration(testProperties);
        if (testSavePropertiesFile.exists()) {
            Assert.assertTrue((String)"Test output file could not be deleted", (boolean)testSavePropertiesFile.delete());
        }
    }

    @Test
    public void testLoad() throws Exception {
        String loaded = this.conf.getString("configuration.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    public void testAppend() throws Exception {
        File file2 = ConfigurationAssert.getTestFile("threesome.properties");
        this.conf.load(file2);
        Assert.assertEquals((Object)"aaa", (Object)this.conf.getString("test.threesome.one"));
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test
    public void testEmpty() throws Exception {
        String empty = this.conf.getString("test.empty");
        Assert.assertNotNull((Object)empty);
        Assert.assertEquals((Object)"", (Object)empty);
    }

    @Test
    public void testReference() throws Exception {
        Assert.assertEquals((Object)"baseextra", (Object)this.conf.getString("base.reference"));
    }

    @Test
    public void testLoadInclude() throws Exception {
        String loaded = this.conf.getString("include.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    public void testLoadIncludeInterpol() throws Exception {
        String loaded = this.conf.getString("include.interpol.loaded");
        Assert.assertEquals((Object)"true", (Object)loaded);
    }

    @Test
    public void testLoadIncludeFromReader() throws ConfigurationException, IOException {
        StringReader in = new StringReader(PropertiesConfiguration.getInclude() + " = " + ConfigurationAssert.getTestURL("include.properties"));
        this.conf = new PropertiesConfiguration();
        this.conf.load((Reader)in);
        Assert.assertEquals((String)"Include file not loaded", (Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    public void testDisableIncludes() throws ConfigurationException, IOException {
        String content = PropertiesConfiguration.getInclude() + " = nonExistingIncludeFile" + CR + PROP_NAME + " = " + PROP_VALUE + CR;
        StringReader in = new StringReader(content);
        this.conf = new PropertiesConfiguration();
        this.conf.setIncludesAllowed(false);
        this.conf.load((Reader)in);
        Assert.assertEquals((String)"Data not loaded", (Object)PROP_VALUE, (Object)this.conf.getString(PROP_NAME));
    }

    @Test
    public void testSetInclude() throws Exception {
        PropertiesConfiguration.setInclude((String)"import");
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.load(ConfigurationAssert.getTestFile("test.properties"));
        PropertiesConfiguration.setInclude((String)"include");
        Assert.assertNull((Object)conf.getString("include.loaded"));
    }

    @Test
    public void testList() throws Exception {
        List packages = this.conf.getList("packages");
        Assert.assertEquals((long)3L, (long)packages.size());
    }

    @Test
    public void testSave() throws Exception {
        this.conf.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        this.conf.addProperty("array", list);
        String filename = testSavePropertiesFile.getAbsolutePath();
        this.conf.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(filename);
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
        checkConfig.save();
    }

    @Test
    public void testSaveToCustomURL() throws Exception {
        URL url = new URL("foo", "", 0, "./target/testsave-custom-url.properties", new FileURLStreamHandler());
        this.conf.save(url);
        PropertiesConfiguration config2 = new PropertiesConfiguration(url);
        Assert.assertEquals((Object)"true", (Object)config2.getString("configuration.loaded"));
    }

    @Test
    public void testInMemoryCreatedSave() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.addProperty("string", (Object)"value1");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 5; ++i) {
            list.add(PROP_VALUE + i);
        }
        pc.addProperty("array", list);
        String filename = testSavePropertiesFile.getAbsolutePath();
        pc.save(filename);
        Assert.assertTrue((String)"The saved file doesn't exist", (boolean)testSavePropertiesFile.exists());
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(filename);
        ConfigurationAssert.assertEquals((Configuration)pc, (Configuration)checkConfig);
        checkConfig.save();
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        this.conf.setDelimiterParsingDisabled(true);
        this.conf.addProperty("test.list", (Object)"a,b,c");
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\,D:\\Data\\");
        this.conf.save(testSavePropertiesFile);
        PropertiesConfiguration checkConfig = new PropertiesConfiguration();
        checkConfig.setDelimiterParsingDisabled(true);
        checkConfig.setFile(testSavePropertiesFile);
        checkConfig.load();
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
    }

    @Test(expected=ConfigurationException.class)
    public void testSaveMissingFilename() throws ConfigurationException {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.save();
    }

    @Test
    public void testSaveWithBasePath() throws Exception {
        this.conf.setProperty("test", (Object)"true");
        this.conf.setBasePath(testSavePropertiesFile.getParentFile().toURI().toURL().toString());
        this.conf.setFileName(testSavePropertiesFile.getName());
        this.conf.save();
        Assert.assertTrue((boolean)testSavePropertiesFile.exists());
    }

    @Test
    public void testSaveEscapedEscapingCharacter() throws ConfigurationException {
        this.conf.addProperty("test.dirs", (Object)"C:\\Temp\\\\,D:\\Data\\\\,E:\\Test\\");
        List dirs = this.conf.getList("test.dirs");
        Assert.assertEquals((String)"Wrong number of list elements", (long)3L, (long)dirs.size());
        this.conf.save(testSavePropertiesFile);
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(testSavePropertiesFile);
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
    }

    @Test
    public void testLoadViaProperty() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setFileName(testProperties);
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    public void testLoadViaPropertyWithBasePath() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setBasePath(testBasePath);
        pc.setFileName("test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    public void testLoadViaPropertyWithBasePath2() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration();
        pc.setBasePath(testBasePath2);
        pc.setFileName("test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
        pc = new PropertiesConfiguration();
        pc.setBasePath(testBasePath2);
        pc.setFileName("test.properties");
        pc.load();
        Assert.assertTrue((String)"Make sure we have multiple keys", (boolean)pc.getBoolean("test.boolean"));
    }

    @Test
    public void testLoadFromFile() throws Exception {
        File file = ConfigurationAssert.getTestFile("test.properties");
        this.conf = new PropertiesConfiguration(file);
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("configuration.loaded"));
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadUnexistingFile() throws ConfigurationException {
        this.conf = new PropertiesConfiguration("Unexisting file");
    }

    @Test
    public void testLoadWithAutoSave() throws Exception {
        this.setUpSavedProperties();
    }

    @Test
    public void testLoadWithAutoSaveAndSetExisting() throws Exception {
        this.setUpSavedProperties();
        this.conf.setProperty("a", (Object)"moreThanOne");
        this.checkSavedConfig();
    }

    @Test
    public void testLoadWithAutoSaveAndSetNew() throws Exception {
        this.setUpSavedProperties();
        this.conf.setProperty("d", (Object)"four");
        this.checkSavedConfig();
    }

    @Test
    public void testLoadWithAutoSaveAndAdd() throws Exception {
        this.setUpSavedProperties();
        this.conf.addProperty("d", (Object)"four");
        this.checkSavedConfig();
    }

    @Test
    public void testLoadWithAutoSaveAndClear() throws Exception {
        this.setUpSavedProperties();
        this.conf.clearProperty("c");
        PropertiesConfiguration checkConfig = this.checkSavedConfig();
        Assert.assertFalse((String)"The saved configuration contain the key 'c'", (boolean)checkConfig.containsKey("c"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpSavedProperties() throws IOException, ConfigurationException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(testSavePropertiesFile));
            out.println("a = one");
            out.println("b = two");
            out.println("c = three");
            out.close();
            out = null;
            this.conf = new PropertiesConfiguration();
            this.conf.setAutoSave(true);
            this.conf.setFile(testSavePropertiesFile);
            this.conf.load();
            Assert.assertEquals((Object)"one", (Object)this.conf.getString("a"));
            Assert.assertEquals((Object)"two", (Object)this.conf.getString("b"));
            Assert.assertEquals((Object)"three", (Object)this.conf.getString("c"));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private PropertiesConfiguration checkSavedConfig() throws ConfigurationException {
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(testSavePropertiesFile);
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
        return checkConfig;
    }

    @Test
    public void testGetStringWithEscapedChars() {
        String property = this.conf.getString("test.unescape");
        Assert.assertEquals((String)"String with escaped characters", (Object)"This \n string \t contains \" escaped \\ characters", (Object)property);
    }

    @Test
    public void testGetStringWithEscapedComma() {
        String property = this.conf.getString("test.unescape.list-separator");
        Assert.assertEquals((String)"String with an escaped list separator", (Object)"This string contains , an escaped list separator", (Object)property);
    }

    @Test
    public void testUnescapeJava() {
        Assert.assertEquals((Object)"test\\,test", (Object)PropertiesConfiguration.unescapeJava((String)"test\\,test", (char)','));
    }

    @Test
    public void testEscapedKey() throws Exception {
        PropertiesConfiguration conf = new PropertiesConfiguration();
        conf.load((Reader)new StringReader("\\u0066\\u006f\\u006f=bar"));
        Assert.assertEquals((String)"value of the 'foo' property", (Object)"bar", (Object)conf.getString("foo"));
    }

    @Test
    public void testMixedArray() {
        String[] array = this.conf.getStringArray("test.mixed.array");
        Assert.assertEquals((String)"array length", (long)4L, (long)array.length);
        Assert.assertEquals((String)"1st element", (Object)"a", (Object)array[0]);
        Assert.assertEquals((String)"2nd element", (Object)"b", (Object)array[1]);
        Assert.assertEquals((String)"3rd element", (Object)"c", (Object)array[2]);
        Assert.assertEquals((String)"4th element", (Object)"d", (Object)array[3]);
    }

    @Test
    public void testMultilines() {
        String property = "This is a value spread out across several adjacent natural lines by escaping the line terminator with a backslash character.";
        Assert.assertEquals((String)"'test.multilines' property", (Object)property, (Object)this.conf.getString("test.multilines"));
    }

    @Test
    public void testChangingDefaultListDelimiter() throws Exception {
        PropertiesConfiguration pc = new PropertiesConfiguration(testProperties);
        Assert.assertEquals((long)4L, (long)pc.getList("test.mixed.array").size());
        char delimiter = PropertiesConfiguration.getDefaultListDelimiter();
        PropertiesConfiguration.setDefaultListDelimiter((char)'^');
        pc = new PropertiesConfiguration(testProperties);
        Assert.assertEquals((long)2L, (long)pc.getList("test.mixed.array").size());
        PropertiesConfiguration.setDefaultListDelimiter((char)delimiter);
    }

    @Test
    public void testChangingListDelimiter() throws Exception {
        PropertiesConfiguration pc1 = new PropertiesConfiguration(testProperties);
        Assert.assertEquals((long)4L, (long)pc1.getList("test.mixed.array").size());
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        pc2.setListDelimiter('^');
        pc2.setFileName(testProperties);
        pc2.load();
        Assert.assertEquals((String)"Should obtain the first value", (Object)"a", (Object)pc2.getString("test.mixed.array"));
        Assert.assertEquals((long)2L, (long)pc2.getList("test.mixed.array").size());
    }

    @Test
    public void testDisableListDelimiter() throws Exception {
        PropertiesConfiguration pc1 = new PropertiesConfiguration(testProperties);
        Assert.assertEquals((long)4L, (long)pc1.getList("test.mixed.array").size());
        PropertiesConfiguration pc2 = new PropertiesConfiguration();
        pc2.setDelimiterParsingDisabled(true);
        pc2.setFileName(testProperties);
        pc2.load();
        Assert.assertEquals((long)2L, (long)pc2.getList("test.mixed.array").size());
    }

    @Test
    public void testNewLineEscaping() {
        List list = this.conf.getList("test.path");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"C:\\path1\\", list.get(0));
        Assert.assertEquals((Object)"C:\\path2\\", list.get(1));
        Assert.assertEquals((Object)"C:\\path3\\complex\\test\\", list.get(2));
    }

    @Test
    public void testLoadIncludeFromClassPath() throws ConfigurationException {
        this.conf = new PropertiesConfiguration("test.properties");
        Assert.assertEquals((Object)"true", (Object)this.conf.getString("include.loaded"));
    }

    @Test
    public void testComment() {
        Assert.assertFalse((String)"comment line starting with '#' parsed as a property", (boolean)this.conf.containsKey("#comment"));
        Assert.assertFalse((String)"comment line starting with '!' parsed as a property", (boolean)this.conf.containsKey("!comment"));
    }

    @Test
    public void testEscapedKeyValueSeparator() {
        Assert.assertEquals((String)"Escaped separator '=' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator=in.key"));
        Assert.assertEquals((String)"Escaped separator ':' not supported in keys", (Object)"bar", (Object)this.conf.getProperty("test.separator:in.key"));
        Assert.assertEquals((String)"Escaped separator '\\t' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator\tin.key"));
        Assert.assertEquals((String)"Escaped separator '\\f' not supported in keys", (Object)"bar", (Object)this.conf.getProperty("test.separator\fin.key"));
        Assert.assertEquals((String)"Escaped separator ' ' not supported in keys", (Object)"foo", (Object)this.conf.getProperty("test.separator in.key"));
    }

    @Test
    public void testKeyValueSeparators() {
        Assert.assertEquals((String)"equal separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.equal"));
        Assert.assertEquals((String)"colon separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.colon"));
        Assert.assertEquals((String)"tab separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.tab"));
        Assert.assertEquals((String)"formfeed separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.formfeed"));
        Assert.assertEquals((String)"whitespace separator not properly parsed", (Object)"foo", (Object)this.conf.getProperty("test.separator.whitespace"));
    }

    @Test
    public void testIncludeInSubDir() throws ConfigurationException {
        ConfigurationFactory factory = new ConfigurationFactory("conf/testFactoryPropertiesInclude.xml");
        Configuration config = factory.getConfiguration();
        Assert.assertTrue((boolean)config.getBoolean("deeptest"));
        Assert.assertTrue((boolean)config.getBoolean("deepinclude"));
        Assert.assertFalse((boolean)config.containsKey("deeptestinvalid"));
    }

    @Test
    public void testLineSeparator() throws ConfigurationException {
        String EOL = System.getProperty("line.separator");
        this.conf = new PropertiesConfiguration();
        this.conf.setHeader("My header");
        this.conf.setProperty("prop", (Object)PROP_VALUE);
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        String content = out.toString();
        Assert.assertTrue((String)"Header could not be found", (content.indexOf("# My header" + EOL + EOL) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Property could not be found", (content.indexOf("prop = value" + EOL) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReentrantReload() {
        this.conf.setProperty("shouldReload", (Object)Boolean.FALSE);
        this.conf.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy(){

            public boolean reloadingRequired() {
                return this.configuration.getBoolean("shouldReload");
            }
        });
        Assert.assertFalse((String)"Property has wrong value", (boolean)this.conf.getBoolean("shouldReload"));
    }

    @Test
    public void testGetLayout() {
        PropertiesConfigurationLayout layout = this.conf.getLayout();
        Assert.assertNotNull((String)"Layout is null", (Object)layout);
        Assert.assertSame((String)"Different object returned", (Object)layout, (Object)this.conf.getLayout());
        this.conf.setLayout(null);
        PropertiesConfigurationLayout layout2 = this.conf.getLayout();
        Assert.assertNotNull((String)"Layout 2 is null", (Object)layout2);
        Assert.assertNotSame((String)"Same object returned", (Object)layout, (Object)layout2);
    }

    @Test
    public void testPropertyLoaded() throws ConfigurationException {
        DummyLayout layout = new DummyLayout(this.conf);
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded("layoutLoadedProperty", "yes");
        Assert.assertEquals((String)"Layout's load() was called", (long)0L, (long)layout.loadCalls);
        Assert.assertEquals((String)"Property not added", (Object)"yes", (Object)this.conf.getString("layoutLoadedProperty"));
    }

    @Test
    public void testPropertyLoadedInclude() throws ConfigurationException {
        DummyLayout layout = new DummyLayout(this.conf);
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClasspath.properties,testEqual.properties");
        Assert.assertEquals((String)"Layout's load() was not correctly called", (long)2L, (long)layout.loadCalls);
        Assert.assertFalse((String)"Property was added", (boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    public void testPropertyLoadedIncludeNotAllowed() throws ConfigurationException {
        DummyLayout layout = new DummyLayout(this.conf);
        this.conf.setLayout((PropertiesConfigurationLayout)layout);
        this.conf.setIncludesAllowed(false);
        this.conf.propertyLoaded(PropertiesConfiguration.getInclude(), "testClassPath.properties,testEqual.properties");
        Assert.assertEquals((String)"Layout's load() was called", (long)0L, (long)layout.loadCalls);
        Assert.assertFalse((String)"Property was added", (boolean)this.conf.containsKey(PropertiesConfiguration.getInclude()));
    }

    @Test
    public void testIsCommentLine() {
        Assert.assertTrue((String)"Comment not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"# a comment"));
        Assert.assertTrue((String)"Alternative comment not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"! a comment"));
        Assert.assertTrue((String)"Comment with no space not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"#a comment"));
        Assert.assertTrue((String)"Comment with leading space not detected", (boolean)PropertiesConfiguration.isCommentLine((String)"    ! a comment"));
        Assert.assertFalse((String)"Wrong comment", (boolean)PropertiesConfiguration.isCommentLine((String)"   a#comment"));
    }

    @Test
    public void testClone() throws ConfigurationException {
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assert.assertNotSame((String)"Copy has same layout object", (Object)this.conf.getLayout(), (Object)copy.getLayout());
        Assert.assertEquals((String)"Wrong number of event listeners for original", (long)1L, (long)this.conf.getConfigurationListeners().size());
        Assert.assertEquals((String)"Wrong number of event listeners for clone", (long)1L, (long)copy.getConfigurationListeners().size());
        Assert.assertSame((String)"Wrong event listener for original", (Object)this.conf.getLayout(), this.conf.getConfigurationListeners().iterator().next());
        Assert.assertSame((String)"Wrong event listener for clone", (Object)copy.getLayout(), copy.getConfigurationListeners().iterator().next());
        StringWriter outConf = new StringWriter();
        this.conf.save((Writer)outConf);
        StringWriter outCopy = new StringWriter();
        copy.save((Writer)outCopy);
        Assert.assertEquals((String)"Output from copy is different", (Object)outConf.toString(), (Object)outCopy.toString());
    }

    @Test
    public void testCloneNullLayout() {
        this.conf = new PropertiesConfiguration();
        PropertiesConfiguration copy = (PropertiesConfiguration)this.conf.clone();
        Assert.assertNotSame((String)"Layout objects are the same", (Object)this.conf.getLayout(), (Object)copy.getLayout());
    }

    @Test
    public void testSaveToHTTPServerSuccess() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(200, testSavePropertiesFile);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        this.conf.save(url);
        MockHttpURLConnection con = handler.getMockConnection();
        Assert.assertTrue((String)"Wrong output flag", (boolean)con.getDoOutput());
        Assert.assertEquals((String)"Wrong method", (Object)"PUT", (Object)con.getRequestMethod());
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(testSavePropertiesFile);
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
    }

    @Test
    public void testSaveToHTTPServerFail() throws Exception {
        MockHttpURLStreamHandler handler = new MockHttpURLStreamHandler(400, testSavePropertiesFile);
        URL url = new URL(null, "http://jakarta.apache.org", handler);
        try {
            this.conf.save(url);
            Assert.fail((String)"Response code was not checked!");
        }
        catch (ConfigurationException cex) {
            Assert.assertTrue((String)("Wrong root cause: " + (Object)((Object)cex)), (boolean)(cex.getCause() instanceof IOException));
        }
    }

    @Test
    public void testFileWithSharpSymbol() throws Exception {
        if (SystemUtils.isJavaVersionAtLeast((float)1.4f)) {
            File file = new File("target/sharp#1.properties");
            file.createNewFile();
            PropertiesConfiguration conf = new PropertiesConfiguration(file);
            conf.save();
            Assert.assertTrue((String)("Missing file " + file), (boolean)file.exists());
        }
    }

    @Test
    public void testInitFromNonExistingFile() throws ConfigurationException {
        String testProperty = "test.successfull";
        this.conf = new PropertiesConfiguration(testSavePropertiesFile);
        this.conf.addProperty("test.successfull", (Object)Boolean.TRUE);
        this.conf.save();
        PropertiesConfiguration checkConfig = new PropertiesConfiguration(testSavePropertiesFile);
        Assert.assertTrue((String)"Test property not found", (boolean)checkConfig.getBoolean("test.successfull"));
    }

    @Test
    public void testCopyAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.copy(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    public void testAppendAndSave() throws ConfigurationException {
        Configuration copyConf = this.setUpCopyConfig();
        this.conf.append(copyConf);
        this.checkCopiedConfig(copyConf);
    }

    @Test
    public void testSaveWithDataConfig() throws ConfigurationException {
        this.conf = new PropertiesConfiguration(testSavePropertiesFile);
        DataConfiguration dataConfig = new DataConfiguration((Configuration)this.conf);
        dataConfig.setProperty("foo", (Object)"bar");
        Assert.assertEquals((String)"Property not set", (Object)"bar", (Object)this.conf.getString("foo"));
        this.conf.save();
        PropertiesConfiguration config2 = new PropertiesConfiguration(testSavePropertiesFile);
        Assert.assertEquals((String)"Property not saved", (Object)"bar", (Object)config2.getString("foo"));
    }

    @Test
    public void testLoadWithDefaultEncoding() throws ConfigurationException {
        class PropertiesConfigurationTestImpl
        extends PropertiesConfiguration {
            String loadEncoding;

            public PropertiesConfigurationTestImpl(String fileName) throws ConfigurationException {
                super(fileName);
            }

            public void load(InputStream in, String encoding) throws ConfigurationException {
                this.loadEncoding = encoding;
                super.load(in, encoding);
            }
        }
        PropertiesConfigurationTestImpl testConf = new PropertiesConfigurationTestImpl(testProperties);
        Assert.assertEquals((String)"Default encoding not used", (Object)"ISO-8859-1", (Object)testConf.loadEncoding);
    }

    @Test
    public void testGetIOFactoryDefault() {
        Assert.assertNotNull((String)"No default IO factory", (Object)this.conf.getIOFactory());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetIOFactoryNull() {
        this.conf.setIOFactory(null);
    }

    @Test
    public void testSetIOFactoryReader() throws ConfigurationException {
        int propertyCount = 10;
        this.conf.clear();
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in, char delimiter) {
                return new PropertiesReaderTestImpl(in, delimiter, 10);
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, char delimiter) {
                throw new UnsupportedOperationException("Unexpected call!");
            }
        });
        this.conf.load();
        for (int i = 1; i <= 10; ++i) {
            Assert.assertEquals((String)("Wrong property value at " + i), (Object)(PROP_VALUE + i), (Object)this.conf.getString(PROP_NAME + i));
        }
    }

    @Test
    public void testSetIOFactoryWriter() throws ConfigurationException, IOException {
        final PropertiesWriterTestImpl testWriter = new PropertiesWriterTestImpl(',');
        this.conf.setIOFactory(new PropertiesConfiguration.IOFactory(){

            public PropertiesConfiguration.PropertiesReader createPropertiesReader(Reader in, char delimiter) {
                throw new UnsupportedOperationException("Unexpected call!");
            }

            public PropertiesConfiguration.PropertiesWriter createPropertiesWriter(Writer out, char delimiter) {
                return testWriter;
            }
        });
        this.conf.save((Writer)new StringWriter());
        testWriter.close();
        this.checkSavedConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepSeparators() throws ConfigurationException, IOException {
        this.conf.save(testSavePropertiesFile);
        String[] separatorTests = new String[]{"test.separator.equal = foo", "test.separator.colon : foo", "test.separator.tab\tfoo", "test.separator.whitespace foo", "test.separator.no.space=foo"};
        HashSet<String> foundLines = new HashSet<String>();
        BufferedReader in = new BufferedReader(new FileReader(testSavePropertiesFile));
        try {
            String s;
            while ((s = in.readLine()) != null) {
                for (int i = 0; i < separatorTests.length; ++i) {
                    if (!separatorTests[i].equals(s)) continue;
                    foundLines.add(s);
                }
            }
        }
        finally {
            in.close();
        }
        Assert.assertEquals((String)("No all separators were found: " + foundLines), (long)separatorTests.length, (long)foundLines.size());
    }

    @Test
    public void testSlashEscaping() throws ConfigurationException {
        this.conf.setProperty(PROP_NAME, (Object)"http://www.apache.org");
        StringWriter writer = new StringWriter();
        this.conf.save((Writer)writer);
        String s = writer.toString();
        Assert.assertTrue((String)("Value not found: " + s), (s.indexOf("testProperty = http://www.apache.org") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBackslashEscapingInLists() throws Exception {
        this.checkBackslashList("share2");
        this.checkBackslashList("share1");
    }

    @Test
    public void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        this.conf.setDelimiterParsingDisabled(true);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty(prop, list);
        this.conf.setFile(testSavePropertiesFile);
        this.conf.save();
        this.conf.clear();
        this.conf.load();
        Assert.assertEquals((String)"Wrong list property", list, (Object)this.conf.getProperty(prop));
    }

    @Test
    public void testReadFooterComment() {
        Assert.assertEquals((String)"Wrong footer comment", (Object)"\n# This is a foot comment\n", (Object)this.conf.getFooter());
        Assert.assertEquals((String)"Wrong footer comment from layout", (Object)"\nThis is a foot comment\n", (Object)this.conf.getLayout().getCanonicalFooterCooment(false));
    }

    @Test
    public void testWriteFooterComment() throws ConfigurationException, IOException {
        String footer = "my footer";
        this.conf.clear();
        this.conf.setProperty(PROP_NAME, (Object)PROP_VALUE);
        this.conf.setFooter("my footer");
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        Assert.assertEquals((String)"Wrong result", (Object)("testProperty = value" + CR + "# " + "my footer" + CR), (Object)out.toString());
    }

    private void checkBackslashList(String key) {
        Object prop = this.conf.getProperty("test." + key);
        Assert.assertTrue((String)"Not a list", (boolean)(prop instanceof List));
        List list = (List)prop;
        Assert.assertEquals((String)"Wrong number of list elements", (long)2L, (long)list.size());
        String prefix = "\\\\" + key;
        Assert.assertEquals((String)"Wrong element 1", (Object)(prefix + "a"), list.get(0));
        Assert.assertEquals((String)"Wrong element 2", (Object)(prefix + "b"), list.get(1));
    }

    private Configuration setUpCopyConfig() {
        int count = 25;
        BaseConfiguration result = new BaseConfiguration();
        for (int i = 1; i <= 25; ++i) {
            result.addProperty("copyKey" + i, (Object)("copyValue" + i));
        }
        return result;
    }

    private void checkCopiedConfig(Configuration copyConf) throws ConfigurationException {
        this.conf.save(testSavePropertiesFile);
        PropertiesConfiguration checkConf = new PropertiesConfiguration(testSavePropertiesFile);
        Iterator it = copyConf.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Assert.assertEquals((String)("Wrong value for property " + key), (Object)checkConf.getProperty(key), (Object)copyConf.getProperty(key));
        }
    }

    private static class PropertiesWriterTestImpl
    extends PropertiesConfiguration.PropertiesWriter {
        public PropertiesWriterTestImpl(char delimiter) throws IOException {
            super((Writer)new FileWriter(testSavePropertiesFile), delimiter);
        }
    }

    private static class PropertiesReaderTestImpl
    extends PropertiesConfiguration.PropertiesReader {
        private final int maxProperties;
        private int propertyCount;

        public PropertiesReaderTestImpl(Reader reader, char listDelimiter, int maxProps) {
            super(reader, listDelimiter);
            Assert.assertEquals((String)"Wrong list delimiter", (long)44L, (long)listDelimiter);
            this.maxProperties = maxProps;
        }

        public String getPropertyName() {
            return TestPropertiesConfiguration.PROP_NAME + this.propertyCount;
        }

        public String getPropertyValue() {
            return TestPropertiesConfiguration.PROP_VALUE + this.propertyCount;
        }

        public boolean nextProperty() throws IOException {
            ++this.propertyCount;
            return this.propertyCount <= this.maxProperties;
        }
    }

    static class MockHttpURLStreamHandler
    extends URLStreamHandler {
        private int responseCode;
        private File outputFile;
        private MockHttpURLConnection connection;

        public MockHttpURLStreamHandler(int respCode, File outFile) {
            this.responseCode = respCode;
            this.outputFile = outFile;
        }

        public MockHttpURLConnection getMockConnection() {
            return this.connection;
        }

        protected URLConnection openConnection(URL u) throws IOException {
            this.connection = new MockHttpURLConnection(u, this.responseCode, this.outputFile);
            return this.connection;
        }
    }

    static class MockHttpURLConnection
    extends HttpURLConnection {
        private final int returnCode;
        private final File outputFile;

        protected MockHttpURLConnection(URL u, int respCode, File outFile) {
            super(u);
            this.returnCode = respCode;
            this.outputFile = outFile;
        }

        public void disconnect() {
        }

        public boolean usingProxy() {
            return false;
        }

        public void connect() throws IOException {
        }

        public int getResponseCode() throws IOException {
            return this.returnCode;
        }

        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.outputFile);
        }
    }

    static class DummyLayout
    extends PropertiesConfigurationLayout {
        public int loadCalls;

        public DummyLayout(PropertiesConfiguration config) {
            super(config);
        }

        public void load(Reader in) throws ConfigurationException {
            ++this.loadCalls;
        }
    }
}

