/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz77support;

import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParametersTest {
    ParametersTest() {
    }

    private static Parameters newParameters(int windowSize) {
        return Parameters.builder((int)windowSize).build();
    }

    private static Parameters newParameters(int windowSize, int minBackReferenceLength, int maxBackReferenceLength, int maxOffset, int maxLiteralLength) {
        return Parameters.builder((int)windowSize).withMinBackReferenceLength(minBackReferenceLength).withMaxBackReferenceLength(maxBackReferenceLength).withMaxOffset(maxOffset).withMaxLiteralLength(maxLiteralLength).build();
    }

    @Test
    void testAllParametersUsuallyTakeTheirSpecifiedValues() {
        Parameters p = ParametersTest.newParameters(256, 4, 5, 6, 7);
        Assertions.assertEquals((int)256, (int)p.getWindowSize());
        Assertions.assertEquals((int)4, (int)p.getMinBackReferenceLength());
        Assertions.assertEquals((int)5, (int)p.getMaxBackReferenceLength());
        Assertions.assertEquals((int)6, (int)p.getMaxOffset());
        Assertions.assertEquals((int)7, (int)p.getMaxLiteralLength());
    }

    @Test
    void testDefaultConstructor() {
        Parameters p = ParametersTest.newParameters(128);
        Assertions.assertEquals((int)128, (int)p.getWindowSize());
        Assertions.assertEquals((int)3, (int)p.getMinBackReferenceLength());
        Assertions.assertEquals((int)127, (int)p.getMaxBackReferenceLength());
        Assertions.assertEquals((int)127, (int)p.getMaxOffset());
        Assertions.assertEquals((int)128, (int)p.getMaxLiteralLength());
    }

    @Test
    void testMaxBackReferenceLengthIsMinBackReferenceLengthIfBothAreEqual() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 5);
        Assertions.assertEquals((int)3, (int)p.getMaxBackReferenceLength());
    }

    @Test
    void testMaxBackReferenceLengthIsMinBackReferenceLengthWhenSmallerThanMinBackReferenceLength() {
        Parameters p = ParametersTest.newParameters(128, 2, 2, 4, 5);
        Assertions.assertEquals((int)3, (int)p.getMaxBackReferenceLength());
    }

    @Test
    void testMaxBackReferenceLengthIsMinBackReferenceLengthWhenSmallerThanMinBackReferenceLengthReversedInvocationOrder() {
        Parameters p = Parameters.builder((int)128).withMaxBackReferenceLength(2).withMinBackReferenceLength(2).withMaxOffset(4).withMaxLiteralLength(5).build();
        Assertions.assertEquals((int)3, (int)p.getMaxBackReferenceLength());
    }

    @Test
    void testMaxLiteralLengthIsWindowSizeIfSetTo0() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 0);
        Assertions.assertEquals((int)128, (int)p.getMaxLiteralLength());
    }

    @Test
    void testMaxLiteralLengthIsWindowSizeIfSetToANegativeValue() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, -1);
        Assertions.assertEquals((int)128, (int)p.getMaxLiteralLength());
    }

    @Test
    void testMaxLiteralLengthIsWindowSizeIfSetToAValueTooBigToHoldInSlidingWindow() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, 259);
        Assertions.assertEquals((int)128, (int)p.getMaxLiteralLength());
    }

    @Test
    void testMaxOffsetIsWindowSizeMinus1IfBiggerThanWindowSize() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 129, 5);
        Assertions.assertEquals((int)127, (int)p.getMaxOffset());
    }

    @Test
    void testMaxOffsetIsWindowSizeMinus1IfSetTo0() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 0, 5);
        Assertions.assertEquals((int)127, (int)p.getMaxOffset());
    }

    @Test
    void testMaxOffsetIsWindowSizeMinus1IfSetToANegativeValue() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, -1, 5);
        Assertions.assertEquals((int)127, (int)p.getMaxOffset());
    }

    @Test
    void testMinBackReferenceLengthIsAtLeastThree() {
        Parameters p = ParametersTest.newParameters(128, 2, 3, 4, 5);
        Assertions.assertEquals((int)3, (int)p.getMinBackReferenceLength());
    }

    @Test
    void testWindowSizeMustBeAPowerOfTwo() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParametersTest.newParameters(100, 200, 300, 400, 500));
    }

    @Test
    void testWindowSizeMustNotBeSmallerThanMinBackReferenceLength() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ParametersTest.newParameters(128, 200, 300, 400, 500));
    }
}

