/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.MultiReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class MultiReadOnlySeekableByteChannelTest {
    private void check(byte[] expected) throws IOException {
        for (int channelSize = 1; channelSize <= expected.length; ++channelSize) {
            try (SeekableByteChannel single = this.makeSingle(expected);){
                this.check(expected, single);
            }
            try (SeekableByteChannel multi = this.makeMulti(this.grouped(expected, channelSize));){
                this.check(expected, multi);
                continue;
            }
        }
    }

    private void check(byte[] expected, SeekableByteChannel channel) throws IOException {
        for (int readBufferSize = 1; readBufferSize <= expected.length + 5; ++readBufferSize) {
            this.check(expected, channel, readBufferSize);
        }
    }

    private void check(byte[] expected, SeekableByteChannel channel, int readBufferSize) throws IOException {
        Assertions.assertTrue((boolean)channel.isOpen(), (String)("readBufferSize " + readBufferSize));
        Assertions.assertEquals((long)expected.length, (long)channel.size(), (String)("readBufferSize " + readBufferSize));
        channel.position(0L);
        Assertions.assertEquals((long)0L, (long)channel.position(), (String)("readBufferSize " + readBufferSize));
        Assertions.assertEquals((int)0, (int)channel.read(ByteBuffer.allocate(0)), (String)("readBufferSize " + readBufferSize));
        ByteBuffer resultBuffer = ByteBuffer.allocate(expected.length + 100);
        ByteBuffer buf = ByteBuffer.allocate(readBufferSize);
        int bytesRead = channel.read(buf);
        while (bytesRead != -1) {
            int remaining = buf.remaining();
            buf.flip();
            resultBuffer.put(buf);
            buf.clear();
            bytesRead = channel.read(buf);
            if (resultBuffer.position() < expected.length) {
                Assertions.assertEquals((int)0, (int)remaining, (String)("readBufferSize " + readBufferSize));
            }
            if (bytesRead == -1) {
                Assertions.assertEquals((int)0, (int)buf.position(), (String)("readBufferSize " + readBufferSize));
                continue;
            }
            Assertions.assertEquals((int)bytesRead, (int)buf.position(), (String)("readBufferSize " + readBufferSize));
        }
        resultBuffer.flip();
        byte[] arr = new byte[resultBuffer.remaining()];
        resultBuffer.get(arr);
        Assertions.assertArrayEquals((byte[])expected, (byte[])arr, (String)("readBufferSize " + readBufferSize));
    }

    private void checkEmpty(SeekableByteChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(10);
        Assertions.assertTrue((boolean)channel.isOpen());
        Assertions.assertEquals((long)0L, (long)channel.size());
        Assertions.assertEquals((long)0L, (long)channel.position());
        Assertions.assertEquals((int)-1, (int)channel.read(buf));
        channel.position(5L);
        Assertions.assertEquals((int)-1, (int)channel.read(buf));
        channel.close();
        Assertions.assertFalse((boolean)channel.isOpen());
        Assertions.assertThrows(ClosedChannelException.class, () -> channel.read(buf), (String)"expected a ClosedChannelException");
        Assertions.assertThrows(ClosedChannelException.class, () -> channel.position(100L), (String)"expected a ClosedChannelException");
    }

    private byte[][] grouped(byte[] input, int chunkSize) {
        ArrayList<byte[]> groups = new ArrayList<byte[]>();
        int idx = 0;
        while (idx + chunkSize <= input.length) {
            groups.add(Arrays.copyOfRange(input, idx, idx + chunkSize));
            idx += chunkSize;
        }
        if (idx < input.length) {
            groups.add(Arrays.copyOfRange(input, idx, input.length));
        }
        return (byte[][])groups.toArray((T[])new byte[0][]);
    }

    private SeekableByteChannel makeEmpty() {
        return this.makeSingle(ByteUtils.EMPTY_BYTE_ARRAY);
    }

    private SeekableByteChannel makeMulti(byte[][] arr) {
        SeekableByteChannel[] s = new SeekableByteChannel[arr.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.makeSingle(arr[i]);
        }
        return MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])s);
    }

    private SeekableByteChannel makeSingle(byte[] arr) {
        return new SeekableInMemoryByteChannel(arr);
    }

    @Test
    public void testCantPositionToANegativePosition() throws IOException {
        try (SeekableByteChannel s = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{this.makeEmpty(), this.makeEmpty()});){
            Assertions.assertThrows(IllegalArgumentException.class, () -> s.position(-1L));
        }
    }

    @Test
    public void testCantTruncate() throws IOException {
        try (SeekableByteChannel s = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{this.makeEmpty(), this.makeEmpty()});){
            Assertions.assertThrows(NonWritableChannelException.class, () -> s.truncate(1L));
        }
    }

    @Test
    public void testCantWrite() throws IOException {
        try (SeekableByteChannel s = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{this.makeEmpty(), this.makeEmpty()});){
            Assertions.assertThrows(NonWritableChannelException.class, () -> s.write(ByteBuffer.allocate(10)));
        }
    }

    private SeekableByteChannel testChannel() {
        return MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{this.makeEmpty(), this.makeEmpty()});
    }

    @Test
    public void testCheckForSingleByte() throws IOException {
        this.check(new byte[]{0});
    }

    @Test
    public void testCheckForString() throws IOException {
        this.check("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes(StandardCharsets.UTF_8));
    }

    @Test
    public void testCloseIsIdempotent() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
        }
    }

    @Test
    public void testClosesAllAndThrowsExceptionIfCloseThrows() {
        SeekableByteChannel[] ts = new ThrowingSeekableByteChannel[]{new ThrowingSeekableByteChannel(), new ThrowingSeekableByteChannel()};
        SeekableByteChannel s = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])ts);
        Assertions.assertThrows(IOException.class, s::close, (String)"IOException expected");
        Assertions.assertFalse((boolean)ts[0].isOpen());
        Assertions.assertFalse((boolean)ts[1].isOpen());
    }

    @Test
    public void testConstructorThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> new MultiReadOnlySeekableByteChannel(null));
    }

    @Test
    public void testForFilesThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> MultiReadOnlySeekableByteChannel.forFiles((File[])null));
    }

    @Test
    public void testForSeekableByteChannelsReturnsIdentityForSingleElement() throws IOException {
        try (SeekableByteChannel e = this.makeEmpty();
             SeekableByteChannel m = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{e});){
            Assertions.assertSame((Object)e, (Object)m);
        }
    }

    @Test
    public void testForSeekableByteChannelsThrowsOnNullArg() {
        Assertions.assertThrows(NullPointerException.class, () -> MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])null));
    }

    @Test
    public void testReadingFromAPositionAfterEndReturnsEOF() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            c.position(2L);
            Assertions.assertEquals((long)2L, (long)c.position());
            ByteBuffer readBuffer = ByteBuffer.allocate(5);
            Assertions.assertEquals((int)-1, (int)c.read(readBuffer));
        }
    }

    @Test
    public void testReferenceBehaviorForEmptyChannel() throws IOException {
        this.checkEmpty(this.makeEmpty());
    }

    @Test
    public void testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, () -> c.position(0L));
        }
    }

    @Test
    public void testThrowsClosedChannelExceptionWhenSizeIsReadOnClosedChannel() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, () -> c.size());
        }
    }

    @Test
    public void testThrowsIOExceptionWhenPositionIsSetToANegativeValue() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.position(-1L));
        }
    }

    @Test
    public void testTwoEmptyChannelsConcatenateAsEmptyChannel() throws IOException {
        try (SeekableByteChannel channel = MultiReadOnlySeekableByteChannel.forSeekableByteChannels((SeekableByteChannel[])new SeekableByteChannel[]{this.makeEmpty(), this.makeEmpty()});){
            this.checkEmpty(channel);
        }
    }

    @Test
    public void testVerifyGrouped() {
        Assertions.assertArrayEquals((Object[])new byte[][]{{1, 2, 3}, {4, 5, 6}, {7}}, (Object[])this.grouped(new byte[]{1, 2, 3, 4, 5, 6, 7}, 3));
        Assertions.assertArrayEquals((Object[])new byte[][]{{1, 2, 3}, {4, 5, 6}}, (Object[])this.grouped(new byte[]{1, 2, 3, 4, 5, 6}, 3));
        Assertions.assertArrayEquals((Object[])new byte[][]{{1, 2, 3}, {4, 5}}, (Object[])this.grouped(new byte[]{1, 2, 3, 4, 5}, 3));
    }

    @Test
    @Disabled(value="we deliberately violate the spec")
    public void throwsClosedChannelExceptionWhenPositionIsReadOnClosedChannel() throws Exception {
        try (SeekableByteChannel c = this.testChannel();){
            c.close();
            c.position();
        }
    }

    private static final class ThrowingSeekableByteChannel
    implements SeekableByteChannel {
        private boolean closed;

        private ThrowingSeekableByteChannel() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            throw new IOException("foo");
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public long position() {
            return 0L;
        }

        @Override
        public SeekableByteChannel position(long newPosition) {
            return this;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return -1;
        }

        @Override
        public long size() throws IOException {
            return 0L;
        }

        @Override
        public SeekableByteChannel truncate(long size) {
            return this;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return 0;
        }
    }
}

