/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.utils.ChecksumVerifyingInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChecksumVerifyingInputStreamTest {
    @Test
    public void testReadTakingByteArrayThrowsIOException() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[3];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)adler32, (InputStream)byteArrayInputStream, -1859L, -68L);){
            Assertions.assertThrows(IOException.class, () -> checksumVerifyingInputStream.read(byteArray));
        }
    }

    @Test
    public void testReadTakingNoArgumentsThrowsIOException() throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] byteArray = new byte[9];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)crc32, (InputStream)byteArrayInputStream, 1L, 1L);){
            Assertions.assertThrows(IOException.class, () -> checksumVerifyingInputStream.read());
        }
    }

    @Test
    public void testSkip() throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] byteArray = new byte[4];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumVerifyingInputStream checksumVerifyingInputStream = new ChecksumVerifyingInputStream((Checksum)crc32, (InputStream)byteArrayInputStream, 33L, 2303L);){
            int intOne = checksumVerifyingInputStream.read(byteArray);
            long skipReturnValue = checksumVerifyingInputStream.skip(1L);
            Assertions.assertEquals((long)558161692L, (long)crc32.getValue());
            Assertions.assertEquals((int)0, (int)byteArrayInputStream.available());
            Assertions.assertArrayEquals((byte[])new byte[4], (byte[])byteArray);
            Assertions.assertEquals((long)0L, (long)skipReturnValue);
        }
    }
}

