/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.memory;

import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.memory.MemoryArchiveEntry;

public final class MemoryArchiveInputStream
extends ArchiveInputStream<MemoryArchiveEntry> {
    private final String[] fileNames;
    private final String[] content;
    private int p;

    public MemoryArchiveInputStream(String[][] pFiles) {
        int pFilesLength = pFiles.length;
        this.fileNames = new String[pFilesLength];
        this.content = new String[pFilesLength];
        for (int i = 0; i < pFilesLength; ++i) {
            String[] nameAndContent = pFiles[i];
            this.fileNames[i] = nameAndContent[0];
            this.content[i] = nameAndContent[1];
        }
        this.p = 0;
    }

    public MemoryArchiveEntry getNextEntry() throws IOException {
        if (this.p >= this.fileNames.length) {
            return null;
        }
        return new MemoryArchiveEntry(this.fileNames[this.p]);
    }

    public int read() throws IOException {
        return 0;
    }

    public String readString() {
        return this.content[this.p++];
    }
}

