/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Expander;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.runners.Parameterized;

public class ParameterizedExpanderTest
extends AbstractTest {
    private File archive;

    @Parameterized.Parameters(name="format={0}")
    public static Stream<Arguments> data() {
        return Stream.of(Arguments.of((Object[])new Object[]{"tar"}), Arguments.of((Object[])new Object[]{"cpio"}), Arguments.of((Object[])new Object[]{"zip"}));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void archiveInputStreamVersion(String format) throws Exception {
        this.setUp(format);
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));
             ArchiveInputStream ais = ArchiveStreamFactory.DEFAULT.createArchiveInputStream(format, (InputStream)i);){
            new Expander().expand(ais, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    private void assertHelloWorld(String fileName, String suffix) throws IOException {
        Assertions.assertTrue((boolean)new File(this.tempResultDir, fileName).isFile(), (String)(fileName + " does not exist"));
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = Files.readAllBytes(this.tempResultDir.toPath().resolve(fileName));
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void channelVersion(String format) throws Exception {
        this.setUp(format);
        try (FileChannel c = FileChannel.open(this.archive.toPath(), StandardOpenOption.READ);){
            new Expander().expand(format, (SeekableByteChannel)c, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void fileVersion(String format) throws Exception {
        this.setUp(format);
        new Expander().expand(format, this.archive, this.tempResultDir);
        this.verifyTargetDir();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void fileVersionWithAutoDetection(String format) throws Exception {
        this.setUp(format);
        new Expander().expand(this.archive, this.tempResultDir);
        this.verifyTargetDir();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void inputStreamVersion(String format) throws Exception {
        this.setUp(format);
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand(format, (InputStream)i, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void inputStreamVersionWithAutoDetection(String format) throws Exception {
        this.setUp(format);
        try (BufferedInputStream i = new BufferedInputStream(Files.newInputStream(this.archive.toPath(), new OpenOption[0]));){
            new Expander().expand((InputStream)i, this.tempResultDir);
        }
        this.verifyTargetDir();
    }

    public void setUp(String format) throws Exception {
        this.archive = this.newTempFile("test." + format);
        File dummy = this.newTempFile("x");
        try (OutputStream o = Files.newOutputStream(dummy.toPath(), new OpenOption[0]);){
            o.write(new byte[14]);
        }
        try (ArchiveOutputStream aos = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream(format, Files.newOutputStream(this.archive.toPath(), new OpenOption[0]));){
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile().toPath(), "a", new LinkOption[0]));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(this.getTempDirFile(), "a/b/c"));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/d.txt"));
            aos.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.putArchiveEntry(aos.createArchiveEntry(dummy, "a/b/c/e.txt"));
            aos.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
            aos.closeArchiveEntry();
            aos.finish();
        }
    }

    private void verifyTargetDir() throws IOException {
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a").isDirectory(), (String)"a has not been created");
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a/b").isDirectory(), (String)"a/b has not been created");
        Assertions.assertTrue((boolean)new File(this.tempResultDir, "a/b/c").isDirectory(), (String)"a/b/c has not been created");
        this.assertHelloWorld("a/b/d.txt", "1");
        this.assertHelloWorld("a/b/c/e.txt", "2");
    }
}

