/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SeekableInMemoryByteChannelTest {
    private final byte[] testData = "Some data".getBytes(StandardCharsets.UTF_8);

    @Test
    public void testCloseIsIdempotent() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
            c.close();
            Assertions.assertFalse((boolean)c.isOpen());
        }
    }

    @Test
    public void testReadingFromAPositionAfterEndReturnsEOF() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.position(2L);
            Assertions.assertEquals((long)2L, (long)c.position());
            ByteBuffer readBuffer = ByteBuffer.allocate(5);
            Assertions.assertEquals((int)-1, (int)c.read(readBuffer));
        }
    }

    @Test
    public void testShouldReadContentsProperly() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((int)this.testData.length, (int)readCount);
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])readBuffer.array());
            Assertions.assertEquals((long)this.testData.length, (long)c.position());
        }
    }

    @Test
    public void testShouldReadContentsWhenBiggerBufferSupplied() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length + 1);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((int)this.testData.length, (int)readCount);
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(readBuffer.array(), this.testData.length));
            Assertions.assertEquals((long)this.testData.length, (long)c.position());
        }
    }

    @Test
    public void testShouldReadDataFromSetPosition() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(4);
            c.position(5L);
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((long)4L, (long)readCount);
            Assertions.assertEquals((Object)"data", (Object)new String(readBuffer.array(), StandardCharsets.UTF_8));
            Assertions.assertEquals((long)this.testData.length, (long)c.position());
        }
    }

    @Test
    public void testShouldSetProperPosition() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            long posAtFour = c.position(4L).position();
            long posAtTheEnd = c.position((long)this.testData.length).position();
            long posPastTheEnd = c.position((long)this.testData.length + 1L).position();
            Assertions.assertEquals((long)4L, (long)posAtFour);
            Assertions.assertEquals((long)c.size(), (long)posAtTheEnd);
            Assertions.assertEquals((long)((long)this.testData.length + 1L), (long)posPastTheEnd);
        }
    }

    @Test
    public void testShouldSetProperPositionOnTruncate() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.position((long)this.testData.length);
            c.truncate(4L);
            Assertions.assertEquals((long)4L, (long)c.position());
            Assertions.assertEquals((long)4L, (long)c.size());
        }
    }

    @Test
    public void testShouldSignalEOFWhenPositionAtTheEnd() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
            c.position((long)(this.testData.length + 1));
            int readCount = c.read(readBuffer);
            Assertions.assertEquals((long)0L, (long)readBuffer.position());
            Assertions.assertEquals((int)-1, (int)readCount);
            Assertions.assertEquals((int)-1, (int)c.read(readBuffer));
        }
    }

    @Test
    public void testShouldThrowExceptionOnReadingClosedChannel() {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> c.read(ByteBuffer.allocate(1)));
    }

    @Test
    public void testShouldThrowExceptionOnWritingToClosedChannel() {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.close();
        Assertions.assertThrows(ClosedChannelException.class, () -> c.write(ByteBuffer.allocate(1)));
    }

    @Test
    public void testShouldThrowExceptionWhenSettingIncorrectPosition() {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            Assertions.assertThrows(IOException.class, () -> c.position(0x80000000L));
        }
    }

    @Test
    public void testShouldThrowExceptionWhenTruncatingToIncorrectSize() {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> c.truncate(0x80000000L));
        }
    }

    @Test
    public void testShouldTruncateContentsProperly() {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.truncate(4L);
            byte[] bytes = Arrays.copyOf(c.array(), (int)c.size());
            Assertions.assertEquals((Object)"Some", (Object)new String(bytes, StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testShouldWriteDataProperly() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            ByteBuffer inData = ByteBuffer.wrap(this.testData);
            int writeCount = c.write(inData);
            Assertions.assertEquals((int)this.testData.length, (int)writeCount);
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(c.array(), (int)c.size()));
            Assertions.assertEquals((long)this.testData.length, (long)c.position());
        }
    }

    @Test
    public void testShouldWriteDataProperlyAfterPositionSet() throws IOException {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            ByteBuffer inData = ByteBuffer.wrap(this.testData);
            ByteBuffer expectedData = ByteBuffer.allocate(this.testData.length + 5).put(this.testData, 0, 5).put(this.testData);
            c.position(5L);
            int writeCount = c.write(inData);
            Assertions.assertEquals((int)this.testData.length, (int)writeCount);
            Assertions.assertArrayEquals((byte[])expectedData.array(), (byte[])Arrays.copyOf(c.array(), (int)c.size()));
            Assertions.assertEquals((long)(this.testData.length + 5), (long)c.position());
        }
    }

    @Test
    public void testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.close();
            Assertions.assertThrows(ClosedChannelException.class, () -> SeekableInMemoryByteChannelTest.lambda$testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel$4((SeekableByteChannel)c));
        }
    }

    @Test
    public void testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            Assertions.assertThrows(IllegalArgumentException.class, () -> SeekableInMemoryByteChannelTest.lambda$testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize$5((SeekableByteChannel)c));
        }
    }

    @Test
    public void testThrowsIOExceptionWhenPositionIsSetToANegativeValue() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            Assertions.assertThrows(IOException.class, () -> SeekableInMemoryByteChannelTest.lambda$testThrowsIOExceptionWhenPositionIsSetToANegativeValue$6((SeekableByteChannel)c));
        }
    }

    @Test
    public void testTruncateDoesntChangeSmallPosition() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.position(1L);
            c.truncate(this.testData.length - 1);
            Assertions.assertEquals((long)(this.testData.length - 1), (long)c.size());
            Assertions.assertEquals((long)1L, (long)c.position());
        }
    }

    @Test
    public void testTruncateMovesPositionWhenNewSizeIsBiggerThanSizeAndPositionIsEvenBigger() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.position(2 * this.testData.length);
            c.truncate(this.testData.length + 1);
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            Assertions.assertEquals((long)(this.testData.length + 1), (long)c.position());
        }
    }

    @Test
    public void testTruncateMovesPositionWhenNotResizingButPositionBiggerThanSize() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.position(2 * this.testData.length);
            c.truncate(this.testData.length);
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            Assertions.assertEquals((long)this.testData.length, (long)c.position());
        }
    }

    @Test
    public void testTruncateMovesPositionWhenShrinkingBeyondPosition() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            c.position(4L);
            c.truncate(3L);
            Assertions.assertEquals((long)3L, (long)c.size());
            Assertions.assertEquals((long)3L, (long)c.position());
        }
    }

    @Test
    public void testTruncateToBiggerSizeDoesntChangeAnything() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            c.truncate(this.testData.length + 1);
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
            Assertions.assertEquals((int)this.testData.length, (int)c.read(readBuffer));
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(readBuffer.array(), this.testData.length));
        }
    }

    @Test
    public void testTruncateToCurrentSizeDoesntChangeAnything() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);){
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            c.truncate(this.testData.length);
            Assertions.assertEquals((long)this.testData.length, (long)c.size());
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
            Assertions.assertEquals((int)this.testData.length, (int)c.read(readBuffer));
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(readBuffer.array(), this.testData.length));
        }
    }

    @Test
    @Disabled(value="we deliberately violate the spec")
    public void throwsClosedChannelExceptionWhenPositionIsReadOnClosedChannel() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.close();
            c.position();
        }
    }

    @Test
    @Disabled(value="we deliberately violate the spec")
    public void throwsClosedChannelExceptionWhenSizeIsReadOnClosedChannel() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.close();
            c.size();
        }
    }

    @Test
    @Disabled(value="we deliberately violate the spec")
    public void throwsClosedChannelExceptionWhenTruncateIsCalledOnClosedChannel() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.close();
            c.truncate(0L);
        }
    }

    public void writingToAPositionAfterEndGrowsChannel() throws Exception {
        try (SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();){
            c.position(2L);
            Assertions.assertEquals((long)2L, (long)c.position());
            ByteBuffer inData = ByteBuffer.wrap(this.testData);
            Assertions.assertEquals((int)this.testData.length, (int)c.write(inData));
            Assertions.assertEquals((long)(this.testData.length + 2), (long)c.size());
            c.position(2L);
            ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
            c.read(readBuffer);
            Assertions.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(readBuffer.array(), this.testData.length));
        }
    }

    private static /* synthetic */ void lambda$testThrowsIOExceptionWhenPositionIsSetToANegativeValue$6(SeekableByteChannel c) throws Throwable {
        c.position(-1L);
    }

    private static /* synthetic */ void lambda$testThrowsIllegalArgumentExceptionWhenTruncatingToANegativeSize$5(SeekableByteChannel c) throws Throwable {
        c.truncate(-1L);
    }

    private static /* synthetic */ void lambda$testThrowsClosedChannelExceptionWhenPositionIsSetOnClosedChannel$4(SeekableByteChannel c) throws Throwable {
        c.position(0L);
    }
}

